/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.piece.room;

import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.TemplateManager;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.Node;
import xiroc.dungeoncrawl.dungeon.StructurePieceTypes;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelFeature;
import xiroc.dungeoncrawl.dungeon.model.DungeonModels;
import xiroc.dungeoncrawl.dungeon.piece.DungeonNodeConnector;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;
import xiroc.dungeoncrawl.dungeon.treasure.Treasure;
import xiroc.dungeoncrawl.theme.Theme;
import xiroc.dungeoncrawl.util.Orientation;
import xiroc.dungeoncrawl.util.Position2D;
import xiroc.dungeoncrawl.util.WeightedRandomInteger;

public class DungeonNodeRoom
extends DungeonPiece {
    public Node node;
    public boolean large;
    public boolean lootRoom;

    public DungeonNodeRoom() {
        super(StructurePieceTypes.NODE_ROOM);
    }

    public DungeonNodeRoom(TemplateManager manager, CompoundNBT nbt) {
        super(StructurePieceTypes.NODE_ROOM, nbt);
        this.large = nbt.func_74767_n("large");
        this.lootRoom = nbt.func_74767_n("lootRoom");
        this.setupBoundingBox();
    }

    @Override
    public void setupModel(DungeonBuilder builder, DungeonModels.ModelCategory layerCategory, List<DungeonPiece> pieces, Random rand) {
        WeightedRandomInteger provider;
        DungeonModels.ModelCategory base;
        if (this.lootRoom) {
            this.node = Node.ALL;
            this.modelID = DungeonModels.LOOT_ROOM.id;
            return;
        }
        this.large = this.stage >= 2 && (double)rand.nextFloat() < 0.15;
        switch (this.connectedSides) {
            case 1: {
                base = DungeonModels.ModelCategory.NODE_DEAD_END;
                this.node = Node.DEAD_END;
                break;
            }
            case 2: {
                if (this.sides[0] && this.sides[2] || this.sides[1] && this.sides[3]) {
                    base = DungeonModels.ModelCategory.NODE_STRAIGHT;
                    this.node = Node.STRAIGHT;
                    break;
                }
                base = DungeonModels.ModelCategory.NODE_TURN;
                this.node = Node.TURN;
                break;
            }
            case 3: {
                base = DungeonModels.ModelCategory.NODE_FORK;
                this.node = Node.FORK;
                break;
            }
            default: {
                base = DungeonModels.ModelCategory.NODE_FULL;
                this.node = Node.ALL;
            }
        }
        WeightedRandomInteger weightedRandomInteger = provider = this.large ? DungeonModels.ModelCategory.get(DungeonModels.ModelCategory.LARGE_NODE, layerCategory, base) : DungeonModels.ModelCategory.get(DungeonModels.ModelCategory.NORMAL_NODE, layerCategory, base);
        if (provider == null) {
            DungeonCrawl.LOGGER.error("Didnt find a model provider for {} in stage {}. Connected Sides: {}, Base: {}", (Object)this, (Object)this.stage, (Object)this.connectedSides, (Object)base);
            this.modelID = this.large ? 33 : 38;
            return;
        }
        Integer id = provider.roll(rand);
        if (id == null) {
            DungeonCrawl.LOGGER.error("Empty model provider for {} in stage {}. Connected Sides: {}, Base: {}", (Object)this, (Object)this.stage, (Object)this.connectedSides, (Object)base);
            this.modelID = this.large ? 33 : 38;
            return;
        }
        this.modelID = id;
    }

    @Override
    public void setRealPosition(int x, int y, int z) {
        if (this.large) {
            super.setRealPosition(x - 9, y, z - 9);
        } else {
            super.setRealPosition(x - 4, y, z - 4);
        }
    }

    @Override
    public void customSetup(Random rand) {
        DungeonModel model = DungeonModels.MODELS.get(this.modelID);
        if (model.metadata != null) {
            if (model.metadata.featureMetadata != null && model.featurePositions != null && model.featurePositions.length > 0) {
                DungeonModelFeature.setup(this, model, model.featurePositions, this.field_186169_c, rand, model.metadata.featureMetadata, this.x, this.y, this.z);
            }
            if (model.metadata.variation) {
                this.variation = new byte[16];
                for (int i = 0; i < this.variation.length; ++i) {
                    this.variation[i] = (byte)rand.nextInt(32);
                }
            }
        }
    }

    public boolean func_230383_a_(ISeedReader worldIn, StructureManager p_230383_2_, ChunkGenerator p_230383_3_, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
        DungeonModel model = DungeonModels.MODELS.get(this.modelID);
        Vector3i offset = DungeonModels.getOffset(this.modelID);
        BlockPos pos = new BlockPos(this.x + offset.func_177958_n(), this.y + offset.func_177956_o(), this.z + offset.func_177952_p());
        this.buildRotated(model, (IWorld)worldIn, structureBoundingBoxIn, pos, Theme.get(this.theme), Theme.getSub(this.subTheme), Treasure.getModelTreasureType(this.modelID), this.stage, this.field_186169_c, false);
        this.entrances(worldIn, structureBoundingBoxIn, model);
        if (model.metadata != null && model.metadata.feature != null && this.featurePositions != null) {
            model.metadata.feature.build((IWorld)worldIn, randomIn, pos, this.featurePositions, structureBoundingBoxIn, this.theme, this.subTheme, this.stage);
        }
        this.decorate((IWorld)worldIn, pos, model.width, model.height, model.length, Theme.get(this.theme), structureBoundingBoxIn, this.field_74887_e, model);
        if (((Boolean)Config.NO_SPAWNERS.get()).booleanValue()) {
            DungeonNodeRoom.spawnMobs(worldIn, this, model.width, model.length, new int[]{offset.func_177956_o()});
        }
        return true;
    }

    @Override
    public void setupBoundingBox() {
        Vector3i offset = DungeonModels.getOffset(this.modelID);
        this.field_74887_e = this.large ? new MutableBoundingBox(this.x, this.y + offset.func_177956_o(), this.z, this.x + 26, this.y + offset.func_177956_o() + 8, this.z + 26) : new MutableBoundingBox(this.x, this.y + offset.func_177956_o(), this.z, this.x + 16, this.y + offset.func_177956_o() + 8, this.z + 16);
    }

    @Override
    public int getType() {
        return 10;
    }

    @Override
    public boolean canConnect(Direction side) {
        return this.node.canConnect(side);
    }

    @Override
    public boolean hasChildPieces() {
        return !this.large;
    }

    @Override
    public void addChildPieces(List<DungeonPiece> pieces, DungeonBuilder builder, DungeonModels.ModelCategory layerCategory, int layer, Random rand) {
        DungeonNodeConnector connector;
        super.addChildPieces(pieces, builder, layerCategory, layer, rand);
        if (this.large) {
            return;
        }
        if (this.sides[0]) {
            connector = new DungeonNodeConnector();
            connector.field_186169_c = Orientation.getOppositeRotationFromFacing(Direction.NORTH);
            connector.theme = this.theme;
            connector.subTheme = this.subTheme;
            connector.stage = this.stage;
            connector.setupModel(builder, layerCategory, pieces, rand);
            connector.setRealPosition(this.x + 7, this.y, this.z - 5);
            connector.adjustPositionAndBounds();
            pieces.add(connector);
        }
        if (this.sides[1]) {
            connector = new DungeonNodeConnector();
            connector.field_186169_c = Orientation.getOppositeRotationFromFacing(Direction.EAST);
            connector.theme = this.theme;
            connector.subTheme = this.subTheme;
            connector.stage = this.stage;
            connector.setupModel(builder, layerCategory, pieces, rand);
            connector.setRealPosition(this.x + 17, this.y, this.z + 7);
            connector.adjustPositionAndBounds();
            pieces.add(connector);
        }
        if (this.sides[2]) {
            connector = new DungeonNodeConnector();
            connector.field_186169_c = Orientation.getOppositeRotationFromFacing(Direction.SOUTH);
            connector.theme = this.theme;
            connector.subTheme = this.subTheme;
            connector.stage = this.stage;
            connector.setupModel(builder, layerCategory, pieces, rand);
            connector.setRealPosition(this.x + 7, this.y, this.z + 17);
            connector.adjustPositionAndBounds();
            pieces.add(connector);
        }
        if (this.sides[3]) {
            connector = new DungeonNodeConnector();
            connector.field_186169_c = Orientation.getOppositeRotationFromFacing(Direction.WEST);
            connector.theme = this.theme;
            connector.subTheme = this.subTheme;
            connector.stage = this.stage;
            connector.setupModel(builder, layerCategory, pieces, rand);
            connector.setRealPosition(this.x - 5, this.y, this.z + 7);
            connector.adjustPositionAndBounds();
            pieces.add(connector);
        }
    }

    @Override
    public Tuple<Position2D, Position2D> getAlternativePath(Position2D current, Position2D end) {
        if (!current.hasFacing()) {
            throw new RuntimeException("The current Position needs to provide a facing.");
        }
        Position2D center = new Position2D(this.posX, this.posZ);
        return new Tuple((Object)center.shift(this.node.findClosest(current.facing), 1), (Object)center.shift(this.findExitToPosition(end), 1));
    }

    @Override
    public boolean hasAlternativePath() {
        return true;
    }

    private Direction findExitToPosition(Position2D pos) {
        if (pos.hasFacing()) {
            return this.node.findClosest(pos.facing);
        }
        if (pos.x > this.posX) {
            if (pos.z > this.posZ) {
                return Direction.SOUTH;
            }
            if (pos.z < this.posZ) {
                return Direction.NORTH;
            }
            return Direction.EAST;
        }
        if (pos.x < this.posX) {
            if (pos.z > this.posZ) {
                return Direction.SOUTH;
            }
            if (pos.z < this.posZ) {
                return Direction.NORTH;
            }
            return Direction.WEST;
        }
        if (pos.z > this.posZ) {
            return Direction.SOUTH;
        }
        if (pos.z < this.posZ) {
            return Direction.NORTH;
        }
        DungeonCrawl.LOGGER.error("Invalid Position: {},{}", (Object)pos.x, (Object)pos.z);
        throw new RuntimeException("Invalid position: (" + pos.x + "/" + pos.z + ")");
    }

    @Override
    public void func_143011_b(CompoundNBT tagCompound) {
        super.func_143011_b(tagCompound);
        tagCompound.func_74757_a("large", this.large);
        tagCompound.func_74757_a("lootRoom", this.lootRoom);
    }
}

