/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.piece.room;

import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.TemplateManager;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.StructurePieceTypes;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.model.DungeonModels;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;
import xiroc.dungeoncrawl.dungeon.treasure.Treasure;
import xiroc.dungeoncrawl.theme.Theme;

public class DungeonRoom
extends DungeonPiece {
    public DungeonRoom(TemplateManager manager, CompoundNBT p_i51343_2_) {
        super(StructurePieceTypes.ROOM, p_i51343_2_);
    }

    @Override
    public void setupModel(DungeonBuilder builder, DungeonModels.ModelCategory layerCategory, List<DungeonPiece> pieces, Random rand) {
        this.modelID = DungeonModels.ModelCategory.get(DungeonModels.ModelCategory.ROOM, layerCategory).roll(rand);
    }

    public boolean func_230383_a_(ISeedReader worldIn, StructureManager p_230383_2_, ChunkGenerator p_230383_3_, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
        DungeonModel model = DungeonModels.MODELS.get(this.modelID);
        if (model == null) {
            return false;
        }
        BlockPos pos = new BlockPos(this.x, this.y + DungeonModels.getOffset(this.modelID).func_177956_o(), this.z);
        this.build(model, (IWorld)worldIn, structureBoundingBoxIn, pos, Theme.get(this.theme), Theme.getSub(this.subTheme), Treasure.Type.DEFAULT, this.stage, false);
        this.entrances(worldIn, structureBoundingBoxIn, model);
        if (model.metadata != null && model.metadata.feature != null && this.featurePositions != null) {
            model.metadata.feature.build((IWorld)worldIn, randomIn, pos, this.featurePositions, structureBoundingBoxIn, this.theme, this.subTheme, this.stage);
        }
        this.decorate((IWorld)worldIn, pos, model.width, model.height, model.length, Theme.get(this.theme), structureBoundingBoxIn, this.field_74887_e, model);
        if (((Boolean)Config.NO_SPAWNERS.get()).booleanValue()) {
            DungeonRoom.spawnMobs(worldIn, this, model.width, model.length, new int[]{0});
        }
        return true;
    }

    @Override
    public void func_143011_b(CompoundNBT tagCompound) {
        super.func_143011_b(tagCompound);
    }

    @Override
    public void setupBoundingBox() {
        Vector3i offset = DungeonModels.getOffset(this.modelID);
        this.field_74887_e = new MutableBoundingBox(this.x, this.y + offset.func_177956_o(), this.z, this.x + 8, this.y + offset.func_177956_o() + 8, this.z + 8);
    }

    @Override
    public int getType() {
        return 8;
    }
}

