/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.piece.room;

import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Rotation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.TemplateManager;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.StructurePieceTypes;
import xiroc.dungeoncrawl.dungeon.block.WeightedRandomBlock;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelBlock;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelBlockType;
import xiroc.dungeoncrawl.dungeon.model.DungeonModels;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;
import xiroc.dungeoncrawl.dungeon.treasure.Treasure;
import xiroc.dungeoncrawl.theme.Theme;

public class DungeonSecretRoom
extends DungeonPiece {
    public DungeonSecretRoom(TemplateManager manager, CompoundNBT nbt) {
        super(StructurePieceTypes.SECRET_ROOM, nbt);
    }

    public boolean func_230383_a_(ISeedReader worldIn, StructureManager p_230383_2_, ChunkGenerator p_230383_3_, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
        DungeonModel model = DungeonModels.MODELS.get(this.modelID);
        BlockPos pos = new BlockPos(this.x, this.y, this.z);
        this.buildRotatedFull(model, (IWorld)worldIn, structureBoundingBoxIn, pos, Theme.get(this.theme), Theme.getSub(this.subTheme), Treasure.MODEL_TREASURE_TYPES.getOrDefault(this.modelID, Treasure.Type.DEFAULT), this.stage, this.field_186169_c, false);
        this.buildRotatedFull(model, (IWorld)worldIn, structureBoundingBoxIn, pos, Theme.get(this.theme), Theme.getSub(this.subTheme), Treasure.getModelTreasureType(this.modelID), this.stage, this.field_186169_c, false);
        this.decorate((IWorld)worldIn, pos, model.width, model.height, model.length, Theme.get(this.theme), structureBoundingBoxIn, this.field_74887_e, model);
        return true;
    }

    @Override
    public int getType() {
        return 14;
    }

    @Override
    public void setupModel(DungeonBuilder builder, DungeonModels.ModelCategory layerCategory, List<DungeonPiece> pieces, Random rand) {
        this.modelID = DungeonModels.SECRET_ROOM.id;
    }

    @Override
    public void setRealPosition(int x, int y, int z) {
        switch (this.field_186169_c) {
            case NONE: {
                super.setRealPosition(x + 1, y, z);
                break;
            }
            case CLOCKWISE_90: {
                super.setRealPosition(x, y, z + 1);
                break;
            }
            default: {
                super.setRealPosition(x, y, z);
            }
        }
    }

    @Override
    public void setupBoundingBox() {
        this.field_74887_e = this.field_186169_c == Rotation.NONE || this.field_186169_c == Rotation.CLOCKWISE_180 ? new MutableBoundingBox(this.x, this.y, this.z, this.x + 16, this.y + 8, this.z + 8) : new MutableBoundingBox(this.x, this.y, this.z, this.x + 8, this.y + 8, this.z + 16);
    }

    @Override
    public void build(DungeonModel model, IWorld world, MutableBoundingBox boundsIn, BlockPos pos, Theme theme, Theme.SubTheme subTheme, Treasure.Type treasureType, int lootLevel, boolean fillAir) {
        for (int x = 0; x < model.width; ++x) {
            for (int y = 0; y < model.height; ++y) {
                for (int z = 0; z < model.length; ++z) {
                    BlockPos position = new BlockPos(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z);
                    if (!boundsIn.func_175898_b((Vector3i)position)) continue;
                    if (model.model[x][y][z] == null) {
                        this.setBlockState(field_202556_l, world, boundsIn, treasureType, position.func_177958_n(), position.func_177956_o(), position.func_177952_p(), this.theme, lootLevel, DungeonModelBlockType.SOLID);
                        continue;
                    }
                    Tuple<BlockState, Boolean> result = DungeonModelBlock.getBlockState(model.model[x][y][z], Rotation.NONE, world, position, theme, subTheme, WeightedRandomBlock.RANDOM, this.variation, lootLevel);
                    if (result == null) continue;
                    this.setBlockState((BlockState)result.func_76341_a(), world, boundsIn, treasureType, position.func_177958_n(), position.func_177956_o(), position.func_177952_p(), this.theme, lootLevel, fillAir ? DungeonModelBlockType.SOLID : model.model[x][y][z].type);
                    if (((Boolean)result.func_76340_b()).booleanValue()) {
                        world.func_217349_x(position).func_201594_d(position);
                    }
                    if (y != 0 || model.height <= 1 || !world.func_175623_d(position.func_177977_b()) || model.model[x][1][z] == null || model.model[x][0][z].type != DungeonModelBlockType.SOLID || model.model[x][1][z].type != DungeonModelBlockType.SOLID) continue;
                    this.buildPillar(world, theme, pos.func_177958_n() + x, pos.func_177956_o(), pos.func_177952_p() + z, boundsIn);
                }
            }
        }
    }

    @Override
    public void buildFull(DungeonModel model, IWorld world, MutableBoundingBox boundsIn, BlockPos pos, Theme theme, Theme.SubTheme subTheme, Treasure.Type treasureType, int lootLevel, boolean fillAir) {
        for (int x = 0; x < model.width; ++x) {
            for (int y = 0; y < model.height; ++y) {
                for (int z = 0; z < model.length; ++z) {
                    BlockPos position = new BlockPos(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z);
                    if (!boundsIn.func_175898_b((Vector3i)position)) continue;
                    if (model.model[x][y][z] == null) {
                        this.setBlockState(field_202556_l, world, boundsIn, treasureType, position, this.theme, lootLevel, DungeonModelBlockType.SOLID);
                        continue;
                    }
                    Tuple<BlockState, Boolean> result = DungeonModelBlock.getBlockState(model.model[x][y][z], Rotation.NONE, world, position, theme, subTheme, WeightedRandomBlock.RANDOM, this.variation, lootLevel);
                    if (result == null) continue;
                    this.setBlockState((BlockState)result.func_76341_a(), world, boundsIn, treasureType, position, this.theme, lootLevel, fillAir ? DungeonModelBlockType.SOLID : model.model[x][y][z].type);
                    if (((Boolean)result.func_76340_b()).booleanValue()) {
                        world.func_217349_x(position).func_201594_d(position);
                    }
                    if (y != 0 || model.height <= 1 || !world.func_175623_d(position.func_177977_b()) || model.model[x][1][z] == null || model.model[x][0][z].type != DungeonModelBlockType.SOLID || model.model[x][1][z].type != DungeonModelBlockType.SOLID) continue;
                    this.buildPillar(world, theme, pos.func_177958_n() + x, pos.func_177956_o(), pos.func_177952_p() + z, boundsIn);
                }
            }
        }
    }

    @Override
    public void buildRotatedFull(DungeonModel model, IWorld world, MutableBoundingBox boundsIn, BlockPos pos, Theme theme, Theme.SubTheme subTheme, Treasure.Type treasureType, int lootLevel, Rotation rotation, boolean fillAir) {
        switch (rotation) {
            case CLOCKWISE_90: {
                for (int x = 0; x < model.width; ++x) {
                    for (int y = 0; y < model.height; ++y) {
                        for (int z = 0; z < model.length; ++z) {
                            BlockPos position = new BlockPos(pos.func_177958_n() + model.length - z - 1, pos.func_177956_o() + y, pos.func_177952_p() + x);
                            if (!boundsIn.func_175898_b((Vector3i)position)) continue;
                            if (model.model[x][y][z] == null) {
                                this.setBlockState(field_202556_l, world, boundsIn, treasureType, position, this.theme, lootLevel, DungeonModelBlockType.SOLID);
                                continue;
                            }
                            Tuple<BlockState, Boolean> result = DungeonModelBlock.getBlockState(model.model[x][y][z], Rotation.CLOCKWISE_90, world, position, theme, subTheme, WeightedRandomBlock.RANDOM, this.variation, lootLevel);
                            if (result == null) continue;
                            this.setBlockState((BlockState)result.func_76341_a(), world, boundsIn, treasureType, position, this.theme, lootLevel, fillAir ? DungeonModelBlockType.SOLID : model.model[x][y][z].type);
                            if (((Boolean)result.func_76340_b()).booleanValue()) {
                                world.func_217349_x(position).func_201594_d(position);
                            }
                            if (y != 0 || model.height <= 1 || !world.func_175623_d(position.func_177977_b()) || model.model[x][1][z] == null || model.model[x][0][z].type != DungeonModelBlockType.SOLID || model.model[x][1][z].type != DungeonModelBlockType.SOLID) continue;
                            this.buildPillar(world, theme, position.func_177958_n(), position.func_177956_o(), position.func_177952_p(), boundsIn);
                        }
                    }
                }
                break;
            }
            case COUNTERCLOCKWISE_90: {
                for (int x = 0; x < model.width; ++x) {
                    for (int y = 0; y < model.height; ++y) {
                        for (int z = 0; z < model.length; ++z) {
                            BlockPos position = new BlockPos(pos.func_177958_n() + z, pos.func_177956_o() + y, pos.func_177952_p() + model.width - x - 1);
                            if (!boundsIn.func_175898_b((Vector3i)position)) continue;
                            if (model.model[x][y][z] == null) {
                                this.setBlockState(field_202556_l, world, boundsIn, treasureType, position, this.theme, lootLevel, DungeonModelBlockType.SOLID);
                                continue;
                            }
                            Tuple<BlockState, Boolean> result = DungeonModelBlock.getBlockState(model.model[x][y][z], Rotation.COUNTERCLOCKWISE_90, world, position, theme, subTheme, WeightedRandomBlock.RANDOM, this.variation, lootLevel);
                            if (result == null) continue;
                            this.setBlockState((BlockState)result.func_76341_a(), world, boundsIn, treasureType, position, this.theme, lootLevel, fillAir ? DungeonModelBlockType.SOLID : model.model[x][y][z].type);
                            if (((Boolean)result.func_76340_b()).booleanValue()) {
                                world.func_217349_x(position).func_201594_d(position);
                            }
                            if (y != 0 || model.height <= 1 || !world.func_175623_d(position.func_177977_b()) || model.model[x][1][z] == null || model.model[x][0][z].type != DungeonModelBlockType.SOLID || model.model[x][1][z].type != DungeonModelBlockType.SOLID) continue;
                            this.buildPillar(world, theme, position.func_177958_n(), position.func_177956_o(), position.func_177952_p(), boundsIn);
                        }
                    }
                }
                break;
            }
            case CLOCKWISE_180: {
                for (int x = 0; x < model.width; ++x) {
                    for (int y = 0; y < model.height; ++y) {
                        for (int z = 0; z < model.length; ++z) {
                            BlockPos position = new BlockPos(pos.func_177958_n() + model.width - x - 1, pos.func_177956_o() + y, pos.func_177952_p() + model.length - z - 1);
                            if (!boundsIn.func_175898_b((Vector3i)position)) continue;
                            if (model.model[x][y][z] == null) {
                                this.setBlockState(field_202556_l, world, boundsIn, treasureType, position, this.theme, lootLevel, DungeonModelBlockType.SOLID);
                                continue;
                            }
                            Tuple<BlockState, Boolean> result = DungeonModelBlock.getBlockState(model.model[x][y][z], Rotation.CLOCKWISE_180, world, position, theme, subTheme, WeightedRandomBlock.RANDOM, this.variation, lootLevel);
                            if (result == null) continue;
                            this.setBlockState((BlockState)result.func_76341_a(), world, boundsIn, treasureType, position, this.theme, lootLevel, fillAir ? DungeonModelBlockType.SOLID : model.model[x][y][z].type);
                            if (((Boolean)result.func_76340_b()).booleanValue()) {
                                world.func_217349_x(position).func_201594_d(position);
                            }
                            if (y != 0 || model.height <= 1 || !world.func_175623_d(position.func_177977_b()) || model.model[x][1][z] == null || model.model[x][0][z].type != DungeonModelBlockType.SOLID || model.model[x][1][z].type != DungeonModelBlockType.SOLID) continue;
                            this.buildPillar(world, theme, position.func_177958_n(), position.func_177956_o(), position.func_177952_p(), boundsIn);
                        }
                    }
                }
                break;
            }
            case NONE: {
                this.buildFull(model, world, boundsIn, pos, theme, subTheme, treasureType, lootLevel, fillAir);
                break;
            }
            default: {
                DungeonCrawl.LOGGER.warn("Failed to build a rotated dungeon segment: Unsupported rotation " + rotation);
            }
        }
    }

    @Override
    public void buildRotated(DungeonModel model, IWorld world, MutableBoundingBox boundsIn, BlockPos pos, Theme theme, Theme.SubTheme subTheme, Treasure.Type treasureType, int lootLevel, Rotation rotation, boolean fillAir) {
        switch (rotation) {
            case CLOCKWISE_90: {
                for (int x = 0; x < model.width; ++x) {
                    for (int y = 0; y < model.height; ++y) {
                        for (int z = 0; z < model.length; ++z) {
                            BlockPos position = new BlockPos(pos.func_177958_n() + model.length - z - 1, pos.func_177956_o() + y, pos.func_177952_p() + x);
                            if (!boundsIn.func_175898_b((Vector3i)position)) continue;
                            if (model.model[x][y][z] == null) {
                                this.setBlockState(field_202556_l, world, boundsIn, treasureType, position.func_177958_n(), position.func_177956_o(), position.func_177952_p(), this.theme, lootLevel, DungeonModelBlockType.SOLID);
                                continue;
                            }
                            Tuple<BlockState, Boolean> result = DungeonModelBlock.getBlockState(model.model[x][y][z], Rotation.CLOCKWISE_90, world, position, theme, subTheme, WeightedRandomBlock.RANDOM, this.variation, lootLevel);
                            if (result == null) continue;
                            this.setBlockState((BlockState)result.func_76341_a(), world, boundsIn, treasureType, position.func_177958_n(), position.func_177956_o(), position.func_177952_p(), this.theme, lootLevel, fillAir ? DungeonModelBlockType.SOLID : model.model[x][y][z].type);
                            if (((Boolean)result.func_76340_b()).booleanValue()) {
                                world.func_217349_x(position).func_201594_d(position);
                            }
                            if (y != 0 || model.height <= 1 || !world.func_175623_d(position.func_177977_b()) || model.model[x][1][z] == null || model.model[x][0][z].type != DungeonModelBlockType.SOLID || model.model[x][1][z].type != DungeonModelBlockType.SOLID) continue;
                            this.buildPillar(world, theme, position.func_177958_n(), position.func_177956_o(), position.func_177952_p(), boundsIn);
                        }
                    }
                }
                break;
            }
            case COUNTERCLOCKWISE_90: {
                for (int x = 0; x < model.width; ++x) {
                    for (int y = 0; y < model.height; ++y) {
                        for (int z = 0; z < model.length; ++z) {
                            BlockPos position = new BlockPos(pos.func_177958_n() + z, pos.func_177956_o() + y, pos.func_177952_p() + model.width - x - 1);
                            if (!boundsIn.func_175898_b((Vector3i)position)) continue;
                            if (model.model[x][y][z] == null) {
                                this.setBlockState(field_202556_l, world, boundsIn, treasureType, position.func_177958_n(), position.func_177956_o(), position.func_177952_p(), this.theme, lootLevel, DungeonModelBlockType.SOLID);
                                continue;
                            }
                            Tuple<BlockState, Boolean> result = DungeonModelBlock.getBlockState(model.model[x][y][z], Rotation.COUNTERCLOCKWISE_90, world, position, theme, subTheme, WeightedRandomBlock.RANDOM, this.variation, lootLevel);
                            if (result == null) continue;
                            this.setBlockState((BlockState)result.func_76341_a(), world, boundsIn, treasureType, position.func_177958_n(), position.func_177956_o(), position.func_177952_p(), this.theme, lootLevel, fillAir ? DungeonModelBlockType.SOLID : model.model[x][y][z].type);
                            if (((Boolean)result.func_76340_b()).booleanValue()) {
                                world.func_217349_x(position).func_201594_d(position);
                            }
                            if (y != 0 || model.height <= 1 || !world.func_175623_d(position.func_177977_b()) || model.model[x][1][z] == null || model.model[x][0][z].type != DungeonModelBlockType.SOLID || model.model[x][1][z].type != DungeonModelBlockType.SOLID) continue;
                            this.buildPillar(world, theme, position.func_177958_n(), position.func_177956_o(), position.func_177952_p(), boundsIn);
                        }
                    }
                }
                break;
            }
            case CLOCKWISE_180: {
                for (int x = 0; x < model.width; ++x) {
                    for (int y = 0; y < model.height; ++y) {
                        for (int z = 0; z < model.length; ++z) {
                            BlockPos position = new BlockPos(pos.func_177958_n() + model.width - x - 1, pos.func_177956_o() + y, pos.func_177952_p() + model.length - z - 1);
                            if (!boundsIn.func_175898_b((Vector3i)position)) continue;
                            if (model.model[x][y][z] == null) {
                                this.setBlockState(field_202556_l, world, boundsIn, treasureType, position.func_177958_n(), position.func_177956_o(), position.func_177952_p(), this.theme, lootLevel, DungeonModelBlockType.SOLID);
                                continue;
                            }
                            Tuple<BlockState, Boolean> result = DungeonModelBlock.getBlockState(model.model[x][y][z], Rotation.CLOCKWISE_180, world, position, theme, subTheme, WeightedRandomBlock.RANDOM, this.variation, lootLevel);
                            if (result == null) continue;
                            this.setBlockState((BlockState)result.func_76341_a(), world, boundsIn, treasureType, position.func_177958_n(), position.func_177956_o(), position.func_177952_p(), this.theme, lootLevel, fillAir ? DungeonModelBlockType.SOLID : model.model[x][y][z].type);
                            if (((Boolean)result.func_76340_b()).booleanValue()) {
                                world.func_217349_x(position).func_201594_d(position);
                            }
                            if (y != 0 || model.height <= 1 || !world.func_175623_d(position.func_177977_b()) || model.model[x][1][z] == null || model.model[x][0][z].type != DungeonModelBlockType.SOLID || model.model[x][1][z].type != DungeonModelBlockType.SOLID) continue;
                            this.buildPillar(world, theme, position.func_177958_n(), position.func_177956_o(), position.func_177952_p(), boundsIn);
                        }
                    }
                }
                break;
            }
            case NONE: {
                this.build(model, world, boundsIn, pos, theme, subTheme, treasureType, lootLevel, fillAir);
                break;
            }
            default: {
                DungeonCrawl.LOGGER.warn("Failed to build a rotated dungeon segment: Unsupported rotation " + rotation);
            }
        }
    }
}

