/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.treasure;

import java.util.HashMap;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import xiroc.dungeoncrawl.dungeon.treasure.Loot;
import xiroc.dungeoncrawl.dungeon.treasure.function.EnchantedBook;
import xiroc.dungeoncrawl.dungeon.treasure.function.MaterialBlocks;
import xiroc.dungeoncrawl.dungeon.treasure.function.RandomItem;
import xiroc.dungeoncrawl.dungeon.treasure.function.RandomPotion;
import xiroc.dungeoncrawl.dungeon.treasure.function.Shield;
import xiroc.dungeoncrawl.dungeon.treasure.function.SpecialItem;
import xiroc.dungeoncrawl.dungeon.treasure.function.SuspiciousStew;

public class Treasure {
    public static final LootFunctionType ENCHANTED_BOOK = Treasure.func_237451_a_("dungeoncrawl:enchanted_book", (ILootSerializer<? extends ILootFunction>)new EnchantedBook.Serializer());
    public static final LootFunctionType MATERIAL_BLOCKS = Treasure.func_237451_a_("dungeoncrawl:material_blocks", (ILootSerializer<? extends ILootFunction>)new MaterialBlocks.Serializer());
    public static final LootFunctionType RANDOM_ITEM = Treasure.func_237451_a_("dungeoncrawl:random_item", (ILootSerializer<? extends ILootFunction>)new RandomItem.Serializer());
    public static final LootFunctionType SPECIAL_ITEM = Treasure.func_237451_a_("dungeoncrawl:special_item", (ILootSerializer<? extends ILootFunction>)new SpecialItem.Serializer());
    public static final LootFunctionType RANDOM_POTION = Treasure.func_237451_a_("dungeoncrawl:random_potion", (ILootSerializer<? extends ILootFunction>)new RandomPotion.Serializer());
    public static final LootFunctionType SHIELD = Treasure.func_237451_a_("dungeoncrawl:shield", (ILootSerializer<? extends ILootFunction>)new Shield.Serializer());
    public static final LootFunctionType SUSPICIOUS_STEW = Treasure.func_237451_a_("dungeoncrawl:suspicious_stew", (ILootSerializer<? extends ILootFunction>)new SuspiciousStew.Serializer());
    public static final HashMap<Type, ResourceLocation> SPECIAL_LOOT_TABLES = new HashMap();
    public static final HashMap<Integer, Type> MODEL_TREASURE_TYPES = new HashMap();

    public static Type getModelTreasureType(int modelID) {
        return MODEL_TREASURE_TYPES.getOrDefault(modelID, Type.DEFAULT);
    }

    public static void init() {
        SPECIAL_LOOT_TABLES.put(Type.SUPPLY, Loot.SUPPLY_CHEST);
        SPECIAL_LOOT_TABLES.put(Type.FOOD, Loot.FOOD);
        SPECIAL_LOOT_TABLES.put(Type.TREASURE, Loot.TREASURE_ROOM);
        SPECIAL_LOOT_TABLES.put(Type.LIBRARY, Loot.LIBRARY);
        SPECIAL_LOOT_TABLES.put(Type.SECRET_ROOM, Loot.SECRET_ROOM);
        SPECIAL_LOOT_TABLES.put(Type.FORGE, Loot.FORGE);
    }

    private static LootFunctionType func_237451_a_(String p_237451_0_, ILootSerializer<? extends ILootFunction> p_237451_1_) {
        return (LootFunctionType)Registry.func_218322_a((Registry)Registry.field_239694_aZ_, (ResourceLocation)new ResourceLocation(p_237451_0_), (Object)new LootFunctionType(p_237451_1_));
    }

    public static enum Type {
        DEFAULT,
        FOOD,
        FORGE,
        CATACOMB,
        SECRET_ROOM,
        LIBRARY,
        BUILDERS_ROOM,
        TREASURE,
        SUPPLY;

        public static final HashMap<Integer, Type> INT_TO_TYPE_MAP;
        public static final HashMap<Type, Integer> TYPE_TO_INT_MAP;

        public static Type fromInt(int typeID) {
            return INT_TO_TYPE_MAP.getOrDefault(typeID, DEFAULT);
        }

        public static int toInt(Type type) {
            return TYPE_TO_INT_MAP.get((Object)type);
        }

        static {
            INT_TO_TYPE_MAP = new HashMap();
            INT_TO_TYPE_MAP.put(0, DEFAULT);
            INT_TO_TYPE_MAP.put(1, FOOD);
            INT_TO_TYPE_MAP.put(2, FORGE);
            INT_TO_TYPE_MAP.put(3, CATACOMB);
            INT_TO_TYPE_MAP.put(4, SECRET_ROOM);
            INT_TO_TYPE_MAP.put(5, LIBRARY);
            INT_TO_TYPE_MAP.put(6, BUILDERS_ROOM);
            INT_TO_TYPE_MAP.put(7, TREASURE);
            INT_TO_TYPE_MAP.put(8, SUPPLY);
            TYPE_TO_INT_MAP = new HashMap();
            INT_TO_TYPE_MAP.forEach((key, value) -> TYPE_TO_INT_MAP.put((Type)((Object)value), (Integer)key));
        }
    }
}

