/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.treasure.function;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.treasure.RandomItems;
import xiroc.dungeoncrawl.dungeon.treasure.Treasure;
import xiroc.dungeoncrawl.theme.Theme;

public class SpecialItem
extends LootFunction {
    public int lootLevel;

    protected SpecialItem(ILootCondition[] conditionsIn, int lootLevel) {
        super(conditionsIn);
        this.lootLevel = Math.max(0, lootLevel);
    }

    protected ItemStack func_215859_a(ItemStack stack, LootContext context) {
        Biome biome = context.func_202879_g().func_226691_t_(new BlockPos((Vector3d)context.func_216031_c(LootParameters.field_237457_g_)));
        ResourceLocation biomeName = context.func_202879_g().func_241828_r().func_243612_b(Registry.field_239720_u_).func_177774_c((Object)biome);
        return RandomItems.generateSpecialItem(context.func_202879_g(), context.func_216032_b(), Theme.BIOME_TO_THEME_MAP.getOrDefault(biomeName, 0), this.lootLevel);
    }

    public LootFunctionType func_230425_b_() {
        return Treasure.SPECIAL_ITEM;
    }

    public static class Serializer
    extends LootFunction.Serializer<SpecialItem> {
        public void serialize(JsonObject object, SpecialItem functionClazz, JsonSerializationContext serializationContext) {
            object.add("loot_level", DungeonCrawl.GSON.toJsonTree((Object)functionClazz.lootLevel));
        }

        public SpecialItem deserialize(JsonObject object, JsonDeserializationContext deserializationContext, ILootCondition[] conditionsIn) {
            return new SpecialItem(conditionsIn, object.get("loot_level").getAsInt() - 1);
        }
    }
}

