/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.module;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Modules {
    public static final Logger LOGGER = LogManager.getLogger((String)"Dungeon Crawl/Module Manager");
    private static final ArrayList<Class<? extends Module>> MODULES = Lists.newArrayList();
    private static final HashMap<Class<? extends Module>, String[]> MOD_REQUIREMENTS = new HashMap();

    public static void load() {
        int size = MODULES.size();
        if (size <= 0) {
            return;
        }
        if (size == 1) {
            LOGGER.info("There is one module present");
        } else {
            LOGGER.info("There are {} modules present", (Object)size);
        }
        int successful = 0;
        int failed = 0;
        block2: for (Class<? extends Module> moduleClass : MODULES) {
            for (String modId : MOD_REQUIREMENTS.get(moduleClass)) {
                if (!ModList.get().isLoaded(modId)) continue block2;
            }
            try {
                Module module = moduleClass.newInstance();
                LOGGER.info("Loading module {}", (Object)module.name);
                if (module.load()) {
                    ++successful;
                } else {
                    LOGGER.error("The module {} failed to load.", (Object)module.name);
                    ++failed;
                }
            }
            catch (Exception e) {
                LOGGER.error("An error occurred while trying to load {}", (Object)moduleClass.toString());
            }
            LOGGER.info("Successfully loaded {} , {} failed.", (Object)(successful + (size > 1 ? " Modules" : " Module")), (Object)failed);
        }
        LOGGER.info("Successfully loaded {} , {} failed.", (Object)(successful + (size > 1 ? " Modules" : " Module")), (Object)failed);
    }

    public static boolean registerModule(Class<? extends Module> module, String[] requiredMods) {
        MOD_REQUIREMENTS.put(module, requiredMods);
        return MODULES.add(module);
    }

    public static abstract class Module {
        public String name;
        public int version;

        public Module(ResourceLocation name) {
            this.name = name.toString();
            this.version = 0;
        }

        public abstract boolean load();
    }
}

