/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.theme;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.block.WeightedRandomBlock;
import xiroc.dungeoncrawl.dungeon.decoration.IDungeonDecoration;
import xiroc.dungeoncrawl.theme.Theme;
import xiroc.dungeoncrawl.theme.WeightedThemeRandomizer;
import xiroc.dungeoncrawl.util.IBlockStateProvider;

public class JsonThemeHandler {
    public JsonBaseTheme theme;
    public JsonSubTheme subTheme;
    private static final Logger LOGGER = LogManager.getLogger((String)"DungeonCrawl/JsonThemeHandler");

    public static void deserialize(JsonObject object) {
        if (object.has("type")) {
            String type;
            switch (type = object.get("type").getAsString()) {
                case "theme": {
                    JsonBaseTheme.deserialize(object);
                    break;
                }
                case "sub_theme": {
                    JsonSubTheme.deserialize(object);
                    break;
                }
                case "theme_randomizer": {
                    WeightedThemeRandomizer randomizer = (WeightedThemeRandomizer)DungeonCrawl.GSON.fromJson((JsonElement)object, WeightedThemeRandomizer.class);
                    Theme.THEME_RANDOMIZERS.put(randomizer.base, randomizer);
                    break;
                }
                case "sub_theme_randomizer": {
                    WeightedThemeRandomizer randomizer = (WeightedThemeRandomizer)DungeonCrawl.GSON.fromJson((JsonElement)object, WeightedThemeRandomizer.class);
                    Theme.SUB_THEME_RANDOMIZERS.put(randomizer.base, randomizer);
                    break;
                }
                case "theme_mapping": {
                    object.get("mapping").getAsJsonObject().entrySet().forEach(entry -> {
                        String key = (String)entry.getKey();
                        if (!ForgeRegistries.BIOMES.containsKey(new ResourceLocation(key))) {
                            LOGGER.warn("The biome {} does not exist", (Object)key);
                        }
                        int id = ((JsonElement)entry.getValue()).getAsInt();
                        Theme.BIOME_TO_THEME_MAP.put(key, id);
                    });
                    break;
                }
                case "sub_theme_mapping": {
                    object.get("mapping").getAsJsonObject().entrySet().forEach(entry -> {
                        String key = (String)entry.getKey();
                        if (!ForgeRegistries.BIOMES.containsKey(new ResourceLocation(key))) {
                            LOGGER.warn("The biome {} does not exist", (Object)key);
                        }
                        int id = ((JsonElement)entry.getValue()).getAsInt();
                        Theme.BIOME_TO_SUBTHEME_MAP.put(key, id);
                    });
                    break;
                }
                default: {
                    LOGGER.error("Invalid json theme type: {}", (Object)type);
                    break;
                }
            }
        } else {
            LOGGER.error("Invalid json theme: missing type specification.");
        }
    }

    public static IBlockStateProvider deserialize(JsonObject base, String name) {
        if (!base.has(name)) {
            LOGGER.warn("Missing BlockState Provider \"{}\"", (Object)name);
            return null;
        }
        JsonObject object = (JsonObject)base.get(name);
        if (object.has("type")) {
            String type = object.get("type").getAsString();
            if (type.equalsIgnoreCase("random_block")) {
                JsonArray blockObjects = object.get("blocks").getAsJsonArray();
                TupleIntBlock[] blocks = new TupleIntBlock[blockObjects.size()];
                int i = 0;
                for (JsonElement blockObject : blockObjects) {
                    JsonObject element = (JsonObject)blockObject;
                    Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(element.get("block").getAsString()));
                    if (block != null) {
                        BlockState state = block.func_176223_P();
                        if (element.has("data")) {
                            JsonObject data = element.get("data").getAsJsonObject();
                            for (Property property : state.func_235904_r_()) {
                                if (!data.has(property.func_177701_a())) continue;
                                state = JsonThemeHandler.parseProperty(state, property, data.get(property.func_177701_a()).getAsString());
                            }
                        }
                        blocks[i++] = new TupleIntBlock(element.has("weight") ? element.get("weight").getAsInt() : 1, state);
                        continue;
                    }
                    LOGGER.error("Unknown block: {}", (Object)element.get("block").getAsString());
                }
                return new WeightedRandomBlock(blocks);
            }
            if (type.equalsIgnoreCase("block")) {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(object.get("block").getAsString()));
                if (block != null) {
                    BlockState state = block.func_176223_P();
                    if (object.has("data")) {
                        JsonObject data = object.get("data").getAsJsonObject();
                        for (Property property : state.func_235904_r_()) {
                            if (!data.has(property.func_177701_a())) continue;
                            state = JsonThemeHandler.parseProperty(state, property, data.get(property.func_177701_a()).getAsString());
                        }
                    }
                    return new BlockStateHolder(state);
                }
                LOGGER.error("Unknown block: {}", (Object)object.get("block").getAsString());
                return () -> ((Block)Blocks.field_201941_jj).func_176223_P();
            }
            LOGGER.error("Failed to load BlockState Provider {}: Unknown type {}.", (Object)object, (Object)type);
            return null;
        }
        LOGGER.error("Invalid BlockState Provider \"{}\": Type not specified.", (Object)name);
        return null;
    }

    private static <T extends Comparable<T>> BlockState parseProperty(BlockState state, Property<T> property, String value) {
        if (state.func_235901_b_(property)) {
            Optional optional = property.func_185929_b(value);
            if (optional.isPresent()) {
                Comparable t = (Comparable)optional.get();
                return (BlockState)state.func_206870_a(property, t);
            }
            LOGGER.warn("Couldn't apply {} : {} for {}", (Object)property.func_177701_a(), (Object)value, (Object)state.func_177230_c());
        }
        return state;
    }

    private static final class BlockStateHolder
    implements IBlockStateProvider {
        private final BlockState state;

        public BlockStateHolder(BlockState state) {
            this.state = state;
        }

        @Override
        public BlockState get() {
            return this.state;
        }
    }

    private static final class TupleIntBlock
    extends Tuple<Integer, BlockState> {
        public TupleIntBlock(Integer aIn, BlockState bIn) {
            super((Object)aIn, (Object)bIn);
        }
    }

    public static class JsonSubTheme {
        public IBlockStateProvider wallLog;
        public IBlockStateProvider trapDoor;
        public IBlockStateProvider door;
        public IBlockStateProvider material;
        public IBlockStateProvider stairs;
        public IBlockStateProvider slab;
        public IBlockStateProvider fence;
        public IBlockStateProvider button;
        public IBlockStateProvider pressurePlate;
        public IBlockStateProvider fenceGate;

        public static void deserialize(JsonObject object) {
            JsonObject themeObject = object.get("theme").getAsJsonObject();
            JsonSubTheme theme = new JsonSubTheme();
            theme.wallLog = JsonThemeHandler.deserialize(themeObject, "pillar");
            theme.trapDoor = JsonThemeHandler.deserialize(themeObject, "trapdoor");
            theme.door = JsonThemeHandler.deserialize(themeObject, "door");
            theme.material = JsonThemeHandler.deserialize(themeObject, "material");
            theme.stairs = JsonThemeHandler.deserialize(themeObject, "stairs");
            theme.slab = JsonThemeHandler.deserialize(themeObject, "slab");
            theme.fence = JsonThemeHandler.deserialize(themeObject, "fence");
            theme.fenceGate = JsonThemeHandler.deserialize(themeObject, "fence_gate");
            theme.button = JsonThemeHandler.deserialize(themeObject, "button");
            theme.pressurePlate = JsonThemeHandler.deserialize(themeObject, "pressure_plate");
            int id = object.get("id").getAsInt();
            Theme.ID_TO_SUBTHEME_MAP.put(id, theme.toSubTheme());
        }

        public Theme.SubTheme toSubTheme() {
            return new Theme.SubTheme(this.wallLog, this.trapDoor, null, this.door, this.material, this.stairs, this.slab, this.fence, this.fenceGate, this.button, this.pressurePlate);
        }
    }

    public static class JsonBaseTheme {
        public IBlockStateProvider solid;
        public IBlockStateProvider normal;
        public IBlockStateProvider normal_2;
        public IBlockStateProvider floor;
        public IBlockStateProvider solidStairs;
        public IBlockStateProvider stairs;
        public IBlockStateProvider material;
        public IBlockStateProvider vanillaWall;
        public IBlockStateProvider column;
        public IBlockStateProvider slab;
        public IBlockStateProvider solidSlab;

        public static void deserialize(JsonObject object) {
            JsonObject themeObject = object.get("theme").getAsJsonObject();
            JsonBaseTheme theme = new JsonBaseTheme();
            theme.normal = JsonThemeHandler.deserialize(themeObject, "normal");
            theme.solid = JsonThemeHandler.deserialize(themeObject, "solid");
            theme.normal_2 = JsonThemeHandler.deserialize(themeObject, "normal_2");
            theme.floor = JsonThemeHandler.deserialize(themeObject, "floor");
            theme.stairs = JsonThemeHandler.deserialize(themeObject, "stairs");
            theme.solidStairs = JsonThemeHandler.deserialize(themeObject, "solid_stairs");
            theme.slab = JsonThemeHandler.deserialize(themeObject, "slab");
            theme.solidSlab = JsonThemeHandler.deserialize(themeObject, "solid_slab");
            theme.material = JsonThemeHandler.deserialize(themeObject, "material");
            theme.vanillaWall = JsonThemeHandler.deserialize(themeObject, "wall");
            int id = object.get("id").getAsInt();
            IDungeonDecoration[] decorations = null;
            if (object.has("decorations")) {
                JsonArray array = object.getAsJsonArray("decorations");
                decorations = new IDungeonDecoration[array.size()];
                for (int i = 0; i < decorations.length; ++i) {
                    decorations[i] = IDungeonDecoration.fromJson(array.get(i).getAsJsonObject());
                }
            }
            Theme result = theme.toTheme().withDecorations(decorations);
            if (object.has("sub_theme")) {
                result.subTheme = object.get("sub_theme").getAsInt();
            }
            Theme.ID_TO_THEME_MAP.put(id, result);
        }

        public Theme toTheme() {
            return new Theme(null, this.solid, this.normal, this.floor, this.solidStairs, this.stairs, this.material, this.vanillaWall, null, this.normal_2, this.slab, this.solidSlab);
        }
    }
}

