/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.theme;

import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.jline.utils.InputStreamReader;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.block.DungeonBlocks;
import xiroc.dungeoncrawl.dungeon.decoration.IDungeonDecoration;
import xiroc.dungeoncrawl.theme.JsonThemeHandler;
import xiroc.dungeoncrawl.util.IBlockStateProvider;

public class Theme {
    public static final Random RANDOM = new Random();
    public static HashMap<String, Integer> BIOME_TO_THEME_MAP = new HashMap();
    public static HashMap<String, Integer> BIOME_TO_SUBTHEME_MAP = new HashMap();
    public static HashMap<Integer, Theme> ID_TO_THEME_MAP = new HashMap();
    public static HashMap<Integer, SubTheme> ID_TO_SUBTHEME_MAP = new HashMap();
    public static HashMap<Integer, ThemeRandomizer> THEME_RANDOMIZERS = new HashMap();
    public static HashMap<Integer, ThemeRandomizer> SUB_THEME_RANDOMIZERS = new HashMap();
    public static final Theme DEFAULT = new Theme(() -> DungeonBlocks.STONE_BRICKS, DungeonBlocks.STONE_BRICKS_NORMAL_CRACKED_COBBLESTONE, DungeonBlocks.STONE_BRICKS_NORMAL_CRACKED_COBBLESTONE, DungeonBlocks.STONE_BRICK_FLOOR, DungeonBlocks.STAIRS_STONE_COBBLESTONE, DungeonBlocks.STAIRS_STONE_COBBLESTONE, DungeonBlocks.STONE_BRICKS_GRAVEL_COBBLESTONE, DungeonBlocks.STONE_WALL, DungeonBlocks.STONE_BRICK_FLOOR, () -> ((Block)Blocks.field_150343_Z).func_176223_P(), () -> ((Block)Blocks.field_196646_bz).func_176223_P(), () -> ((Block)Blocks.field_196573_bB).func_176223_P());
    public static final SubTheme OAK = new SubTheme(() -> ((Block)Blocks.field_196617_K).func_176223_P(), () -> ((Block)Blocks.field_196636_cW).func_176223_P(), () -> ((Block)Blocks.field_196677_cy).func_176223_P(), () -> ((Block)Blocks.field_180413_ao).func_176223_P(), () -> ((Block)Blocks.field_196662_n).func_176223_P(), () -> ((Block)Blocks.field_150476_ad).func_176223_P(), () -> ((Block)Blocks.field_196622_bq).func_176223_P(), () -> ((Block)Blocks.field_180407_aO).func_176223_P(), () -> ((Block)Blocks.field_180390_bo).func_176223_P(), () -> ((Block)Blocks.field_196689_eF).func_176223_P(), () -> ((Block)Blocks.field_196663_cq).func_176223_P());
    public static final ThemeRandomizer DEFAULT_RANDOMIZER = (rand, base) -> base;
    public final IBlockStateProvider ceiling;
    public final IBlockStateProvider solid;
    public final IBlockStateProvider normal;
    public final IBlockStateProvider normal2;
    public final IBlockStateProvider floor;
    public final IBlockStateProvider solidStairs;
    public final IBlockStateProvider stairs;
    public final IBlockStateProvider material;
    public final IBlockStateProvider vanillaWall;
    public final IBlockStateProvider column;
    public final IBlockStateProvider slab;
    public final IBlockStateProvider solidSlab;
    public Integer subTheme;
    public IDungeonDecoration[] decorations;

    public Theme(IBlockStateProvider ceiling, IBlockStateProvider solid, IBlockStateProvider normal, IBlockStateProvider floor, IBlockStateProvider solidStairs, IBlockStateProvider stairs, IBlockStateProvider material, IBlockStateProvider vanillaWall, IBlockStateProvider column, IBlockStateProvider normal2, IBlockStateProvider slab, IBlockStateProvider solidSlab) {
        this.ceiling = ceiling;
        this.solid = solid;
        this.normal = normal;
        this.floor = floor;
        this.solidStairs = solidStairs;
        this.stairs = stairs;
        this.material = material;
        this.vanillaWall = vanillaWall;
        this.column = column;
        this.normal2 = normal2;
        this.slab = slab;
        this.solidSlab = solidSlab;
    }

    public Theme(Block ceiling, Block solid, Block normal, Block floor, Block solidStairs, Block stairs, Block material, Block vanillaWall, Block column, Block normal2, Block slab, Block solidSlab) {
        this.ceiling = () -> ((Block)ceiling).func_176223_P();
        this.solid = () -> ((Block)solid).func_176223_P();
        this.normal = () -> ((Block)normal).func_176223_P();
        this.floor = () -> ((Block)floor).func_176223_P();
        this.solidStairs = () -> ((Block)solidStairs).func_176223_P();
        this.stairs = () -> ((Block)stairs).func_176223_P();
        this.material = () -> ((Block)material).func_176223_P();
        this.vanillaWall = () -> ((Block)vanillaWall).func_176223_P();
        this.column = () -> ((Block)column).func_176223_P();
        this.normal2 = () -> ((Block)normal2).func_176223_P();
        this.slab = () -> ((Block)slab).func_176223_P();
        this.solidSlab = () -> ((Block)solidSlab).func_176223_P();
    }

    public Theme withDecorations(@Nullable IDungeonDecoration[] decorations) {
        this.decorations = decorations;
        return this;
    }

    public static void loadJson(IResourceManager resourceManager) {
        JsonParser parser = new JsonParser();
        for (ResourceLocation resource : resourceManager.func_199003_a(DungeonCrawl.locate("theming").func_110623_a(), s -> s.endsWith(".json"))) {
            DungeonCrawl.LOGGER.debug("Loading {}", (Object)resource.toString());
            try {
                JsonReader reader = new JsonReader((Reader)new InputStreamReader(resourceManager.func_199002_a(resource).func_199027_b()));
                JsonThemeHandler.deserialize(parser.parse(reader).getAsJsonObject());
            }
            catch (Exception e) {
                DungeonCrawl.LOGGER.error("Failed to load {}", (Object)resource.toString());
                e.printStackTrace();
            }
        }
    }

    public static int getTheme(String biome, Random rand) {
        int theme = BIOME_TO_THEME_MAP.getOrDefault(biome, 0);
        return THEME_RANDOMIZERS.getOrDefault(theme, DEFAULT_RANDOMIZER).randomize(rand, theme);
    }

    public static int getSubTheme(String biome, Random rand) {
        int subTheme = BIOME_TO_SUBTHEME_MAP.getOrDefault(biome, 0);
        return SUB_THEME_RANDOMIZERS.getOrDefault(subTheme, DEFAULT_RANDOMIZER).randomize(rand, subTheme);
    }

    public static Theme get(int theme) {
        return ID_TO_THEME_MAP.getOrDefault(theme, ID_TO_THEME_MAP.getOrDefault(0, DEFAULT));
    }

    public static SubTheme getSub(int id) {
        return ID_TO_SUBTHEME_MAP.getOrDefault(id, ID_TO_SUBTHEME_MAP.getOrDefault(0, OAK));
    }

    public static int randomizeTheme(int base, Random rand) {
        return THEME_RANDOMIZERS.getOrDefault(base, DEFAULT_RANDOMIZER).randomize(rand, base);
    }

    public static int randomizeSubTheme(int base, Random rand) {
        return SUB_THEME_RANDOMIZERS.getOrDefault(base, DEFAULT_RANDOMIZER).randomize(rand, base);
    }

    public static ThemeRandomizer createRandomizer(int ... themes) {
        return (rand, base) -> themes[rand.nextInt(themes.length)];
    }

    @FunctionalInterface
    public static interface ThemeRandomizer {
        public int randomize(Random var1, int var2);
    }

    public static class SubTheme {
        public final IBlockStateProvider wallLog;
        public final IBlockStateProvider trapDoor;
        public final IBlockStateProvider torchDark;
        public final IBlockStateProvider door;
        public final IBlockStateProvider material;
        public final IBlockStateProvider stairs;
        public final IBlockStateProvider slab;
        public final IBlockStateProvider fence;
        public final IBlockStateProvider fenceGate;
        public final IBlockStateProvider button;
        public final IBlockStateProvider pressurePlate;

        public SubTheme(IBlockStateProvider wallLog, IBlockStateProvider trapDoor, IBlockStateProvider torchDark, IBlockStateProvider door, IBlockStateProvider material, IBlockStateProvider stairs, IBlockStateProvider slab, IBlockStateProvider fence, IBlockStateProvider fenceGate, IBlockStateProvider button, IBlockStateProvider pressurePlate) {
            this.wallLog = wallLog;
            this.trapDoor = trapDoor;
            this.torchDark = torchDark;
            this.door = door;
            this.material = material;
            this.stairs = stairs;
            this.slab = slab;
            this.fence = fence;
            this.fenceGate = fenceGate;
            this.button = button;
            this.pressurePlate = pressurePlate;
        }

        public SubTheme(Block wallLog, Block trapDoor, Block torchDark, Block door, Block material, Block stairs, Block slab, Block fence, Block fenceGate, Block button, Block pressurePlate) {
            this.wallLog = () -> ((Block)wallLog).func_176223_P();
            this.trapDoor = () -> ((Block)trapDoor).func_176223_P();
            this.torchDark = () -> ((Block)torchDark).func_176223_P();
            this.door = () -> ((Block)door).func_176223_P();
            this.material = () -> ((Block)material).func_176223_P();
            this.stairs = () -> ((Block)stairs).func_176223_P();
            this.slab = () -> ((Block)slab).func_176223_P();
            this.fence = () -> ((Block)fence).func_176223_P();
            this.fenceGate = () -> ((Block)fenceGate).func_176223_P();
            this.button = () -> ((Block)button).func_176223_P();
            this.pressurePlate = () -> ((Block)pressurePlate).func_176223_P();
        }
    }
}

