/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.theme;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Random;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.theme.Theme;
import xiroc.dungeoncrawl.util.WeightedIntegerEntry;
import xiroc.dungeoncrawl.util.WeightedRandomInteger;

public class WeightedThemeRandomizer
implements Theme.ThemeRandomizer {
    public int base;
    public WeightedRandomInteger themes;

    public WeightedThemeRandomizer(WeightedIntegerEntry[] entries, int base) {
        this.themes = new WeightedRandomInteger(entries);
        this.base = base;
    }

    @Override
    public int randomize(Random rand, int base) {
        return this.themes.roll(rand);
    }

    public static class Deserializer
    implements JsonDeserializer<WeightedThemeRandomizer> {
        public WeightedThemeRandomizer deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = json.getAsJsonObject();
            int base = object.get("base").getAsInt();
            WeightedIntegerEntry[] entries = (WeightedIntegerEntry[])DungeonCrawl.GSON.fromJson(object.get("entries"), WeightedIntegerEntry[].class);
            return new WeightedThemeRandomizer(entries, base);
        }
    }
}

