/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.util;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Unit;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.dungeon.model.DungeonModels;
import xiroc.dungeoncrawl.dungeon.model.ModelBlockDefinition;
import xiroc.dungeoncrawl.dungeon.monster.RandomEquipment;
import xiroc.dungeoncrawl.dungeon.monster.RandomMonster;
import xiroc.dungeoncrawl.dungeon.monster.RandomPotionEffect;
import xiroc.dungeoncrawl.dungeon.monster.SpawnRates;
import xiroc.dungeoncrawl.dungeon.treasure.RandomItems;
import xiroc.dungeoncrawl.theme.Theme;

public class DataReloadListener
implements IFutureReloadListener {
    public void reload(IResourceManager resourceManager) {
        DungeonCrawl.LOGGER.info("Loading data...");
        DungeonModels.load(resourceManager);
        Theme.loadJson(resourceManager);
        SpawnRates.loadJson(resourceManager);
        RandomItems.loadJson(resourceManager);
        RandomMonster.loadJson(resourceManager);
        RandomEquipment.loadJson(resourceManager);
        RandomPotionEffect.loadJson(resourceManager);
        if (((Boolean)Config.ENABLE_TOOLS.get()).booleanValue()) {
            ModelBlockDefinition.loadJson(resourceManager);
        }
        DungeonCrawl.LOGGER.info("Finished data loading.");
    }

    public CompletableFuture<Void> func_215226_a(IFutureReloadListener.IStage stage, IResourceManager resourceManager, IProfiler preparationsProfiler, IProfiler reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        return stage.func_216872_a((Object)Unit.INSTANCE).thenRunAsync(() -> this.reload(resourceManager), gameExecutor);
    }
}

