/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.util;

import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import xiroc.dungeoncrawl.dungeon.block.Chest;
import xiroc.dungeoncrawl.dungeon.block.Dispenser;
import xiroc.dungeoncrawl.dungeon.block.Furnace;
import xiroc.dungeoncrawl.dungeon.block.Plants;
import xiroc.dungeoncrawl.dungeon.block.Spawner;
import xiroc.dungeoncrawl.dungeon.treasure.Treasure;

public interface IBlockPlacementHandler {
    public static final IBlockPlacementHandler CHEST = new Chest();
    public static final IBlockPlacementHandler TRAPPED_CHEST = new Chest.TrappedChest();
    public static final IBlockPlacementHandler SPAWNER = new Spawner();
    public static final HashMap<Block, IBlockPlacementHandler> PLACEMENT_HANDLERS = new HashMap();
    public static final IBlockPlacementHandler DEFAULT = (world, state, pos, rand, treasureType, theme, lootLevel) -> world.func_180501_a(pos, state, 2);

    public static void init() {
        PLACEMENT_HANDLERS.put(Blocks.field_150486_ae, CHEST);
        PLACEMENT_HANDLERS.put(Blocks.field_150447_bR, TRAPPED_CHEST);
        PLACEMENT_HANDLERS.put(Blocks.field_222422_lK, CHEST);
        PLACEMENT_HANDLERS.put(Blocks.field_150460_al, new Furnace());
        PLACEMENT_HANDLERS.put(Blocks.field_222423_lL, new Furnace.Smoker());
        PLACEMENT_HANDLERS.put(Blocks.field_150474_ac, SPAWNER);
        PLACEMENT_HANDLERS.put(Blocks.field_150367_z, new Dispenser());
        PLACEMENT_HANDLERS.put(Blocks.field_150458_ak, new Plants.Farmland());
        PLACEMENT_HANDLERS.put(Blocks.field_150457_bL, new Plants.FlowerPot());
        PLACEMENT_HANDLERS.put(Blocks.field_196661_l, new Plants.Podzol());
    }

    public void placeBlock(IWorld var1, BlockState var2, BlockPos var3, Random var4, Treasure.Type var5, int var6, int var7);

    public static IBlockPlacementHandler getHandler(Block block) {
        return PLACEMENT_HANDLERS.getOrDefault(block, DEFAULT);
    }
}

