/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.util;

import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.vector.Vector3i;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.util.IRandom;

public class Orientation {
    private static final Direction[] FACINGS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.DOWN, Direction.UP};
    public static final IRandom<Direction> RANDOM_FACING = rand -> FACINGS[rand.nextInt(FACINGS.length)];
    public static final IRandom<Direction> RANDOM_FACING_FLAT = rand -> FACINGS[rand.nextInt(4)];
    public static final Direction[] FLAT_FACINGS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    public static final Direction[] EAST_SOUTH_WEST = new Direction[]{Direction.EAST, Direction.SOUTH, Direction.WEST};
    public static final Direction[] EAST_NORTH_WEST = new Direction[]{Direction.EAST, Direction.NORTH, Direction.WEST};
    public static final Direction[] NORTH_SOUTH_EAST = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST};
    public static final Direction[] NORTH_SOUTH_WEST = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST};

    public static Vector3i rotatedMultipartOffset(int pWidth, int pLength, int mWidth, int mLength, Vector3i offset, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_90: {
                return new Vector3i(pLength - offset.func_177952_p() - mLength, offset.func_177956_o(), offset.func_177958_n());
            }
            case CLOCKWISE_180: {
                return new Vector3i(pWidth - offset.func_177958_n() - mWidth, offset.func_177956_o(), pLength - offset.func_177952_p() - mLength);
            }
            case COUNTERCLOCKWISE_90: {
                return new Vector3i(offset.func_177952_p(), offset.func_177956_o(), pWidth - offset.func_177958_n() - mWidth);
            }
        }
        return offset;
    }

    public static Vector3i rotatedMultipartOffset(DungeonModel parent, DungeonModel multipart, Vector3i offset, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_90: {
                return new Vector3i(parent.length - offset.func_177952_p() - multipart.length, offset.func_177956_o(), offset.func_177958_n());
            }
            case CLOCKWISE_180: {
                return new Vector3i(parent.width - offset.func_177958_n() - multipart.width, offset.func_177956_o(), parent.length - offset.func_177952_p() - multipart.length);
            }
            case COUNTERCLOCKWISE_90: {
                return new Vector3i(offset.func_177952_p(), offset.func_177956_o(), parent.width - offset.func_177958_n() - multipart.width);
            }
        }
        return offset;
    }

    public static Direction horizontalOpposite(Direction direction) {
        switch (direction) {
            case NORTH: {
                return Direction.SOUTH;
            }
            case EAST: {
                return Direction.WEST;
            }
            case SOUTH: {
                return Direction.NORTH;
            }
            case WEST: {
                return Direction.EAST;
            }
        }
        return direction;
    }

    public static Direction rotateY(Direction direction) {
        switch (direction) {
            case NORTH: {
                return Direction.EAST;
            }
            case EAST: {
                return Direction.SOUTH;
            }
            case SOUTH: {
                return Direction.WEST;
            }
            case WEST: {
                return Direction.NORTH;
            }
        }
        return direction;
    }

    public static Direction rotateYCCW(Direction direction) {
        switch (direction) {
            case NORTH: {
                return Direction.WEST;
            }
            case EAST: {
                return Direction.NORTH;
            }
            case SOUTH: {
                return Direction.EAST;
            }
            case WEST: {
                return Direction.SOUTH;
            }
        }
        return direction;
    }

    public static Direction[] getFlatFacingsWithout(Direction excludedDirection) {
        switch (excludedDirection) {
            case NORTH: {
                return EAST_SOUTH_WEST;
            }
            case EAST: {
                return NORTH_SOUTH_WEST;
            }
            case SOUTH: {
                return EAST_NORTH_WEST;
            }
            case WEST: {
                return NORTH_SOUTH_EAST;
            }
        }
        DungeonCrawl.LOGGER.error("{} is not a flat direction", (Object)excludedDirection);
        return null;
    }

    public static Rotation getRotationFromFacing(Direction facing) {
        switch (facing) {
            case NORTH: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
            case EAST: {
                return Rotation.NONE;
            }
            case SOUTH: {
                return Rotation.CLOCKWISE_90;
            }
            case WEST: {
                return Rotation.CLOCKWISE_180;
            }
        }
        return Rotation.NONE;
    }

    public static Rotation getOppositeRotationFromFacing(Direction facing) {
        switch (facing) {
            case NORTH: {
                return Rotation.CLOCKWISE_90;
            }
            case EAST: {
                return Rotation.CLOCKWISE_180;
            }
            case SOUTH: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
            case WEST: {
                return Rotation.NONE;
            }
        }
        return Rotation.NONE;
    }

    public static Rotation getRotationFromCW90DoubleFacing(Direction dir1, Direction dir2) {
        switch (dir1) {
            case WEST: {
                switch (dir2) {
                    case SOUTH: {
                        return Rotation.NONE;
                    }
                    case NORTH: {
                        return Rotation.CLOCKWISE_90;
                    }
                }
                return Rotation.NONE;
            }
            case NORTH: {
                switch (dir2) {
                    case WEST: {
                        return Rotation.CLOCKWISE_90;
                    }
                    case EAST: {
                        return Rotation.CLOCKWISE_180;
                    }
                }
                return Rotation.NONE;
            }
            case EAST: {
                switch (dir2) {
                    case NORTH: {
                        return Rotation.CLOCKWISE_180;
                    }
                    case SOUTH: {
                        return Rotation.COUNTERCLOCKWISE_90;
                    }
                }
                return Rotation.NONE;
            }
            case SOUTH: {
                switch (dir2) {
                    case WEST: {
                        return Rotation.NONE;
                    }
                    case EAST: {
                        return Rotation.COUNTERCLOCKWISE_90;
                    }
                }
                return Rotation.NONE;
            }
        }
        return Rotation.NONE;
    }

    public static Rotation getRotationFromTripleFacing(Direction dir1, Direction dir2, Direction dir3) {
        if (Orientation.containsAllThree(dir1, dir2, dir3, EAST_SOUTH_WEST)) {
            return Rotation.NONE;
        }
        if (Orientation.containsAllThree(dir1, dir2, dir3, EAST_NORTH_WEST)) {
            return Rotation.CLOCKWISE_180;
        }
        if (Orientation.containsAllThree(dir1, dir2, dir3, NORTH_SOUTH_EAST)) {
            return Rotation.COUNTERCLOCKWISE_90;
        }
        if (Orientation.containsAllThree(dir1, dir2, dir3, NORTH_SOUTH_WEST)) {
            return Rotation.CLOCKWISE_90;
        }
        return Rotation.NONE;
    }

    public static Rotation getRotation(int rotation) {
        switch (rotation) {
            case 0: {
                return Rotation.NONE;
            }
            case 1: {
                return Rotation.CLOCKWISE_90;
            }
            case 2: {
                return Rotation.CLOCKWISE_180;
            }
            case 3: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        return Rotation.NONE;
    }

    public static int getInt(Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                return 2;
            }
            case CLOCKWISE_90: {
                return 1;
            }
            case COUNTERCLOCKWISE_90: {
                return 3;
            }
            case NONE: {
                return 0;
            }
        }
        return 0;
    }

    public static boolean containsAllThree(Direction dir1, Direction dir2, Direction dir3, Direction[] directions) {
        boolean d1 = false;
        boolean d2 = false;
        boolean d3 = false;
        for (Direction d : directions) {
            if (d == dir1) {
                d1 = true;
                continue;
            }
            if (d == dir2) {
                d2 = true;
                continue;
            }
            if (d != dir3) continue;
            d3 = true;
        }
        return d1 && d2 && d3;
    }
}

