/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.util;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.Vec3Argument;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Items;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.jigsaw.JigsawOrientation;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.block.DungeonBlocks;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.model.DungeonModels;
import xiroc.dungeoncrawl.dungeon.model.ModelBlockDefinition;
import xiroc.dungeoncrawl.dungeon.model.ModelHandler;
import xiroc.dungeoncrawl.util.DirectionalBlockPos;

public class Tools {
    private static final HashMap<UUID, Tuple<BlockPos, BlockPos>> POSITIONS = new HashMap();
    private static final BlockState AIR = Blocks.field_150350_a.func_176223_P();

    @SubscribeEvent
    public void onServerStart(FMLServerStartingEvent event) {
        DungeonCrawl.LOGGER.debug("Registering Commands...");
        event.getServer().func_195571_aL().func_197054_a().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"savemodel").requires(a -> {
            try {
                return a.func_197035_h().func_184812_l_();
            }
            catch (CommandSyntaxException e) {
                a.func_197021_a((ITextComponent)new StringTextComponent("You must be a player!"));
                return false;
            }
        })).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.string()).executes(command -> {
            UUID uuid = ((CommandSource)command.getSource()).func_197035_h().func_110124_au();
            if (!POSITIONS.containsKey(uuid)) {
                ((CommandSource)command.getSource()).func_197030_a((ITextComponent)new StringTextComponent(TextFormatting.RED + "Please select two positions."), true);
                return 1;
            }
            Tuple<BlockPos, BlockPos> positions = POSITIONS.get(uuid);
            BlockPos p1 = (BlockPos)positions.func_76341_a();
            BlockPos p2 = (BlockPos)positions.func_76340_b();
            if (p1 != null && p2 != null) {
                BlockPos pos1 = new BlockPos(Math.min(p1.func_177958_n(), p2.func_177958_n()), Math.min(p1.func_177956_o(), p2.func_177956_o()), Math.min(p1.func_177952_p(), p2.func_177952_p()));
                BlockPos pos2 = new BlockPos(Math.max(p1.func_177958_n(), p2.func_177958_n()), Math.max(p1.func_177956_o(), p2.func_177956_o()), Math.max(p1.func_177952_p(), p2.func_177952_p()));
                ModelHandler.readAndSaveModelToFile(StringArgumentType.getString((CommandContext)command, (String)"name"), ModelBlockDefinition.DEFAULT_DEFINITION, ((CommandSource)command.getSource()).func_197035_h().field_70170_p, pos1, pos2.func_177958_n() - pos1.func_177958_n() + 1, pos2.func_177956_o() - pos1.func_177956_o() + 1, pos2.func_177952_p() - pos1.func_177952_p() + 1);
                ((CommandSource)command.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Saving a model..."), true);
                return 0;
            }
            ((CommandSource)command.getSource()).func_197030_a((ITextComponent)new StringTextComponent(TextFormatting.RED + "Please select two positions."), true);
            return 1;
        })).then(Commands.func_197056_a((String)"block definition", (ArgumentType)StringArgumentType.word()).executes(command -> {
            UUID uuid = ((CommandSource)command.getSource()).func_197035_h().func_110124_au();
            if (!POSITIONS.containsKey(uuid)) {
                ((CommandSource)command.getSource()).func_197030_a((ITextComponent)new StringTextComponent(TextFormatting.RED + "Please select two positions."), true);
                return 1;
            }
            Tuple<BlockPos, BlockPos> positions = POSITIONS.get(uuid);
            BlockPos p1 = (BlockPos)positions.func_76341_a();
            BlockPos p2 = (BlockPos)positions.func_76340_b();
            String blockDefinition = StringArgumentType.getString((CommandContext)command, (String)"block definition");
            if (!ModelBlockDefinition.DEFINITIONS.containsKey(blockDefinition)) {
                ((CommandSource)command.getSource()).func_197030_a((ITextComponent)new StringTextComponent(TextFormatting.RED + "Unknown block definition path \"" + blockDefinition + "\""), true);
                return 1;
            }
            if (p1 != null && p2 != null) {
                BlockPos pos1 = new BlockPos(Math.min(p1.func_177958_n(), p2.func_177958_n()), Math.min(p1.func_177956_o(), p2.func_177956_o()), Math.min(p1.func_177952_p(), p2.func_177952_p()));
                BlockPos pos2 = new BlockPos(Math.max(p1.func_177958_n(), p2.func_177958_n()), Math.max(p1.func_177956_o(), p2.func_177956_o()), Math.max(p1.func_177952_p(), p2.func_177952_p()));
                ModelHandler.readAndSaveModelToFile(StringArgumentType.getString((CommandContext)command, (String)"name"), ModelBlockDefinition.DEFINITIONS.get(blockDefinition), ((CommandSource)command.getSource()).func_197035_h().field_70170_p, pos1, pos2.func_177958_n() - pos1.func_177958_n() + 1, pos2.func_177956_o() - pos1.func_177956_o() + 1, pos2.func_177952_p() - pos1.func_177952_p() + 1);
                ((CommandSource)command.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Saving a model..."), true);
                return 0;
            }
            ((CommandSource)command.getSource()).func_197030_a((ITextComponent)new StringTextComponent(TextFormatting.RED + "Please select two positions."), true);
            return 1;
        }))));
        event.getServer().func_195571_aL().func_197054_a().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"buildmodel").requires(a -> a.func_197034_c(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"id", (ArgumentType)IntegerArgumentType.integer()).executes(command -> {
            int id = (Integer)command.getArgument("id", Integer.TYPE);
            DungeonModel model = DungeonModels.MODELS.get(id);
            if (model == null) {
                ((CommandSource)command.getSource()).func_197021_a((ITextComponent)new StringTextComponent("Unknown model id: " + id));
                return 1;
            }
            BlockPos pos = ((CommandSource)command.getSource()).func_197035_h().func_233580_cy_();
            Tools.buildModel(model, (IWorld)((CommandSource)command.getSource()).func_197035_h().field_70170_p, pos, ModelBlockDefinition.DEFAULT_DEFINITION);
            return 0;
        })).then(Commands.func_197056_a((String)"location", (ArgumentType)Vec3Argument.func_197301_a()).executes(command -> {
            int id = (Integer)command.getArgument("id", Integer.TYPE);
            DungeonModel model = DungeonModels.MODELS.get(id);
            if (model == null) {
                ((CommandSource)command.getSource()).func_197021_a((ITextComponent)new StringTextComponent("Unknown model id: " + id));
                return 1;
            }
            BlockPos pos = Vec3Argument.func_200385_b((CommandContext)command, (String)"location").func_197280_c((CommandSource)command.getSource());
            Tools.buildModel(model, (IWorld)((CommandSource)command.getSource()).func_197035_h().field_70170_p, pos, ModelBlockDefinition.DEFAULT_DEFINITION);
            return 0;
        }))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"block definition", (ArgumentType)StringArgumentType.word()).executes(command -> {
            int id = (Integer)command.getArgument("id", Integer.TYPE);
            DungeonModel model = DungeonModels.MODELS.get(id);
            String key = StringArgumentType.getString((CommandContext)command, (String)"block definition");
            if (model != null) {
                if (!ModelBlockDefinition.DEFINITIONS.containsKey(key)) {
                    ((CommandSource)command.getSource()).func_197030_a((ITextComponent)new StringTextComponent(TextFormatting.RED + "Unknown block definition: " + key), true);
                    return 1;
                }
            } else {
                ((CommandSource)command.getSource()).func_197021_a((ITextComponent)new StringTextComponent("Unknown model id: " + id));
                return 1;
            }
            BlockPos pos = ((CommandSource)command.getSource()).func_197035_h().func_233580_cy_();
            Tools.buildModel(model, (IWorld)((CommandSource)command.getSource()).func_197035_h().field_70170_p, pos, ModelBlockDefinition.DEFINITIONS.get(key));
            return 0;
        })).then(Commands.func_197056_a((String)"location", (ArgumentType)Vec3Argument.func_197301_a()).executes(command -> {
            int id = (Integer)command.getArgument("id", Integer.TYPE);
            DungeonModel model = DungeonModels.MODELS.get(id);
            String key = StringArgumentType.getString((CommandContext)command, (String)"block definition");
            if (model != null) {
                if (!ModelBlockDefinition.DEFINITIONS.containsKey(key)) {
                    ((CommandSource)command.getSource()).func_197030_a((ITextComponent)new StringTextComponent(TextFormatting.RED + "Unknown block definition: " + key), true);
                    return 1;
                }
            } else {
                ((CommandSource)command.getSource()).func_197021_a((ITextComponent)new StringTextComponent("Unknown model id: " + id));
                return 1;
            }
            BlockPos pos = Vec3Argument.func_200385_b((CommandContext)command, (String)"location").func_197280_c((CommandSource)command.getSource());
            Tools.buildModel(model, (IWorld)((CommandSource)command.getSource()).func_197035_h().field_70170_p, pos, ModelBlockDefinition.DEFINITIONS.get(key));
            return 0;
        }))))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"key", (ArgumentType)StringArgumentType.string()).executes(command -> {
            String key = StringArgumentType.getString((CommandContext)command, (String)"key");
            DungeonModel model = DungeonModels.PATH_TO_MODEL.get(key);
            if (model == null) {
                ((CommandSource)command.getSource()).func_197021_a((ITextComponent)new StringTextComponent("Unknown model key: " + key));
                return 1;
            }
            BlockPos pos = ((CommandSource)command.getSource()).func_197035_h().func_233580_cy_();
            Tools.buildModel(model, (IWorld)((CommandSource)command.getSource()).func_197035_h().field_70170_p, pos, ModelBlockDefinition.DEFAULT_DEFINITION);
            return 0;
        })).then(Commands.func_197056_a((String)"location", (ArgumentType)Vec3Argument.func_197301_a()).executes(command -> {
            String key = StringArgumentType.getString((CommandContext)command, (String)"key");
            DungeonModel model = DungeonModels.PATH_TO_MODEL.get(key);
            if (model == null) {
                ((CommandSource)command.getSource()).func_197021_a((ITextComponent)new StringTextComponent("Unknown model key: " + key));
                return 1;
            }
            BlockPos pos = Vec3Argument.func_200385_b((CommandContext)command, (String)"location").func_197280_c((CommandSource)command.getSource());
            Tools.buildModel(model, (IWorld)((CommandSource)command.getSource()).func_197035_h().field_70170_p, pos, ModelBlockDefinition.DEFAULT_DEFINITION);
            return 0;
        }))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"block definition", (ArgumentType)StringArgumentType.word()).executes(command -> {
            String key = StringArgumentType.getString((CommandContext)command, (String)"key");
            String blockDefinition = StringArgumentType.getString((CommandContext)command, (String)"block definition");
            DungeonModel model = DungeonModels.PATH_TO_MODEL.get(key);
            if (model != null) {
                if (!ModelBlockDefinition.DEFINITIONS.containsKey(blockDefinition)) {
                    ((CommandSource)command.getSource()).func_197030_a((ITextComponent)new StringTextComponent(TextFormatting.RED + "Unknown block definition: " + blockDefinition), true);
                    return 1;
                }
            } else {
                ((CommandSource)command.getSource()).func_197021_a((ITextComponent)new StringTextComponent("Unknown model key: " + key));
                return 1;
            }
            BlockPos pos = ((CommandSource)command.getSource()).func_197035_h().func_233580_cy_();
            Tools.buildModel(model, (IWorld)((CommandSource)command.getSource()).func_197035_h().field_70170_p, pos, ModelBlockDefinition.DEFINITIONS.get(blockDefinition));
            return 0;
        })).then(Commands.func_197056_a((String)"location", (ArgumentType)Vec3Argument.func_197301_a()).executes(command -> {
            String key = StringArgumentType.getString((CommandContext)command, (String)"key");
            String blockDefinition = StringArgumentType.getString((CommandContext)command, (String)"block definition");
            DungeonModel model = DungeonModels.PATH_TO_MODEL.get(key);
            if (model != null) {
                if (!ModelBlockDefinition.DEFINITIONS.containsKey(blockDefinition)) {
                    ((CommandSource)command.getSource()).func_197030_a((ITextComponent)new StringTextComponent(TextFormatting.RED + "Unknown block definition: " + blockDefinition), true);
                    return 1;
                }
            } else {
                ((CommandSource)command.getSource()).func_197021_a((ITextComponent)new StringTextComponent("Unknown model key: " + key));
                return 1;
            }
            BlockPos pos = Vec3Argument.func_200385_b((CommandContext)command, (String)"location").func_197280_c((CommandSource)command.getSource());
            Tools.buildModel(model, (IWorld)((CommandSource)command.getSource()).func_197035_h().field_70170_p, pos, ModelBlockDefinition.DEFINITIONS.get(blockDefinition));
            return 0;
        })))));
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (!event.getWorld().func_201670_d() && event.getPlayer().func_184812_l_() && event.getPlayer().func_184582_a(EquipmentSlotType.MAINHAND).func_77973_b() == Items.field_151056_x) {
            event.setCanceled(true);
            BlockPos pos = event.getPos();
            UUID uuid = event.getPlayer().func_146103_bH().getId();
            if (POSITIONS.containsKey(uuid)) {
                BlockPos position2 = (BlockPos)POSITIONS.get(uuid).func_76340_b();
                POSITIONS.put(uuid, (Tuple<BlockPos, BlockPos>)new Tuple((Object)pos, (Object)position2));
            } else {
                POSITIONS.put(uuid, (Tuple<BlockPos, BlockPos>)new Tuple((Object)pos, null));
            }
            event.getPlayer().func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.LIGHT_PURPLE + "Position 1 set to (" + pos.func_177958_n() + " | " + pos.func_177956_o() + " | " + pos.func_177952_p() + ") "), event.getPlayer().func_110124_au());
        }
    }

    @SubscribeEvent
    public void onItemUse(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getPlayer().field_70170_p;
        if (!world.func_201670_d() && event.getPlayer().func_184812_l_() && event.getItemStack().func_77973_b() == Items.field_151056_x) {
            event.setCanceled(true);
            BlockPos pos = event.getPos();
            UUID uuid = event.getPlayer().func_146103_bH().getId();
            if (POSITIONS.containsKey(uuid)) {
                BlockPos position1 = (BlockPos)POSITIONS.get(uuid).func_76341_a();
                POSITIONS.put(uuid, (Tuple<BlockPos, BlockPos>)new Tuple((Object)position1, (Object)pos));
            } else {
                POSITIONS.put(uuid, (Tuple<BlockPos, BlockPos>)new Tuple(null, (Object)pos));
            }
            event.getPlayer().func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.LIGHT_PURPLE + "Position 2 set to (" + pos.func_177958_n() + " | " + pos.func_177956_o() + " | " + pos.func_177952_p() + ") "), event.getPlayer().func_110124_au());
        }
    }

    public static void buildModel(DungeonModel model, IWorld world, BlockPos pos, ModelBlockDefinition definition) {
        for (int y = 0; y < model.height; ++y) {
            for (int x = 0; x < model.width; ++x) {
                for (int z = 0; z < model.length; ++z) {
                    BlockPos placePos = new BlockPos(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z);
                    if (model.model[x][y][z] == null) {
                        world.func_180501_a(placePos, AIR, 3);
                        continue;
                    }
                    Block block = definition.getBlock(model.model[x][y][z]);
                    if (block == null) {
                        block = Blocks.field_150350_a;
                    }
                    world.func_180501_a(placePos, (BlockState)model.model[x][y][z].create(definition.getBlock(model.model[x][y][z]).func_176223_P(), world, pos, Rotation.NONE).func_76341_a(), 3);
                    world.func_230547_a_(placePos, world.func_180495_p(placePos).func_177230_c());
                }
            }
        }
        if (model.featurePositions != null) {
            for (DungeonModel.FeaturePosition featurePosition : model.featurePositions) {
                DirectionalBlockPos blockPos = featurePosition.directionalBlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                world.func_180501_a(blockPos.position, (BlockState)Blocks.field_226904_lY_.func_176223_P().func_206870_a((Property)BlockStateProperties.field_235907_P_, (Comparable)Tools.getJigsawOrientation(blockPos.direction)), 3);
            }
        }
    }

    public void debugModel(DungeonModel model, IWorld world, BlockPos pos) {
        for (int x = 0; x < model.width; ++x) {
            for (int y = 0; y < model.height; ++y) {
                for (int z = 0; z < model.length; ++z) {
                    if (model.model[x][y][z] == null) {
                        world.func_180501_a(new BlockPos(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z), DungeonBlocks.CAVE_AIR, 2);
                        continue;
                    }
                    world.func_180501_a(new BlockPos(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z), Blocks.field_180399_cE.func_176223_P(), 3);
                }
            }
            if (model.featurePositions == null) continue;
            for (DungeonModel.FeaturePosition f : model.featurePositions) {
                world.func_180501_a(new BlockPos(pos.func_177958_n() + f.position.func_177958_n(), pos.func_177956_o() + f.position.func_177956_o(), pos.func_177952_p() + f.position.func_177952_p()), (BlockState)Blocks.field_226904_lY_.func_176223_P().func_206870_a((Property)BlockStateProperties.field_235907_P_, (Comparable)Tools.getJigsawOrientation(f.facing)), 3);
            }
        }
    }

    public void debugModelRotated(DungeonModel model, IWorld world, BlockPos pos, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_90: {
                for (int x = 0; x < model.width; ++x) {
                    for (int y = 0; y < model.height; ++y) {
                        for (int z = 0; z < model.length; ++z) {
                            if (model.model[x][y][z] == null) {
                                world.func_180501_a(new BlockPos(pos.func_177958_n() + model.length - z - 1, pos.func_177956_o() + y, pos.func_177952_p() + x), DungeonBlocks.CAVE_AIR, 2);
                                continue;
                            }
                            world.func_180501_a(new BlockPos(pos.func_177958_n() + model.length - z - 1, pos.func_177956_o() + y, pos.func_177952_p() + x), Blocks.field_180399_cE.func_176223_P(), 3);
                        }
                    }
                }
                if (model.featurePositions == null) break;
                for (DungeonModel.FeaturePosition f : model.featurePositions) {
                    world.func_180501_a(new BlockPos(pos.func_177958_n() + model.length - f.position.func_177952_p() - 1, pos.func_177956_o() + f.position.func_177956_o(), pos.func_177952_p() + f.position.func_177958_n()), (BlockState)Blocks.field_226904_lY_.func_176223_P().func_206870_a((Property)BlockStateProperties.field_235907_P_, (Comparable)Tools.getJigsawOrientation(f.facing.func_176746_e())), 3);
                }
                break;
            }
            case COUNTERCLOCKWISE_90: {
                for (int x = 0; x < model.width; ++x) {
                    for (int y = 0; y < model.height; ++y) {
                        for (int z = 0; z < model.length; ++z) {
                            if (model.model[x][y][z] == null) {
                                world.func_180501_a(new BlockPos(pos.func_177958_n() + z, pos.func_177956_o() + y, pos.func_177952_p() + model.width - x - 1), DungeonBlocks.CAVE_AIR, 2);
                                continue;
                            }
                            world.func_180501_a(new BlockPos(pos.func_177958_n() + z, pos.func_177956_o() + y, pos.func_177952_p() + model.width - x - 1), Blocks.field_180399_cE.func_176223_P(), 2);
                        }
                    }
                }
                if (model.featurePositions == null) break;
                for (DungeonModel.FeaturePosition f : model.featurePositions) {
                    world.func_180501_a(new BlockPos(pos.func_177958_n() + f.position.func_177952_p(), pos.func_177956_o() + f.position.func_177956_o(), pos.func_177952_p() + model.width - f.position.func_177958_n() - 1), (BlockState)Blocks.field_226904_lY_.func_176223_P().func_206870_a((Property)BlockStateProperties.field_235907_P_, (Comparable)Tools.getJigsawOrientation(f.facing.func_176735_f())), 3);
                }
                break;
            }
            case CLOCKWISE_180: {
                for (int x = 0; x < model.width; ++x) {
                    for (int y = 0; y < model.height; ++y) {
                        for (int z = 0; z < model.length; ++z) {
                            if (model.model[x][y][z] == null) {
                                world.func_180501_a(new BlockPos(pos.func_177958_n() + model.width - x - 1, pos.func_177956_o() + y, pos.func_177952_p() + model.length - z - 1), DungeonBlocks.CAVE_AIR, 2);
                                continue;
                            }
                            world.func_180501_a(new BlockPos(pos.func_177958_n() + model.width - x - 1, pos.func_177956_o() + y, pos.func_177952_p() + model.length - z - 1), Blocks.field_180399_cE.func_176223_P(), 2);
                        }
                    }
                }
                if (model.featurePositions == null) break;
                for (DungeonModel.FeaturePosition f : model.featurePositions) {
                    world.func_180501_a(new BlockPos(pos.func_177958_n() + model.width - f.position.func_177958_n() - 1, pos.func_177956_o() + f.position.func_177956_o(), pos.func_177952_p() + model.length - f.position.func_177952_p() - 1), (BlockState)Blocks.field_226904_lY_.func_176223_P().func_206870_a((Property)BlockStateProperties.field_235907_P_, (Comparable)Tools.getJigsawOrientation(f.facing.func_176734_d())), 3);
                }
                break;
            }
            case NONE: {
                this.debugModel(model, world, pos);
                break;
            }
            default: {
                DungeonCrawl.LOGGER.warn("Failed to build a rotated dungeon segment: Unsupported rotation " + rotation);
            }
        }
    }

    private static JigsawOrientation getJigsawOrientation(Direction primary) {
        switch (primary) {
            case EAST: 
            case WEST: 
            case SOUTH: 
            case NORTH: {
                return JigsawOrientation.func_239641_a_((Direction)primary, (Direction)Direction.UP);
            }
            case UP: 
            case DOWN: {
                return JigsawOrientation.func_239641_a_((Direction)primary, (Direction)Direction.EAST);
            }
        }
        return JigsawOrientation.NORTH_UP;
    }

    private static String nbtToString(INBT nbt) {
        if (nbt != null) {
            return nbt.toString();
        }
        return "N/A";
    }
}

