/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.util;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import xiroc.dungeoncrawl.dungeon.decoration.IDungeonDecoration;
import xiroc.dungeoncrawl.dungeon.monster.RandomEquipment;
import xiroc.dungeoncrawl.util.IRandom;

public class WeightedRandom<T>
implements IRandom<T> {
    public static final JsonReader<Item> ITEM = array -> {
        Builder builder = new Builder();
        array.forEach(element -> {
            JsonObject object = element.getAsJsonObject();
            int weight = object.has("weight") ? object.get("weight").getAsInt() : 1;
            builder.add(RandomEquipment.getItem(new ResourceLocation(object.get("item").getAsString())), weight);
        });
        return builder.build();
    };
    public static final JsonReader<IDungeonDecoration> DECORATION = array -> {
        Builder builder = new Builder();
        array.forEach(element -> {
            JsonObject object = element.getAsJsonObject();
            int weight = object.has("weight") ? object.get("weight").getAsInt() : 1;
            IDungeonDecoration decoration = IDungeonDecoration.fromJson(object);
            if (decoration != null) {
                builder.entries.add(new Tuple((Object)weight, (Object)decoration));
            }
        });
        return builder.build();
    };
    private final int totalWeight;
    private final List<Tuple<Integer, T>> entries;

    public WeightedRandom(List<Tuple<Integer, T>> entries) {
        int weight = 0;
        for (Tuple<Integer, T> entry : entries) {
            weight += ((Integer)entry.func_76341_a()).intValue();
        }
        this.totalWeight = weight;
        this.entries = new ArrayList<Tuple<Integer, T>>();
        this.assign(entries);
    }

    private void assign(List<Tuple<Integer, T>> values) {
        int currentWeight = 0;
        for (Tuple<Integer, T> entry : values) {
            this.entries.add(new Tuple((Object)(currentWeight += ((Integer)entry.func_76341_a()).intValue()), entry.func_76340_b()));
        }
    }

    @Override
    public T roll(Random rand) {
        int r = rand.nextInt(this.totalWeight);
        for (Tuple<Integer, T> entry : this.entries) {
            if (r >= (Integer)entry.func_76341_a()) continue;
            return (T)entry.func_76340_b();
        }
        return null;
    }

    @FunctionalInterface
    public static interface JsonReader<T> {
        public WeightedRandom<T> fromJson(JsonArray var1);
    }

    public static class Builder<T> {
        public List<Tuple<Integer, T>> entries = Lists.newArrayList();

        public Builder<T> add(T t, int weight) {
            this.entries.add(new Tuple((Object)weight, t));
            return this;
        }

        public Builder<T> add(List<Tuple<Integer, T>> entries) {
            this.entries.addAll(entries);
            return this;
        }

        public WeightedRandom<T> build() {
            return new WeightedRandom<T>(this.entries);
        }
    }
}

