/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.util;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.util.Tuple;
import xiroc.dungeoncrawl.util.IRandom;
import xiroc.dungeoncrawl.util.WeightedIntegerEntry;

public class WeightedRandomInteger
implements IRandom<Integer> {
    public static final Random RANDOM = new Random();
    private int totalWeight;
    public WeightedInteger[] integers;

    public WeightedRandomInteger(WeightedIntegerEntry[] entries) {
        int weight = 0;
        for (WeightedIntegerEntry entry : entries) {
            weight += ((Integer)entry.func_76341_a()).intValue();
        }
        this.totalWeight = weight;
        this.integers = new WeightedInteger[entries.length];
        this.assign(entries);
    }

    private void assign(WeightedIntegerEntry[] values) {
        float f = 0.0f;
        int i = 0;
        for (WeightedIntegerEntry entry : values) {
            float weight = (float)((Integer)entry.func_76341_a()).intValue() / (float)this.totalWeight;
            this.integers[i] = new WeightedInteger(Float.valueOf(weight + f), (Integer)entry.func_76340_b());
            f += weight;
            ++i;
        }
    }

    @Override
    public Integer roll(Random rand) {
        float f = rand.nextFloat();
        for (WeightedInteger entry : this.integers) {
            if (!(((Float)entry.func_76341_a()).floatValue() >= f)) continue;
            return (Integer)entry.func_76340_b();
        }
        return null;
    }

    public static class Builder {
        public List<WeightedIntegerEntry> entries = Lists.newArrayList();

        public Builder add(WeightedIntegerEntry[] entries) {
            this.entries.addAll(Arrays.asList(entries));
            return this;
        }

        public WeightedRandomInteger build() {
            return new WeightedRandomInteger(this.entries.toArray(new WeightedIntegerEntry[0]));
        }
    }

    public static class WeightedInteger
    extends Tuple<Float, Integer> {
        public WeightedInteger(Float aIn, Integer bIn) {
            super((Object)aIn, (Object)bIn);
        }
    }
}

