/*
 * Decompiled with CFR 0.152.
 */
package com.performant.coremod.mixin.entity;

import com.performant.coremod.entity.threading.IThreadedMoveEntity;
import com.performant.coremod.world.ChunkCache;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.FluidState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Shadow
    public World field_70170_p;
    Entity self = (Entity)this;
    private short brightCounter = 0;
    private float brightness = 0.0f;

    @Shadow
    public abstract double func_226280_cw_();

    @Shadow
    public abstract double func_226277_ct_();

    @Shadow
    public abstract double func_226281_cx_();

    @Redirect(method={"isInBubbleColumn"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;getBlockState(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/BlockState;"))
    public BlockState onisInBubbleColumn(World world, BlockPos pos) {
        if (this.self instanceof IThreadedMoveEntity) {
            return ((IThreadedMoveEntity)this.self).getCache().func_180495_p(pos);
        }
        return world.func_180495_p(pos);
    }

    @Overwrite
    public boolean func_209511_p() {
        BlockPos pos = this.self.func_233580_cy_();
        if (this.self instanceof IThreadedMoveEntity) {
            ChunkCache cache = ((IThreadedMoveEntity)this.self).getCache();
            boolean flag = cache.isRainingAt(pos) || cache.isRainingAt(new BlockPos(this.self.func_226277_ct_(), this.self.func_226278_cu_() + (double)this.self.func_213302_cg(), this.self.func_226281_cx_()));
            return flag;
        }
        boolean flag = this.self.field_70170_p.func_175727_C(pos) || this.self.field_70170_p.func_175727_C(new BlockPos(this.self.func_226277_ct_(), this.self.func_226278_cu_() + (double)this.self.func_213302_cg(), this.self.func_226281_cx_()));
        return flag;
    }

    @Inject(method={"updateEyesInWater"}, at={@At(value="INVOKE", target="Lnet/minecraft/tags/FluidTags;func_241280_c_()Ljava/util/List;", shift=At.Shift.BEFORE)}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD)
    private void afterGetFluidState(CallbackInfo ci, double d0, Entity entity, BlockPos blockpos, FluidState fluidstate) {
        if (fluidstate.func_206888_e()) {
            ci.cancel();
        }
    }

    @Redirect(method={"updateEyesInWater"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;getFluidState(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/fluid/FluidState;"))
    public FluidState onGetFluidState(World world, BlockPos pos) {
        if (this.self instanceof IThreadedMoveEntity) {
            return ((IThreadedMoveEntity)this.self).getCache().func_204610_c(pos);
        }
        return world.func_204610_c(pos);
    }

    @Redirect(method={"updateEyesInWater"}, at=@At(value="INVOKE", target="Lnet/minecraft/fluid/FluidState;getActualHeight(Lnet/minecraft/world/IBlockReader;Lnet/minecraft/util/math/BlockPos;)F"))
    public float onGetFluidStateHeight(FluidState fluidState, IBlockReader world, BlockPos pos) {
        if (this.self instanceof IThreadedMoveEntity) {
            return fluidState.func_215679_a((IBlockReader)((IThreadedMoveEntity)this.self).getCache(), pos);
        }
        return fluidState.func_215679_a(world, pos);
    }

    @Redirect(method={"setRawPosition"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;getChunk(II)Lnet/minecraft/world/chunk/Chunk;"))
    public Chunk onSetRawPosition(World world, int chunkX, int chunkZ) {
        if (this.self instanceof IThreadedMoveEntity) {
            return (Chunk)((IThreadedMoveEntity)this.self).getCache().func_212866_a_(chunkX, chunkZ);
        }
        return world.func_212866_a_(chunkX, chunkZ);
    }

    @Overwrite
    public float func_70013_c() {
        this.brightCounter = (short)(this.brightCounter + 1);
        if (this.brightCounter != 30) {
            return this.brightness;
        }
        this.brightCounter = 0;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable(this.func_226277_ct_(), 0.0, this.func_226281_cx_());
        if (this.field_70170_p.func_175667_e((BlockPos)blockpos$mutable)) {
            blockpos$mutable.func_185336_p(MathHelper.func_76128_c((double)this.func_226280_cw_()));
            this.brightness = this.field_70170_p.func_205052_D((BlockPos)blockpos$mutable);
        } else {
            this.brightness = 0.0f;
        }
        return this.brightness;
    }

    @Redirect(method={"func_233569_aL_"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;getBlockState(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/BlockState;"))
    private BlockState onWakeupGetBlockState(World world, BlockPos pos) {
        if (this.self instanceof IThreadedMoveEntity) {
            return ((IThreadedMoveEntity)this.self).getCache().func_180495_p(pos);
        }
        return world.func_180495_p(pos);
    }
}

