/*
 * Decompiled with CFR 0.152.
 */
package com.performant.coremod.mixin.world;

import com.performant.coremod.Performant;
import com.performant.coremod.config.ConfigurationCache;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerWorld.class})
public abstract class ServerWorldMixin {
    ServerWorld self = (ServerWorld)this;
    private ConcurrentHashMap<Entity, Entity> toAdd = new ConcurrentHashMap();
    private boolean addingLate = false;

    @Shadow
    public abstract boolean func_217376_c(Entity var1);

    @Shadow
    public abstract ServerWorld func_201672_e();

    @Inject(method={"save"}, at={@At(value="HEAD")})
    public void save(@Nullable IProgressUpdate progress, boolean flush, boolean skipSave, CallbackInfo c) {
        if (ConfigurationCache.printWorldSaves) {
            Performant.LOGGER.info("World save triggered dim:" + this.self.func_230315_m_().toString(), (Throwable)new Exception("world save trace, no error"));
        }
    }

    @Inject(method={"addEntity"}, at={@At(value="HEAD")}, cancellable=true)
    public void OnaddEntity(Entity entityIn, CallbackInfoReturnable<Boolean> c) {
        if (!Thread.currentThread().getName().contains("Server") && !Thread.currentThread().getName().contains("Render")) {
            this.toAdd.put(entityIn, entityIn);
            c.cancel();
        } else if (!this.addingLate) {
            this.addingLate = true;
            Iterator<Entity> it = this.toAdd.values().iterator();
            while (it.hasNext()) {
                this.func_217376_c(it.next());
                it.remove();
            }
            this.addingLate = false;
        }
    }

    @Inject(method={"onEntityAdded"}, at={@At(value="HEAD")})
    public void onEntityAdded(Entity entity, CallbackInfo ci) {
        if (!Thread.currentThread().getName().contains("Server") && !Thread.currentThread().getName().contains("Render")) {
            Performant.LOGGER.warn("Adding entity from other thread!:" + Thread.currentThread().getName(), (Throwable)new Exception());
        }
    }
}

