/*
 * Decompiled with CFR 0.152.
 */
package com.performant.coremod.mixin.world.chunk;

import com.mojang.datafixers.util.Either;
import com.performant.coremod.Performant;
import com.performant.coremod.config.ConfigurationCache;
import com.performant.coremod.world.IServerChunkProviderThreadsUnloadChunk;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ServerChunkProvider;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerChunkProvider.class})
public abstract class ServerChunkProviderThreadsMixin
implements IServerChunkProviderThreadsUnloadChunk {
    private final Map<Long, IChunk> threadCache = new ConcurrentHashMap<Long, IChunk>();
    ServerChunkProvider self = (ServerChunkProvider)this;
    @Shadow
    @Final
    private Thread field_217241_g;

    @Inject(method={"getChunk"}, at={@At(value="RETURN")})
    public void getChunk(int p_212849_1_, int p_212849_2_, ChunkStatus p_212849_3_, boolean p_212849_4_, CallbackInfoReturnable<IChunk> c) {
        if (Thread.currentThread() != this.field_217241_g && p_212849_3_ == ChunkStatus.field_222617_m && c.getReturnValue() != null) {
            this.threadCache.put(ChunkPos.func_77272_a((int)p_212849_1_, (int)p_212849_2_), (IChunk)c.getReturnValue());
        }
    }

    @Inject(method={"getChunk"}, at={@At(value="HEAD")}, cancellable=true)
    public void OngetChunk(int p_212849_1_, int p_212849_2_, ChunkStatus p_212849_3_, boolean p_212849_4_, CallbackInfoReturnable<IChunk> c) {
        if (Thread.currentThread() != this.field_217241_g && p_212849_3_ == ChunkStatus.field_222617_m) {
            IChunk chunk = null;
            chunk = this.threadCache.get(ChunkPos.func_77272_a((int)p_212849_1_, (int)p_212849_2_));
            if (chunk != null && c != null) {
                c.setReturnValue((Object)chunk);
            }
        }
        if (ConfigurationCache.currentLoaded != ConfigurationCache.NONE && ConfigurationCache.currentLoaded.field_77276_a == p_212849_1_ && ConfigurationCache.currentLoaded.field_77275_b == p_212849_2_) {
            Performant.LOGGER.warn("Accessing a chunk through the world while loading can cause deadlocks, logging call trace:", (Throwable)new Exception());
        }
    }

    @Override
    public void onChunkUnloadClean(long pos) {
        this.threadCache.remove(pos);
    }

    @Inject(method={"func_217233_c"}, at={@At(value="INVOKE", target="net/minecraft/world/server/ServerWorld.getProfiler ()Lnet/minecraft/profiler/IProfiler;")})
    private void onChunkLoadDebug(int chunkX, int chunkZ, ChunkStatus requiredStatus, boolean load, CallbackInfoReturnable<CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>>> cir) {
        if (ConfigurationCache.debugOptionsEnabled && requiredStatus == ChunkStatus.field_222617_m) {
            Performant.LOGGER.warn("Trying to load chunk at blockpos X:" + (chunkX << 4) + " Z:" + (chunkZ << 4), (Throwable)new Exception("Chunk load debug"));
        }
    }
}

