/*
 * Decompiled with CFR 0.152.
 */
package com.performant.coremod.network;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.command.CommandSource;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;

public class NetworkPacketUsageReporter {
    private static Map<String, PacketData> packetToBytes = new HashMap<String, PacketData>();
    private static long totalBytes = 0L;
    private static long start = 0L;
    private static long stop = 0L;
    public static boolean recordData = false;

    public static void addPacketData(String name, long bytes) {
        totalBytes += bytes;
        PacketData data = packetToBytes.get(name);
        if (data == null) {
            data = new PacketData(name);
        }
        data.add(bytes);
        packetToBytes.put(name, data);
    }

    public static void startRecordNetworkData() {
        recordData = true;
        start = System.currentTimeMillis();
        packetToBytes = new HashMap<String, PacketData>();
        totalBytes = 0L;
    }

    public static void stopAndReport(CommandSource source, int startIndex) {
        if (recordData) {
            recordData = false;
            stop = System.currentTimeMillis();
        }
        ArrayList<PacketData> dataList = new ArrayList<PacketData>(packetToBytes.values());
        dataList.sort(Comparator.comparingLong(PacketData::getBytes).reversed());
        if (dataList.isEmpty()) {
            source.func_197030_a((ITextComponent)new StringTextComponent("No message data was recorded, try the recordMessages command first!"), true);
            return;
        }
        long time = (stop - start) / 1000L;
        source.func_197030_a((ITextComponent)new StringTextComponent("Reporting message network usage over a period of " + time + " seconds: % is % of all messages"), false);
        DecimalFormat percent = new DecimalFormat("########.##");
        Style GREEN_BOLD = Style.field_240709_b_.func_240713_a_(Boolean.valueOf(false)).func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.GREEN));
        Style BLUE = Style.field_240709_b_.func_240713_a_(Boolean.valueOf(false)).func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.BLUE));
        Style YELLOW = Style.field_240709_b_.func_240713_a_(Boolean.valueOf(false)).func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.YELLOW));
        Style RED = Style.field_240709_b_.func_240713_a_(Boolean.valueOf(false)).func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.RED));
        int i = 0;
        for (i = startIndex; i < startIndex + 5 && i < dataList.size(); ++i) {
            PacketData data = (PacketData)dataList.get(i);
            source.func_197030_a((ITextComponent)new StringTextComponent(percent.format((double)data.bytes / (double)totalBytes * 100.0) + "% ").func_230530_a_(GREEN_BOLD).func_230529_a_((ITextComponent)new StringTextComponent(data.name + " ")).func_230529_a_((ITextComponent)new StringTextComponent("rate " + percent.format((double)data.bytes / 1000.0 / (double)time) + "kb/s ").func_230530_a_(BLUE)).func_230529_a_((ITextComponent)new StringTextComponent("packets:" + data.count + " ").func_230530_a_(YELLOW)).func_230529_a_((ITextComponent)new StringTextComponent("maxSize: " + percent.format((double)data.maxSize / 1000.0) + " kb").func_230530_a_(RED)), false);
        }
        if (i + 1 < dataList.size()) {
            source.func_197030_a((ITextComponent)new StringTextComponent("next ---->").func_230530_a_(Style.field_240709_b_.func_240713_a_(Boolean.valueOf(true)).func_240715_a_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/performant reportMessages %d", i)))), false);
        }
    }

    private static class PacketData {
        String name;
        int count;
        long bytes;
        long maxSize = 0L;

        public PacketData(String name) {
            this.name = name;
        }

        public void add(long addBytes) {
            ++this.count;
            this.bytes += addBytes;
            if (this.maxSize < addBytes) {
                this.maxSize = addBytes;
            }
        }

        public long getBytes() {
            return this.bytes;
        }
    }
}

