/*
 * Decompiled with CFR 0.152.
 */
package com.performant.coremod.world;

import com.performant.coremod.world.ChunkCache;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.CubeCoordinateIterator;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ICollisionReader;
import net.minecraft.world.IEntityReader;

public class Collisions {
    private static final double MOTION_MULT_LENGHT = 1.0E-7;

    public static boolean hasNoCollisions(Entity entity, Object world) {
        return Collisions.hasNoCollisions(entity, entity.func_174813_aQ(), world);
    }

    public static boolean hasNoCollisions(Entity entity, AxisAlignedBB axisAlignedBB, Object world) {
        return Collisions.hasNoCollisions(entity, axisAlignedBB, e -> true, world);
    }

    public static boolean hasNoCollisions(Entity entity, AxisAlignedBB axisAlignedBB, Predicate<Entity> entityPredicate, Object world) {
        int minX = MathHelper.func_76128_c((double)(axisAlignedBB.field_72340_a - 1.0E-7)) - 1;
        int maxX = MathHelper.func_76128_c((double)(axisAlignedBB.field_72336_d + 1.0E-7)) + 1;
        int minY = MathHelper.func_76128_c((double)(axisAlignedBB.field_72338_b - 1.0E-7)) - 1;
        int maxY = MathHelper.func_76128_c((double)(axisAlignedBB.field_72337_e + 1.0E-7)) + 1;
        int minZ = MathHelper.func_76128_c((double)(axisAlignedBB.field_72339_c - 1.0E-7)) - 1;
        int maxZ = MathHelper.func_76128_c((double)(axisAlignedBB.field_72334_f + 1.0E-7)) + 1;
        ISelectionContext iselectioncontext = entity == null ? ISelectionContext.func_216377_a() : ISelectionContext.func_216374_a((Entity)entity);
        CubeCoordinateIterator cubecoordinateiterator = new CubeCoordinateIterator(minX, minY, minZ, maxX, maxY, maxZ);
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        VoxelShape entityVoxelShape = VoxelShapes.func_197881_a((AxisAlignedBB)axisAlignedBB);
        ArrayList<VoxelShape> allCollisionShapes = new ArrayList<VoxelShape>();
        if (world == null) {
            world = entity.field_70170_p;
        }
        if (world instanceof IEntityReader) {
            allCollisionShapes = new ArrayList<VoxelShape>(Collisions.getEntityCollisionBoxes(entity, axisAlignedBB, entityPredicate, (IEntityReader)world));
        }
        Collisions.addShapesForBlockCollision(allCollisionShapes, cubecoordinateiterator, blockpos$mutable, world, iselectioncontext, entityVoxelShape, axisAlignedBB);
        for (VoxelShape shape : allCollisionShapes) {
            if (shape.func_197766_b()) continue;
            return false;
        }
        return true;
    }

    public static List<VoxelShape> getEntityCollisionBoxes(@Nullable Entity entity, AxisAlignedBB boundingBox, Predicate<Entity> entityPredicate, IEntityReader world) {
        if (boundingBox.func_72320_b() < 1.0E-7) {
            return new ArrayList<VoxelShape>();
        }
        ArrayList<VoxelShape> result = new ArrayList<VoxelShape>();
        AxisAlignedBB grownBB = boundingBox.func_186662_g(1.0E-7);
        List<Entity> entities = world instanceof ChunkCache ? ((ChunkCache)world).func_175674_a(entity, grownBB, null) : world.func_175674_a(entity, grownBB, null);
        for (Entity currentEntity : entities) {
            if (currentEntity == null || currentEntity == entity || currentEntity.func_175149_v() || (entity != null ? !entity.func_241849_j(currentEntity) : !currentEntity.func_241845_aY())) continue;
            AxisAlignedBB currentCBB = currentEntity.func_174813_aQ();
            if (!grownBB.func_72326_a(currentCBB) || entityPredicate != null && !entityPredicate.test(currentEntity)) continue;
            result.add(VoxelShapes.func_197881_a((AxisAlignedBB)currentCBB));
        }
        return result;
    }

    private static void addShapesForBlockCollision(List<VoxelShape> shapeCollisionList, CubeCoordinateIterator cubeToCheck, BlockPos.Mutable mutablePos, Object world, ISelectionContext iselectioncontext, VoxelShape voxelShapeToCheckForCollisions, AxisAlignedBB originalShape) {
        IBlockReader iblockreader = null;
        int blockReaderX = 0;
        int blockReaderZ = 0;
        while (cubeToCheck.func_218301_a()) {
            int coordX = cubeToCheck.func_218304_b();
            int coordY = cubeToCheck.func_218302_c();
            int coordZ = cubeToCheck.func_218303_d();
            int numBoundariesTouched = cubeToCheck.func_223473_e();
            if (numBoundariesTouched == 3) continue;
            int chunkX = coordX >> 4;
            int chunkZ = coordZ >> 4;
            if (iblockreader == null || chunkX != blockReaderX || chunkZ != blockReaderZ) {
                iblockreader = ((ICollisionReader)world).func_225522_c_(chunkX, chunkZ);
                blockReaderX = chunkX;
                blockReaderZ = chunkZ;
            }
            if (iblockreader == null) continue;
            mutablePos.func_181079_c(coordX, coordY, coordZ);
            BlockState blockstate = iblockreader.func_180495_p((BlockPos)mutablePos);
            if (numBoundariesTouched == 1 && !blockstate.func_215704_f() || numBoundariesTouched == 2 && !blockstate.func_203425_a(Blocks.field_196603_bb)) continue;
            VoxelShape collisionShape = blockstate.func_215685_b(iblockreader, (BlockPos)mutablePos, iselectioncontext);
            if (collisionShape == VoxelShapes.func_197868_b()) {
                if (!originalShape.func_186668_a((double)coordX, (double)coordY, (double)coordZ, (double)coordX + 1.0, (double)coordY + 1.0, (double)coordZ + 1.0)) continue;
                shapeCollisionList.add(collisionShape.func_197751_a((double)coordX, (double)coordY, (double)coordZ));
                continue;
            }
            VoxelShape worldCollisionShape = collisionShape.func_197751_a((double)coordX, (double)coordY, (double)coordZ);
            if (!VoxelShapes.func_197879_c((VoxelShape)worldCollisionShape, (VoxelShape)voxelShapeToCheckForCollisions, (IBooleanFunction)IBooleanFunction.field_223238_i_)) continue;
            shapeCollisionList.add(worldCollisionShape);
        }
    }
}

