/*
 * Decompiled with CFR 0.152.
 */
package io.socol.betterthirdperson;

import io.socol.betterthirdperson.AngleUtils;
import io.socol.betterthirdperson.TickPhase;
import io.socol.betterthirdperson.adapter.IClientAdapter;
import io.socol.betterthirdperson.adapter.IMovementInputAdapter;
import io.socol.betterthirdperson.adapter.IPlayerAdapter;
import io.socol.betterthirdperson.adapter.IPlayerPosition;

public class CustomCamera {
    private static final float STATIC_ANGULAR_YAW = 45.0f;
    private float angularYaw;
    private float cameraYaw;
    private float playerYaw;
    private IPlayerPosition lastTickPlayerPos;
    private float prevInputYaw = 0.0f;
    private float inputYaw = 0.0f;
    private boolean hasMovementInputs = false;

    public CustomCamera(IPlayerAdapter player) {
        this.playerYaw = player.getRotationYaw();
        this.cameraYaw = player.getRotationYaw();
        this.angularYaw = 0.0f;
        this.lastTickPlayerPos = player.getPosition();
    }

    public void handleInputs(IMovementInputAdapter input, IClientAdapter client) {
        this.prevInputYaw = this.inputYaw;
        boolean leftKeyDown = input.isLeftKeyDown();
        boolean rightKeyDown = input.isRightKeyDown();
        boolean forwardKeyDown = input.isForwardKeyDown();
        boolean backKeyDown = input.isBackKeyDown();
        this.hasMovementInputs = client.isMousePressed();
        if (leftKeyDown || rightKeyDown || forwardKeyDown || backKeyDown) {
            if (forwardKeyDown != backKeyDown) {
                float f = this.inputYaw = forwardKeyDown ? 0.0f : -180.0f;
                if (leftKeyDown != rightKeyDown) {
                    this.inputYaw += (leftKeyDown ? -45.0f : 45.0f) * (float)(forwardKeyDown ? 1 : -1);
                }
            } else if (leftKeyDown != rightKeyDown) {
                this.inputYaw = leftKeyDown ? -90.0f : 90.0f;
            }
            float moveImpulse = Math.max(Math.abs(input.getMoveForward()), Math.abs(input.getMoveStrafe()));
            input.setMoveForward(moveImpulse);
            input.setMoveStrafe(0.0f);
            input.setLeftKeyDown(false);
            input.setRightKeyDown(false);
            input.setBackKeyDown(false);
            input.setForwardKeyDown(true);
            this.hasMovementInputs = true;
        } else {
            this.prevInputYaw = 0.0f;
            this.inputYaw = 0.0f;
        }
    }

    public void setup(IPlayerAdapter player, float partialTicks) {
        if (this.playerYaw != player.getRotationYaw()) {
            float yawDelta = player.getRotationYaw() - this.playerYaw;
            if (Math.signum(yawDelta) != Math.signum(this.angularYaw)) {
                this.angularYaw = 0.0f;
            }
            this.angularYaw += yawDelta;
            this.cameraYaw += yawDelta;
            if (Math.abs(this.angularYaw) <= 45.0f) {
                this.playerYaw = (float)((double)this.playerYaw + (double)yawDelta * (1.0 - this.easeInExpo(Math.abs(this.angularYaw) / 45.0f)));
            }
            this.cameraYaw = AngleUtils.wrapAngle(this.playerYaw, this.cameraYaw);
        }
        if (this.hasMovementInputs) {
            this.playerYaw = this.cameraYaw + AngleUtils.smoothAngle(partialTicks, this.prevInputYaw, this.inputYaw);
        }
        if (this.playerYaw != player.getRotationYaw()) {
            player.setRotationYaw(this.playerYaw);
        }
    }

    public float getYawDelta() {
        return this.cameraYaw - this.playerYaw;
    }

    public void checkPosition(TickPhase phase, IPlayerAdapter player) {
        IPlayerPosition currentPos = player.getPosition();
        if (phase == TickPhase.START) {
            if (!this.lastTickPlayerPos.equals(currentPos)) {
                this.resetToPlayerView(player);
            }
        } else {
            this.lastTickPlayerPos = currentPos;
        }
    }

    void aimPlayer(IPlayerAdapter player, IClientAdapter client) {
        if (!this.hasMovementInputs) {
            player.setRotationYawSafe(this.cameraYaw);
            client.updateHitResult();
            this.resetToPlayerView(player);
        }
    }

    private void resetToPlayerView(IPlayerAdapter player) {
        this.playerYaw = player.getRotationYaw();
        this.cameraYaw = player.getRotationYaw();
        this.angularYaw = 0.0f;
    }

    private double easeInExpo(double x) {
        return x == 0.0 ? 0.0 : Math.pow(2.0, 10.0 * x - 10.0);
    }
}

