/*
 * Decompiled with CFR 0.152.
 */
package io.socol.betterthirdperson;

import io.socol.betterthirdperson.CustomCameraManager;
import io.socol.betterthirdperson.TickPhase;
import io.socol.betterthirdperson.impl.MovementInputAdapter;
import io.socol.betterthirdperson.impl.PlayerAdapter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class CustomCameraListener {
    private final CustomCameraManager manager;

    public CustomCameraListener(CustomCameraManager manager) {
        this.manager = manager;
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player instanceof ClientPlayerEntity) {
            PlayerAdapter player = new PlayerAdapter(event.player);
            TickPhase phase = event.phase == TickEvent.Phase.START ? TickPhase.START : TickPhase.END;
            this.manager.onPlayerTick(player, phase);
        }
    }

    @SubscribeEvent
    public void onInputs(InputUpdateEvent event) {
        PlayerAdapter player = new PlayerAdapter((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
        MovementInputAdapter inputs = new MovementInputAdapter(event.getMovementInput());
        this.manager.onInputs(player, inputs);
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (event.phase != TickEvent.Phase.START || player == null) {
            return;
        }
        PlayerAdapter playerAdapter = new PlayerAdapter((PlayerEntity)player);
        this.manager.onRenderTickStart(playerAdapter, event.renderTickTime);
    }
}

