/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph;

import com.mojang.brigadier.CommandDispatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.command.CommandSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.polymorph.client.ClientEventHandler;
import top.theillusivec4.polymorph.common.CommonEventHandler;
import top.theillusivec4.polymorph.common.capability.SelectorCapability;
import top.theillusivec4.polymorph.common.integrations.CompatibilityModule;
import top.theillusivec4.polymorph.common.integrations.craftingcraft.CraftingCraftModule;
import top.theillusivec4.polymorph.common.integrations.ironfurnaces.IronFurnacesModule;
import top.theillusivec4.polymorph.common.integrations.prettypipes.PrettyPipesModule;
import top.theillusivec4.polymorph.common.integrations.refinedstorage.RefinedStorageModule;
import top.theillusivec4.polymorph.common.network.NetworkManager;
import top.theillusivec4.polymorph.server.PolymorphCommand;

@Mod(value="polymorph")
public class Polymorph {
    public static final String MODID = "polymorph";
    public static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, Supplier<CompatibilityModule>> INTEGRATIONS = new HashMap<String, Supplier<CompatibilityModule>>();
    private static final List<CompatibilityModule> ACTIVE_INTEGRATIONS = new ArrayList<CompatibilityModule>();
    public static boolean isFastFurnaceLoaded;

    public Polymorph() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::setup);
        eventBus.addListener(this::clientSetup);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommand);
        ModList modList = ModList.get();
        isFastFurnaceLoaded = modList.isLoaded("fastfurnace");
        INTEGRATIONS.forEach((modid, supplier) -> {
            if (modList.isLoaded(modid)) {
                ACTIVE_INTEGRATIONS.add((CompatibilityModule)supplier.get());
            }
        });
    }

    private void setup(FMLCommonSetupEvent evt) {
        NetworkManager.register();
        SelectorCapability.register();
        MinecraftForge.EVENT_BUS.register((Object)new CommonEventHandler());
        ACTIVE_INTEGRATIONS.forEach(CompatibilityModule::setup);
    }

    private void clientSetup(FMLClientSetupEvent evt) {
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
        ACTIVE_INTEGRATIONS.forEach(CompatibilityModule::clientSetup);
    }

    private void registerCommand(RegisterCommandsEvent evt) {
        PolymorphCommand.register((CommandDispatcher<CommandSource>)evt.getDispatcher());
    }

    static {
        INTEGRATIONS.put("craftingcraft", CraftingCraftModule::new);
        INTEGRATIONS.put("refinedstorage", RefinedStorageModule::new);
        INTEGRATIONS.put("prettypipes", PrettyPipesModule::new);
        INTEGRATIONS.put("ironfurnaces", IronFurnacesModule::new);
        isFastFurnaceLoaded = false;
    }
}

