/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.server;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.fml.loading.FMLPaths;
import top.theillusivec4.polymorph.Polymorph;

public class PolymorphCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        int opPermissionLevel = 2;
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"polymorph").requires(player -> player.func_197034_c(2));
        command.then(Commands.func_197057_a((String)"conflicts").executes(context -> PolymorphCommand.findConflicts((CommandSource)context.getSource())));
        dispatcher.register(command);
    }

    private static int findConflicts(CommandSource source) {
        ServerWorld world = source.func_197023_e();
        ArrayList lines = new ArrayList();
        HashSet processed = new HashSet();
        Collection recipes = world.func_199532_z().func_199510_b();
        RecipeItemHelper recipeItemHelper = new RecipeItemHelper();
        IntArrayList first = new IntArrayList();
        IntArrayList second = new IntArrayList();
        AtomicInteger conflictCount = new AtomicInteger();
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.polymorph.conflicts.starting"), true);
        recipes.forEach(recipe -> {
            String id = recipe.func_199560_c().toString();
            ArrayList conflicts = new ArrayList();
            if (!processed.contains(id)) {
                processed.add(id);
                recipes.forEach(otherRecipe -> {
                    String otherId = otherRecipe.func_199560_c().toString();
                    if (!processed.contains(otherId) && !ItemStack.func_77989_b((ItemStack)otherRecipe.func_77571_b(), (ItemStack)recipe.func_77571_b()) && recipe.func_222127_g() == IRecipeType.field_222149_a && recipe.func_222127_g() == otherRecipe.func_222127_g() && !recipe.func_192399_d() && recipe.func_192399_d() == otherRecipe.func_192399_d() && PolymorphCommand.areSameShape(recipe, otherRecipe)) {
                        recipeItemHelper.func_194119_a();
                        recipe.func_192400_c().forEach(ingredient -> {
                            for (ItemStack matchingStack : ingredient.func_193365_a()) {
                                recipeItemHelper.func_194112_a(matchingStack);
                            }
                        });
                        second.clear();
                        if (recipeItemHelper.func_194116_a(recipe, (IntList)second)) {
                            recipeItemHelper.func_194119_a();
                            otherRecipe.func_192400_c().forEach(ingredient -> {
                                for (ItemStack matchingStack : ingredient.func_193365_a()) {
                                    recipeItemHelper.func_194112_a(matchingStack);
                                }
                            });
                            first.clear();
                            if (recipeItemHelper.func_194116_a(otherRecipe, (IntList)first) && first.equals(second)) {
                                processed.add(otherId);
                                conflicts.add(otherId);
                            }
                        }
                    }
                });
            }
            if (!conflicts.isEmpty()) {
                conflictCount.addAndGet(conflicts.size());
                lines.add("Conflicts with " + id + ":");
                lines.addAll(conflicts);
                lines.add("");
            }
        });
        if (!lines.isEmpty()) {
            try {
                Files.write(Paths.get(FMLPaths.GAMEDIR.get() + "/logs/conflicts.log", new String[0]), lines, StandardCharsets.UTF_8, new OpenOption[0]);
            }
            catch (IOException e) {
                Polymorph.LOGGER.error("Whoops! Something went wrong writing down your conflicts :(");
            }
        }
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.polymorph.conflicts.success", new Object[]{conflictCount.get()}), true);
        return 1;
    }

    private static boolean areSameShape(IRecipe<?> recipe1, IRecipe<?> recipe2) {
        if (recipe1 instanceof IShapedRecipe && recipe2 instanceof IShapedRecipe) {
            IShapedRecipe shapedRecipe1 = (IShapedRecipe)recipe1;
            IShapedRecipe shapedRecipe2 = (IShapedRecipe)recipe2;
            return shapedRecipe1.getRecipeHeight() == shapedRecipe2.getRecipeHeight() && shapedRecipe1.getRecipeWidth() == shapedRecipe2.getRecipeWidth();
        }
        return true;
    }
}

