/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Objects;
import net.blay09.mods.waystones.block.WaystoneBlock;
import net.blay09.mods.waystones.client.render.ModelWaystone;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.tileentity.WaystoneTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;

public class WaystoneRenderer
extends TileEntityRenderer<WaystoneTileEntity> {
    private static final ModelWaystone model = new ModelWaystone();
    private static final RenderMaterial MATERIAL = new RenderMaterial(Atlases.field_228746_e_, new ResourceLocation("waystones", "entity/waystone_active"));

    public WaystoneRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(WaystoneTileEntity tileEntity, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        BlockState state = tileEntity.func_195044_w();
        if (state.func_177229_b((Property)WaystoneBlock.HALF) != DoubleBlockHalf.LOWER) {
            return;
        }
        float angle = ((Direction)state.func_177229_b((Property)WaystoneBlock.FACING)).func_185119_l();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.0, 0.5);
        matrixStack.func_227863_a_(new Quaternion(0.0f, angle, 0.0f, true));
        matrixStack.func_227863_a_(new Quaternion(-180.0f, 0.0f, 0.0f, true));
        matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        boolean isActivated = PlayerWaystoneManager.isWaystoneActivated((PlayerEntity)Objects.requireNonNull(player), tileEntity.getWaystone());
        if (isActivated) {
            matrixStack.func_227862_a_(1.05f, 1.05f, 1.05f);
            IVertexBuilder vertexBuilder = MATERIAL.func_229311_a_(buffer, RenderType::func_228638_b_);
            int light = (Boolean)WaystonesConfig.CLIENT.disableTextGlow.get() != false ? combinedLightIn : 0xF000F0;
            int overlay = (Boolean)WaystonesConfig.CLIENT.disableTextGlow.get() != false ? combinedOverlayIn : OverlayTexture.field_229196_a_;
            model.func_225598_a_(matrixStack, vertexBuilder, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        matrixStack.func_227865_b_();
    }
}

