/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import net.blay09.mods.waystones.config.InventoryButtonMode;
import net.blay09.mods.waystones.config.WaystoneClientConfig;
import net.blay09.mods.waystones.config.WaystoneCommonConfig;
import net.blay09.mods.waystones.config.WaystoneServerConfig;
import net.blay09.mods.waystones.network.NetworkHandler;
import net.blay09.mods.waystones.network.message.SyncConfigMessage;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="waystones", bus=Mod.EventBusSubscriber.Bus.MOD)
public class WaystonesConfig {
    private static final Logger logger = LogManager.getLogger();
    public static final ForgeConfigSpec commonSpec;
    public static final WaystoneCommonConfig COMMON;
    public static final ForgeConfigSpec serverSpec;
    public static final WaystoneServerConfig SERVER;
    public static final ForgeConfigSpec clientSpec;
    public static final WaystoneClientConfig CLIENT;

    public static Path getServerConfigPath() {
        return FMLPaths.CONFIGDIR.get().resolve("waystones-server.toml").toAbsolutePath();
    }

    public static InventoryButtonMode getInventoryButtonMode() {
        return new InventoryButtonMode((String)WaystonesConfig.SERVER.inventoryButton.get());
    }

    @SubscribeEvent
    public static void onConfigReloaded(ModConfig.Reloading event) {
        PlayerList playerList;
        MinecraftServer currentServer;
        if (event.getConfig().getType() == ModConfig.Type.SERVER && (currentServer = ServerLifecycleHooks.getCurrentServer()) != null && (playerList = currentServer.func_184103_al()) != null) {
            for (ServerPlayerEntity player : playerList.func_181057_v()) {
                WaystonesConfig.syncServerConfigs((PlayerEntity)player);
            }
        }
    }

    public static void syncServerConfigs(PlayerEntity player) {
        try {
            byte[] configData = Files.readAllBytes(WaystonesConfig.getServerConfigPath());
            NetworkHandler.sendTo(new SyncConfigMessage(configData), player);
        }
        catch (IOException e) {
            logger.error("Failed to sync Waystones config", (Throwable)e);
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(WaystoneCommonConfig::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (WaystoneCommonConfig)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(WaystoneServerConfig::new);
        serverSpec = (ForgeConfigSpec)specPair.getRight();
        SERVER = (WaystoneServerConfig)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(WaystoneClientConfig::new);
        clientSpec = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (WaystoneClientConfig)specPair.getLeft();
    }
}

