/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.IIngredientWithSizeSerializer;
import blusunrize.immersiveengineering.api.utils.SetRestrictedField;
import com.google.gson.JsonElement;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraftforge.items.ItemHandlerHelper;

public class IngredientWithSize
implements Predicate<ItemStack> {
    public static final SetRestrictedField<IIngredientWithSizeSerializer> SERIALIZER = SetRestrictedField.common();
    protected final Ingredient basePredicate;
    protected final int count;

    public IngredientWithSize(Ingredient basePredicate, int count) {
        this.basePredicate = basePredicate;
        this.count = count;
    }

    public IngredientWithSize(Ingredient basePredicate) {
        this(basePredicate, 1);
    }

    public IngredientWithSize(ITag<Item> basePredicate, int count) {
        this(Ingredient.func_199805_a(basePredicate), count);
    }

    public IngredientWithSize(ITag<Item> basePredicate) {
        this(basePredicate, 1);
    }

    public static IngredientWithSize deserialize(JsonElement input) {
        return SERIALIZER.getValue().parse(input);
    }

    public static IngredientWithSize read(PacketBuffer input) {
        return SERIALIZER.getValue().parse(input);
    }

    @Override
    public boolean test(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        return this.basePredicate.test(itemStack) && itemStack.func_190916_E() >= this.count;
    }

    @Nonnull
    public ItemStack[] getMatchingStacks() {
        ItemStack[] baseStacks = this.basePredicate.func_193365_a();
        ItemStack[] ret = new ItemStack[baseStacks.length];
        for (int i = 0; i < baseStacks.length; ++i) {
            ret[i] = ItemHandlerHelper.copyStackWithSize((ItemStack)baseStacks[i], (int)this.count);
        }
        return ret;
    }

    @Nonnull
    public JsonElement serialize() {
        return SERIALIZER.getValue().write(this);
    }

    public boolean hasNoMatchingItems() {
        return this.basePredicate.func_203189_d();
    }

    public int getCount() {
        return this.count;
    }

    public Ingredient getBaseIngredient() {
        return this.basePredicate;
    }

    public IngredientWithSize withSize(int size) {
        return new IngredientWithSize(this.basePredicate, size);
    }

    public static IngredientWithSize of(ItemStack stack) {
        return new IngredientWithSize(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack}), stack.func_190916_E());
    }

    public ItemStack getRandomizedExampleStack(int rand) {
        ItemStack[] all = this.getMatchingStacks();
        return all[rand / 20 % all.length];
    }

    public boolean testIgnoringSize(ItemStack itemstack) {
        return this.basePredicate.test(itemstack);
    }

    public void write(PacketBuffer out) {
        SERIALIZER.getValue().write(out, this);
    }
}

