/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.utils.ItemUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;

public class SawmillRecipe
extends MultiblockRecipe {
    public static IRecipeType<SawmillRecipe> TYPE;
    public static RegistryObject<IERecipeSerializer<SawmillRecipe>> SERIALIZER;
    public final Ingredient input;
    public final ItemStack stripped;
    public final NonNullList<ItemStack> secondaryStripping = NonNullList.func_191196_a();
    public final ItemStack output;
    public final NonNullList<ItemStack> secondaryOutputs = NonNullList.func_191196_a();
    public static Map<ResourceLocation, SawmillRecipe> recipeList;

    public SawmillRecipe(ResourceLocation id, ItemStack output, ItemStack stripped, Ingredient input, int energy) {
        super(output, TYPE, id);
        this.output = output;
        this.stripped = stripped;
        this.input = input;
        this.setTimeAndEnergy(80, energy);
        this.setInputList(Lists.newArrayList((Object[])new Ingredient[]{this.input}));
        this.outputList = NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{this.output});
    }

    @Override
    protected IERecipeSerializer<SawmillRecipe> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    @Override
    public NonNullList<ItemStack> getActualItemOutputs(TileEntity tile) {
        NonNullList list = NonNullList.func_191196_a();
        list.add((Object)this.stripped);
        for (ItemStack output : this.secondaryStripping) {
            if (output.func_190926_b()) continue;
            list.add((Object)output);
        }
        list.add((Object)this.output);
        for (ItemStack output : this.secondaryOutputs) {
            if (output.func_190926_b()) continue;
            list.add((Object)output);
        }
        return list;
    }

    public SawmillRecipe addToSecondaryStripping(ItemStack output) {
        Preconditions.checkNotNull((Object)output);
        this.secondaryStripping.add((Object)output);
        return this;
    }

    public SawmillRecipe addToSecondaryOutput(ItemStack output) {
        Preconditions.checkNotNull((Object)output);
        this.secondaryOutputs.add((Object)output);
        return this;
    }

    public static SawmillRecipe findRecipe(ItemStack input) {
        if (!input.func_190926_b()) {
            for (SawmillRecipe recipe : recipeList.values()) {
                if (!ItemUtils.stackMatchesObject(input, recipe.input)) continue;
                return recipe;
            }
        }
        return null;
    }

    @Override
    public int getMultipleProcessTicks() {
        return 0;
    }

    static {
        recipeList = Collections.emptyMap();
    }
}

