/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.utils.shapes;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;

public class CachedVoxelShapes<Key> {
    private final Map<Key, VoxelShape> calculatedShapes = new ConcurrentHashMap<Key, VoxelShape>();
    private final Function<Key, List<AxisAlignedBB>> creator;

    public CachedVoxelShapes(Function<Key, List<AxisAlignedBB>> creator) {
        this.creator = creator;
    }

    public VoxelShape get(Key k) {
        return this.calculatedShapes.computeIfAbsent(k, this::calculateShape);
    }

    private VoxelShape calculateShape(Key k) {
        List<AxisAlignedBB> subshapes = this.creator.apply(k);
        VoxelShape ret = VoxelShapes.func_197880_a();
        if (subshapes != null) {
            for (AxisAlignedBB aabb : subshapes) {
                ret = VoxelShapes.func_197882_b((VoxelShape)ret, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)aabb), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            }
        }
        return ret.func_197753_c();
    }
}

