/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.utils.SafeChunkUtils;
import blusunrize.immersiveengineering.api.utils.SetRestrictedField;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.IWireSyncManager;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.NetHandlerCapability;
import blusunrize.immersiveengineering.api.wires.NetworkSanitizer;
import blusunrize.immersiveengineering.api.wires.WireCollisionData;
import blusunrize.immersiveengineering.api.wires.WireLogger;
import blusunrize.immersiveengineering.api.wires.localhandlers.ILocalHandlerProvider;
import blusunrize.immersiveengineering.api.wires.localhandlers.IWorldTickable;
import blusunrize.immersiveengineering.api.wires.proxy.IICProxyProvider;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multiset;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="immersiveengineering")
public class GlobalWireNetwork
implements IWorldTickable {
    public static final SetRestrictedField<BooleanSupplier> SANITIZE_CONNECTIONS = SetRestrictedField.common();
    public static final SetRestrictedField<BooleanSupplier> VALIDATE_CONNECTIONS = SetRestrictedField.common();
    private static World lastServerWorld = null;
    private static GlobalWireNetwork lastServerNet = null;
    private static World lastClientWorld;
    private static GlobalWireNetwork lastClientNet;
    private final Map<ConnectionPoint, LocalWireNetwork> localNets = new HashMap<ConnectionPoint, LocalWireNetwork>();
    private final WireCollisionData collisionData;
    private final IICProxyProvider proxyProvider;
    private final IWireSyncManager syncManager;
    private List<Pair<IImmersiveConnectable, World>> queuedLoads = new ArrayList<Pair<IImmersiveConnectable, World>>();
    private boolean processingLoadQueue = false;
    private boolean validateNextTick = false;
    boolean validating = false;

    @Nonnull
    public static GlobalWireNetwork getNetwork(World w) {
        if (!w.field_72995_K && w == lastServerWorld) {
            return lastServerNet;
        }
        if (w.field_72995_K && w == lastClientWorld) {
            return lastClientNet;
        }
        LazyOptional netOptional = w.getCapability(NetHandlerCapability.NET_CAPABILITY);
        if (!netOptional.isPresent()) {
            throw new RuntimeException("No net handler found for dimension " + w.func_234923_W_().func_240901_a_() + ", remote: " + w.field_72995_K);
        }
        GlobalWireNetwork ret = (GlobalWireNetwork)netOptional.orElseThrow(RuntimeException::new);
        if (!w.field_72995_K) {
            lastServerWorld = w;
            lastServerNet = ret;
        } else {
            lastClientWorld = w;
            lastClientNet = ret;
        }
        return ret;
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload ev) {
        if (ev.getWorld() == lastServerWorld) {
            lastServerNet = null;
            lastServerWorld = null;
        }
    }

    public GlobalWireNetwork(boolean remote, IICProxyProvider proxyProvider, IWireSyncManager syncManager) {
        this.proxyProvider = proxyProvider;
        this.collisionData = new WireCollisionData(this, remote);
        this.syncManager = syncManager;
    }

    public void addConnection(Connection conn) {
        LocalWireNetwork joined;
        this.processQueuedLoads();
        ConnectionPoint posA = conn.getEndA();
        ConnectionPoint posB = conn.getEndB();
        LocalWireNetwork netA = this.getLocalNet(posA);
        LocalWireNetwork netB = this.getLocalNet(posB);
        if (netA != netB) {
            joined = netA.merge(netB, () -> new LocalWireNetwork(this));
            for (ConnectionPoint p : joined.getConnectionPoints()) {
                this.putLocalNet(p, joined);
            }
        } else {
            joined = netA;
        }
        joined.addConnection(conn, this);
        this.syncManager.onConnectionAdded(conn);
        IImmersiveConnectable connA = joined.getConnector(posA);
        IImmersiveConnectable connB = joined.getConnector(posB);
        if (connA != null && connB != null && !connA.isProxy() && !connB.isProxy()) {
            this.collisionData.addConnection(conn);
        }
        this.validateNextTick = true;
    }

    public void removeAllConnectionsAt(IImmersiveConnectable iic, Consumer<Connection> handler) {
        for (ConnectionPoint cp : iic.getConnectionPoints()) {
            this.removeAllConnectionsAt(cp, handler);
        }
    }

    public void removeAllConnectionsAt(ConnectionPoint pos, Consumer<Connection> handler) {
        this.processQueuedLoads();
        LocalWireNetwork net = this.getLocalNet(pos);
        ArrayList<Connection> conns = new ArrayList<Connection>(net.getConnections(pos));
        for (Connection conn : conns) {
            handler.accept(conn);
            this.removeConnection(conn);
        }
        this.validateNextTick = true;
    }

    public void removeConnection(Connection c) {
        this.processQueuedLoads();
        this.collisionData.removeConnection(c);
        LocalWireNetwork oldNet = this.getNullableLocalNet(c.getEndA());
        if (oldNet == null) {
            Preconditions.checkState((this.getNullableLocalNet(c.getEndB()) == null ? 1 : 0) != 0, (String)"Found net at %s but not at %s while removing connection %s", (Object)c.getEndB(), (Object)c.getEndA(), (Object)c);
            return;
        }
        Preconditions.checkNotNull((Object)oldNet.getConnector(c.getEndB()), (String)"Removing connection %s from net %s, but does not have connector for %s", (Object)c, (Object)oldNet, (Object)c.getEndB());
        oldNet.removeConnection(c);
        this.splitNet(oldNet);
        this.syncManager.onConnectionRemoved(c);
    }

    public void removeAndDropConnection(Connection c, BlockPos dropAt, World world) {
        this.removeConnection(c);
        double dx = (double)dropAt.func_177958_n() + 0.5;
        double dy = (double)dropAt.func_177956_o() + 0.5;
        double dz = (double)dropAt.func_177952_p() + 0.5;
        if (world.func_82736_K().func_223586_b(GameRules.field_223603_f)) {
            world.func_217376_c((Entity)new ItemEntity(world, dx, dy, dz, c.type.getWireCoil(c)));
        }
    }

    private void splitNet(LocalWireNetwork oldNet) {
        Collection<LocalWireNetwork> newNets = oldNet.split(this);
        for (LocalWireNetwork net : newNets) {
            for (ConnectionPoint p : net.getConnectionPoints()) {
                this.putLocalNet(p, net);
            }
        }
    }

    public void readFromNBT(CompoundNBT nbt) {
        this.localNets.values().forEach(LocalWireNetwork::setInvalid);
        this.localNets.clear();
        ListNBT locals = nbt.func_150295_c("locals", 10);
        for (INBT b : locals) {
            CompoundNBT subnet = (CompoundNBT)b;
            LocalWireNetwork localNet = new LocalWireNetwork(subnet, this);
            WireLogger.logger.info("Loading net {}", (Object)localNet);
            for (ConnectionPoint p : localNet.getConnectionPoints()) {
                this.putLocalNet(p, localNet);
            }
        }
        this.queuedLoads.clear();
    }

    public CompoundNBT writeToNBT() {
        CompoundNBT ret = new CompoundNBT();
        ListNBT locals = new ListNBT();
        Set savedNets = Collections.newSetFromMap(new IdentityHashMap());
        for (LocalWireNetwork local : this.localNets.values()) {
            if (!savedNets.add(local)) continue;
            locals.add((Object)local.writeToNBT());
        }
        ret.func_218657_a("locals", (INBT)locals);
        return ret;
    }

    public LocalWireNetwork getLocalNet(BlockPos pos) {
        return this.getLocalNet(new ConnectionPoint(pos, 0));
    }

    public LocalWireNetwork getLocalNet(ConnectionPoint pos) {
        this.processQueuedLoads();
        LocalWireNetwork ret = this.localNets.computeIfAbsent(pos, p -> {
            LocalWireNetwork newNet = new LocalWireNetwork(this);
            IImmersiveConnectable proxy = this.proxyProvider.create(pos.getPosition(), (Collection<Connection>)ImmutableList.of(), (Collection<ConnectionPoint>)ImmutableList.of());
            newNet.addConnector(pos, proxy, this);
            return newNet;
        });
        Preconditions.checkState((boolean)ret.isValid(pos), (String)"%s is not a valid net", (Object)ret);
        return ret;
    }

    public LocalWireNetwork getNullableLocalNet(BlockPos pos) {
        return this.getNullableLocalNet(new ConnectionPoint(pos, 0));
    }

    public LocalWireNetwork getNullableLocalNet(ConnectionPoint pos) {
        this.processQueuedLoads();
        LocalWireNetwork ret = this.localNets.get(pos);
        if (ret != null) {
            Preconditions.checkState((boolean)ret.isValid(pos), (String)"%s is not valid for position %s", (Object)ret, (Object)pos);
        }
        return ret;
    }

    public void removeConnector(IImmersiveConnectable iic) {
        this.processQueuedLoads();
        WireLogger.logger.info("Removing connector {} at {}", (Object)iic, (Object)iic.getPosition());
        ObjectArraySet netsToRemoveFrom = new ObjectArraySet();
        BlockPos iicPos = iic.getPosition();
        for (ConnectionPoint c : iic.getConnectionPoints()) {
            LocalWireNetwork local = this.getNullableLocalNet(c);
            if (local == null) continue;
            this.putLocalNet(c, null);
            netsToRemoveFrom.add(local);
        }
        for (LocalWireNetwork net : netsToRemoveFrom) {
            net.removeConnector(iicPos);
            this.splitNet(net);
        }
        this.validateNextTick = true;
    }

    @VisibleForTesting
    public void onConnectorLoad(IImmersiveConnectable iic, boolean remote) {
        boolean isNew = false;
        HashSet<LocalWireNetwork> loadedInNets = new HashSet<LocalWireNetwork>();
        for (ConnectionPoint connectionPoint : iic.getConnectionPoints()) {
            LocalWireNetwork local;
            if (this.getNullableLocalNet(connectionPoint) == null) {
                isNew = true;
            }
            if (!loadedInNets.add(local = this.getLocalNet(connectionPoint))) continue;
            local.loadConnector(connectionPoint.getPosition(), iic, false, this);
        }
        if (isNew && !remote) {
            for (Connection connection : iic.getInternalConnections()) {
                Preconditions.checkArgument((boolean)connection.isInternal(), (Object)("Internal connection for " + iic + "was not marked as internal!"));
                this.addConnection(connection);
            }
        }
    }

    public void onConnectorLoad(IImmersiveConnectable iic, World world) {
        this.queuedLoads.add((Pair<IImmersiveConnectable, World>)Pair.of((Object)iic, (Object)world));
    }

    private void processQueuedLoads() {
        if (this.queuedLoads.isEmpty() || this.processingLoadQueue) {
            return;
        }
        this.processingLoadQueue = true;
        ArrayList<Pair<IImmersiveConnectable, World>> failedLoads = new ArrayList<Pair<IImmersiveConnectable, World>>();
        for (Pair<IImmersiveConnectable, World> load : this.queuedLoads) {
            if (SafeChunkUtils.isChunkSafe((IWorld)load.getSecond(), ((IImmersiveConnectable)load.getFirst()).getPosition())) {
                IImmersiveConnectable iic = (IImmersiveConnectable)load.getFirst();
                World world = (World)load.getSecond();
                WireLogger.logger.info("Loading connector {} at {}", (Object)iic, (Object)iic.getPosition());
                if (this.validating) {
                    WireLogger.logger.error("Adding a connector during validation!");
                }
                this.onConnectorLoad(iic, world.field_72995_K);
                ApiUtils.addFutureServerTask(world, () -> this.initializeConnectionsOn(iic, world), true);
                this.validateNextTick = true;
                if (!world.field_72995_K) continue;
                this.updateModelData(iic, world);
                continue;
            }
            failedLoads.add(load);
        }
        this.queuedLoads = failedLoads;
        this.processingLoadQueue = false;
    }

    private void updateModelData(IImmersiveConnectable iic, World world) {
        for (ConnectionPoint cp : iic.getConnectionPoints()) {
            LocalWireNetwork localNet = this.getLocalNet(cp);
            for (Connection c : this.getLocalNet(cp).getConnections(cp)) {
                ConnectionPoint otherEnd = c.getOtherEnd(cp);
                IImmersiveConnectable otherIIC = localNet.getConnector(otherEnd);
                if (otherIIC instanceof TileEntity) {
                    ((TileEntity)otherIIC).requestModelDataUpdate();
                }
                BlockState state = world.func_180495_p(otherEnd.getPosition());
                world.func_184138_a(otherEnd.getPosition(), state, state, 3);
            }
            BlockState state = world.func_180495_p(cp.getPosition());
            world.func_184138_a(cp.getPosition(), state, state, 3);
        }
        if (iic instanceof TileEntity) {
            ((TileEntity)iic).requestModelDataUpdate();
        }
    }

    private void initializeConnectionsOn(IImmersiveConnectable iic, World world) {
        for (ConnectionPoint cp : iic.getConnectionPoints()) {
            for (Connection c : this.getLocalNet(cp).getConnections(cp)) {
                IImmersiveConnectable iicEnd;
                ConnectionPoint otherEnd = c.getOtherEnd(cp);
                LocalWireNetwork otherLocal = this.getNullableLocalNet(otherEnd);
                if (otherLocal == null || (iicEnd = otherLocal.getConnector(otherEnd)).isProxy()) continue;
                c.generateCatenaryData(world);
                if (world.field_72995_K) continue;
                WireLogger.logger.info("Here: {}, other end: {}", (Object)iic, (Object)iicEnd);
                this.collisionData.addConnection(c);
            }
        }
    }

    public void onConnectorUnload(IImmersiveConnectable iic) {
        BlockPos pos = iic.getPosition();
        this.processQueuedLoads();
        WireLogger.logger.info("Unloading connector {} at {}", (Object)iic, (Object)iic.getPosition());
        HashMap<LocalWireNetwork, Boolean> handledNets = new HashMap<LocalWireNetwork, Boolean>();
        for (ConnectionPoint connectionPoint : iic.getConnectionPoints()) {
            LocalWireNetwork local = this.getLocalNet(connectionPoint);
            Boolean actuallyRemoved = (Boolean)handledNets.get(local);
            if (actuallyRemoved == null) {
                actuallyRemoved = local.unloadConnector(pos, iic);
                handledNets.put(local, actuallyRemoved);
            }
            if (!actuallyRemoved.booleanValue()) continue;
            for (Connection c : this.getLocalNet(connectionPoint).getConnections(connectionPoint)) {
                this.collisionData.removeConnection(c);
            }
        }
        this.validateNextTick = true;
    }

    @Override
    public void update(World world) {
        if (this.validateNextTick) {
            this.validate(world);
            this.validateNextTick = false;
        }
        this.processQueuedLoads();
        HashSet<LocalWireNetwork> ticked = new HashSet<LocalWireNetwork>();
        for (LocalWireNetwork net : this.localNets.values()) {
            if (!ticked.add(net)) continue;
            net.update(world);
        }
        if (SANITIZE_CONNECTIONS.getValue().getAsBoolean()) {
            NetworkSanitizer.tick((IWorld)world, this);
        }
    }

    private void validate(World world) {
        if (world.field_72995_K || !VALIDATE_CONNECTIONS.getValue().getAsBoolean()) {
            return;
        }
        WireLogger.logger.info("Validating wire network...");
        if (this.validating) {
            WireLogger.logger.error("Recursive validation call!");
            Thread.dumpStack();
        }
        this.validating = true;
        this.localNets.values().stream().distinct().forEach(local -> {
            HashMap handlerUsers = new HashMap();
            Function<ResourceLocation, Multiset> getHandler = rl -> handlerUsers.computeIfAbsent(rl, r -> HashMultiset.create());
            for (ConnectionPoint cp : local.getConnectionPoints()) {
                IImmersiveConnectable iic = local.getConnector(cp);
                if (!iic.getConnectionPoints().contains(cp)) {
                    WireLogger.logger.warn("Connection point {} does not exist on {}", (Object)cp, (Object)iic);
                    continue;
                }
                for (ResourceLocation rl2 : iic.getRequestedHandlers()) {
                    getHandler.apply(rl2).add((Object)iic);
                }
                if (this.localNets.get(cp) != local) {
                    WireLogger.logger.warn("{} has net {}, but is in net {}", (Object)cp, (Object)this.localNets.get(cp), local);
                    continue;
                }
                for (Connection c : local.getConnections(cp)) {
                    if (this.localNets.get(c.getOtherEnd(cp)) != local) {
                        WireLogger.logger.warn("{} is connected to {}, but nets are {} and {}", (Object)cp, (Object)c.getOtherEnd(cp), (Object)this.localNets.get(c.getOtherEnd(cp)), local);
                    } else if (!local.getConnections(c.getOtherEnd(cp)).contains(c)) {
                        WireLogger.logger.warn("Connection {} from {} to {} is a diode!", (Object)c, (Object)cp, (Object)c.getOtherEnd(cp));
                    }
                    if (!c.isPositiveEnd(cp)) continue;
                    for (ResourceLocation rl3 : c.type.getRequestedHandlers()) {
                        getHandler.apply(rl3).add((Object)c.type);
                    }
                }
            }
            for (ResourceLocation rl4 : handlerUsers.keySet()) {
                Multiset expected;
                Multiset<ILocalHandlerProvider> actual = local.handlerUsers.get(rl4);
                if (actual.equals((Object)(expected = (Multiset)handlerUsers.get(rl4)))) continue;
                WireLogger.logger.warn("Expected users for {}: {}, but found {}", (Object)rl4, (Object)expected, actual);
            }
            for (ResourceLocation rl4 : local.handlerUsers.keySet()) {
                if (handlerUsers.containsKey(rl4)) continue;
                WireLogger.logger.warn("Found no users for {}, but net expects {}", (Object)rl4, local.handlerUsers.get(rl4));
            }
            for (BlockPos p : local.getConnectors()) {
                TileEntity inWorld;
                IImmersiveConnectable inNet;
                if (!SafeChunkUtils.isChunkSafe((IWorld)world, p) || (inNet = local.getConnector(p)) == (inWorld = SafeChunkUtils.getSafeTE((IWorld)world, p))) continue;
                WireLogger.logger.warn("Connector at {}: {} in Net, {} in World (Net is {})", (Object)p, (Object)inNet, (Object)inWorld, local);
            }
        });
        WireLogger.logger.info("Validated!");
        this.validating = false;
    }

    public WireCollisionData getCollisionData() {
        return this.collisionData;
    }

    public Collection<ConnectionPoint> getAllConnectorsIn(ChunkPos pos) {
        ArrayList<ConnectionPoint> ret = new ArrayList<ConnectionPoint>();
        for (ConnectionPoint cp : this.localNets.keySet()) {
            if (!pos.equals((Object)new ChunkPos(cp.getPosition()))) continue;
            ret.add(cp);
        }
        return ret;
    }

    void removeCP(ConnectionPoint cp) {
        LocalWireNetwork local = this.getNullableLocalNet(cp);
        if (local != null) {
            local.removeCP(cp);
        }
    }

    void removeConnector(BlockPos pos) {
        ArrayList<ConnectionPoint> cpsAtInvalid = new ArrayList<ConnectionPoint>();
        for (ConnectionPoint cp : this.localNets.keySet()) {
            if (!cp.getPosition().equals((Object)pos)) continue;
            cpsAtInvalid.add(cp);
        }
        for (ConnectionPoint toRemove : cpsAtInvalid) {
            this.removeCP(toRemove);
        }
    }

    public void updateCatenaryData(Connection conn, World world) {
        this.processQueuedLoads();
        this.collisionData.removeConnection(conn);
        conn.resetCatenaryData();
        conn.generateCatenaryData(world);
        this.collisionData.addConnection(conn);
    }

    private void putLocalNet(ConnectionPoint cp, @Nullable LocalWireNetwork net) {
        LocalWireNetwork oldNet = this.localNets.get(cp);
        if (oldNet != null && net != null && oldNet.isValid(cp)) {
            WireLogger.logger.info("Marking {} as invalid", (Object)oldNet);
            oldNet.setInvalid();
        }
        if (net != null) {
            this.localNets.put(cp, net);
        } else {
            this.localNets.remove(cp);
        }
    }

    public IImmersiveConnectable getExistingConnector(ConnectionPoint cp) {
        LocalWireNetwork local = this.getNullableLocalNet(cp);
        return ((LocalWireNetwork)Preconditions.checkNotNull((Object)local, (String)"No local net at %s", (Object)cp)).getConnector(cp);
    }

    public IICProxyProvider getProxyProvider() {
        return this.proxyProvider;
    }
}

