/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models;

import blusunrize.immersiveengineering.api.wires.utils.WireUtils;
import blusunrize.immersiveengineering.client.models.ModelIEArmorBase;
import blusunrize.immersiveengineering.client.render.IEBipedLayerRenderer;
import blusunrize.immersiveengineering.client.utils.TransformingVertexBuilder;
import blusunrize.immersiveengineering.common.items.PowerpackItem;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.mixin.accessors.client.ModelAccess;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.text.DecimalFormat;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ModelPowerpack<T extends LivingEntity>
extends ModelIEArmorBase<T> {
    public ModelRenderer[] modelParts;
    public ModelRenderer[] colouredParts;
    static final DecimalFormat keyFormat = new DecimalFormat("0.0000");
    public static final Cache<String, Vector3d[]> catenaryCacheLeft = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
    public static final Cache<String, Vector3d[]> catenaryCacheRight = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
    static ModelPowerpack modelInstance;

    public ModelPowerpack(float modelSize, float yOffsetIn, int textureWidthIn, int textureHeightIn) {
        super(modelSize, yOffsetIn, textureWidthIn, textureHeightIn);
        ((ModelAccess)((Object)this)).setRenderType(RenderType::func_228644_e_);
        this.modelParts = new ModelRenderer[8];
        this.colouredParts = new ModelRenderer[4];
        this.modelParts[0] = new ModelRenderer((Model)this, 40, 0);
        this.modelParts[0].func_228301_a_(-4.0f, -5.0f, -2.0f, 8.0f, 10.0f, 3.0f, 0.0f);
        this.modelParts[0].func_78793_a(0.0f, 5.0f, 4.0f);
        this.field_78115_e.func_78792_a(this.modelParts[0]);
        this.modelParts[1] = new ModelRenderer((Model)this, 12, 0);
        this.modelParts[1].func_228301_a_(-3.0f, -2.0f, -2.0f, 6.0f, 4.0f, 4.0f, 0.0f);
        this.modelParts[1].func_78793_a(0.0f, 12.0f, 4.0f);
        this.field_78115_e.func_78792_a(this.modelParts[1]);
        this.modelParts[2] = new ModelRenderer((Model)this, 0, 0);
        this.modelParts[2].func_228301_a_(-1.0f, -4.0f, -1.0f, 2.0f, 8.0f, 2.0f, 0.0f);
        this.modelParts[2].func_78793_a(-5.0f, 5.0f, 3.0f);
        this.field_78115_e.func_78792_a(this.modelParts[2]);
        this.modelParts[3] = new ModelRenderer((Model)this, 0, 0);
        this.modelParts[3].func_228301_a_(-1.0f, -4.0f, -1.0f, 2.0f, 8.0f, 2.0f, 0.0f);
        this.modelParts[3].func_78793_a(5.0f, 5.0f, 3.0f);
        this.modelParts[3].field_78808_h = 3.14159f;
        this.field_78115_e.func_78792_a(this.modelParts[3]);
        ModelRenderer gauge = new ModelRenderer((Model)this, 40, 13);
        gauge.func_228301_a_(-0.5f, -1.5f, -0.5f, 1.0f, 3.0f, 1.0f, 0.0f);
        gauge.func_78793_a(-3.0f, 5.5f, 5.0f);
        this.field_78115_e.func_78792_a(gauge);
        gauge = new ModelRenderer((Model)this, 40, 13);
        gauge.func_228301_a_(-0.5f, -1.5f, -0.5f, 1.0f, 3.0f, 1.0f, 0.0f);
        gauge.func_78793_a(1.0f, 5.5f, 5.0f);
        this.field_78115_e.func_78792_a(gauge);
        gauge = new ModelRenderer((Model)this, 44, 13);
        gauge.func_228301_a_(-2.0f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, 0.0f);
        gauge.func_78793_a(-0.5f, 3.5f, 5.0f);
        this.field_78115_e.func_78792_a(gauge);
        gauge = new ModelRenderer((Model)this, 44, 13);
        gauge.func_228301_a_(-2.0f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, 0.0f);
        gauge.func_78793_a(-0.5f, 7.5f, 5.0f);
        this.field_78115_e.func_78792_a(gauge);
        this.modelParts[7] = new ModelRenderer((Model)this, 52, 14);
        this.modelParts[7].func_228301_a_(-0.5f, -3.5f, -0.5f, 1.0f, 4.0f, 1.0f, -0.25f);
        this.modelParts[7].func_78793_a(-1.0f, 7.625f, 5.0f);
        this.modelParts[7].field_78808_h = 0.7853975f;
        this.field_78115_e.func_78792_a(this.modelParts[7]);
        ModelRenderer connector = new ModelRenderer((Model)this, 17, 9);
        connector.func_228301_a_(-1.0f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f, 0.0f);
        connector.func_78793_a(-4.5f, 0.0f, 0.0f);
        this.modelParts[1].func_78792_a(connector);
        connector = new ModelRenderer((Model)this, 17, 9);
        connector.func_228301_a_(-1.0f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f, -0.375f);
        connector.func_78793_a(-6.0f, 0.0f, 0.0f);
        this.modelParts[1].func_78792_a(connector);
        connector = new ModelRenderer((Model)this, 29, 9);
        connector.func_228301_a_(-1.0f, -1.5f, -1.5f, 1.0f, 3.0f, 3.0f, 0.0f);
        connector.func_78793_a(-6.25f, 0.0f, 0.0f);
        this.modelParts[1].func_78792_a(connector);
        connector = new ModelRenderer((Model)this, 12, 8);
        connector.func_228301_a_(-0.5f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, 0.0f);
        connector.func_78793_a(-7.5f, 0.0f, 0.0f);
        this.modelParts[1].func_78792_a(connector);
        connector = new ModelRenderer((Model)this, 17, 9);
        connector.func_228301_a_(-1.0f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f, 0.0f);
        connector.func_78793_a(4.5f, 0.0f, 0.0f);
        connector.field_78796_g = 3.14159f;
        this.modelParts[1].func_78792_a(connector);
        connector = new ModelRenderer((Model)this, 17, 9);
        connector.func_228301_a_(-1.0f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f, -0.375f);
        connector.func_78793_a(6.0f, 0.0f, 0.0f);
        connector.field_78796_g = 3.14159f;
        this.modelParts[1].func_78792_a(connector);
        connector = new ModelRenderer((Model)this, 29, 9);
        connector.func_228301_a_(-1.0f, -1.5f, -1.5f, 1.0f, 3.0f, 3.0f, 0.0f);
        connector.func_78793_a(6.25f, 0.0f, 0.0f);
        connector.field_78796_g = 3.14159f;
        this.modelParts[1].func_78792_a(connector);
        connector = new ModelRenderer((Model)this, 12, 8);
        connector.func_228301_a_(-0.5f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, 0.0f);
        connector.func_78793_a(7.5f, 0.0f, 0.0f);
        connector.field_78796_g = 3.14159f;
        this.modelParts[1].func_78792_a(connector);
        for (int i = 0; i < 3; ++i) {
            float pos = 3.125f - (float)i * 2.25f;
            ModelRenderer tube = new ModelRenderer((Model)this, 56, 19);
            tube.func_228301_a_(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, -0.25f);
            tube.func_78793_a(pos, 1.0f, 5.0f);
            tube.field_78795_f = (float)Math.toRadians(-45.0);
            this.field_78115_e.func_78792_a(tube);
            ModelRenderer tube2 = new ModelRenderer((Model)this, 52, 18);
            tube2.func_228301_a_(-0.5f, -2.0f, -0.5f, 1.0f, 3.0f, 1.0f, 0.0f);
            tube2.func_78793_a(0.0f, -0.5f, 0.0f);
            tube.func_78792_a(tube2);
            tube2 = new ModelRenderer((Model)this, 56, 15);
            tube2.func_228301_a_(-1.0f, -2.0f, -1.0f, 2.0f, 2.0f, 2.0f, 0.0f);
            tube2.func_78793_a(0.0f, -0.75f, 0.0f);
            tube.func_78792_a(tube2);
            tube2 = new ModelRenderer((Model)this, 56, 13);
            tube2.func_228301_a_(-0.5f, -1.0f, -0.5f, 1.0f, 1.0f, 1.0f, 0.0f);
            tube2.func_78793_a(0.0f, -2.25f, 0.0f);
            tube.func_78792_a(tube2);
            tube2 = new ModelRenderer((Model)this, 56, 13);
            tube2.func_228301_a_(-0.5f, -1.0f, -0.5f, 1.0f, 1.0f, 1.0f, -0.25f);
            tube2.func_78793_a(0.0f, -3.0f, 0.0f);
            tube.func_78792_a(tube2);
        }
        this.field_78116_c.field_78806_j = false;
        this.field_178720_f.field_78806_j = false;
        this.field_178724_i.field_78806_j = false;
        this.field_178723_h.field_78806_j = false;
        this.field_178722_k.field_78806_j = false;
        this.field_178721_j.field_78806_j = false;
    }

    @Override
    public void func_225598_a_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (this.entityTemp instanceof LivingEntity) {
            ItemStack chest = this.entityTemp.func_184582_a(EquipmentSlotType.CHEST);
            ItemStack powerpack = null;
            float storage = 0.0f;
            if (!chest.func_190926_b() && chest.func_77973_b() instanceof PowerpackItem) {
                powerpack = chest;
            } else if (!chest.func_190926_b() && chest.func_77973_b() instanceof ArmorItem && ItemNBTHelper.hasKey(chest, "IE:Powerpack")) {
                powerpack = ItemNBTHelper.getItemStack(chest, "IE:Powerpack");
            } else if (IEBipedLayerRenderer.POWERPACK_PLAYERS.containsKey(this.entityTemp.func_110124_au())) {
                powerpack = (ItemStack)IEBipedLayerRenderer.POWERPACK_PLAYERS.get(this.entityTemp.func_110124_au()).getLeft();
            }
            if (powerpack != null) {
                float max = EnergyHelper.getMaxEnergyStored((ICapabilityProvider)powerpack);
                storage = max <= 0.0f ? 0.0f : (float)EnergyHelper.getEnergyStored((ICapabilityProvider)powerpack) / max;
                this.modelParts[7].field_78808_h = 0.5235987f - 1.047197f * storage;
            }
        }
        super.func_225598_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        TextureAtlasSprite wireTexture = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(new ResourceLocation("immersiveengineering", "textures/block/wire"));
        for (Hand hand : Hand.values()) {
            Vector3d[] vex;
            ItemStack stack = this.entityTemp.func_184586_b(hand);
            if (stack.func_190926_b() || !EnergyHelper.isFluxRelated((ICapabilityProvider)stack)) continue;
            boolean right = hand == Hand.MAIN_HAND == (this.entityTemp.func_184591_cq() == HandSide.RIGHT);
            float angleX = (right ? this.field_178723_h : this.field_178724_i).field_78795_f;
            float angleZ = (right ? this.field_178723_h : this.field_178724_i).field_78808_h;
            String cacheKey = keyFormat.format(angleX) + "_" + keyFormat.format(angleZ);
            try {
                vex = (Vector3d[])(right ? catenaryCacheRight : catenaryCacheLeft).get((Object)cacheKey, () -> {
                    double armLength = 0.75;
                    double x = 0.3125 + (double)(right ? 1 : -1) * armLength * Math.sin(angleZ);
                    double y = armLength * Math.cos(angleX);
                    double z = armLength * Math.sin(angleX);
                    return WireUtils.getConnectionCatenary(new Vector3d(0.484375, -0.75, 0.25), new Vector3d(x, -y, z), 1.5);
                });
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            float vStep = 1.0f / (float)vex.length;
            TransformingVertexBuilder builder = new TransformingVertexBuilder(bufferIn, matrixStackIn);
            double scaleX = right ? -1.0 : 1.0;
            builder.setColor(0.93f, 0.63f, 0.27f, 1.0f);
            builder.setLight(packedLightIn);
            builder.setOverlay(packedOverlayIn);
            float v0 = wireTexture.func_94206_g();
            float v1 = wireTexture.func_94210_h();
            for (int i = 1; i < vex.length; ++i) {
                for (int offset = 0; offset < 2; ++offset) {
                    double tmp;
                    Vector3d vec;
                    int iHere = i - offset;
                    int iThere = i - 1 + offset;
                    Vector3d vecHere = vex[iHere];
                    Vector3d vecThere = vex[iThere];
                    builder.setNormal((float)(vecThere.field_72449_c - vecHere.field_72449_c), 0.0f, (float)(vecHere.field_72450_a - vecThere.field_72450_a));
                    for (int index : new int[]{iHere, iThere}) {
                        vec = vex[index];
                        double xA = scaleX * vec.field_72450_a - 0.015625;
                        double xB = scaleX * vec.field_72450_a + 0.015625;
                        if (index == iHere) {
                            tmp = xA;
                            xA = xB;
                            xB = tmp;
                        }
                        builder.func_225582_a_(xA, -vec.field_72448_b, vec.field_72449_c).func_225583_a_(wireTexture.func_94214_a((double)(vStep * (float)index)), v0).func_181675_d();
                        builder.func_225582_a_(xB, -vec.field_72448_b, vec.field_72449_c).func_225583_a_(wireTexture.func_94214_a((double)(vStep * (float)index)), v1).func_181675_d();
                    }
                    builder.setNormal((float)(vecThere.field_72448_b - vecHere.field_72448_b), (float)(vecHere.field_72450_a - vecThere.field_72450_a), 0.0f);
                    for (int index : new int[]{iHere, iThere}) {
                        vec = vex[index];
                        double yA = -vec.field_72448_b - 0.015625;
                        double yB = -vec.field_72448_b;
                        if (index == iThere) {
                            tmp = yA;
                            yA = yB;
                            yB = tmp;
                        }
                        builder.func_225582_a_(scaleX * vec.field_72450_a, yA, vec.field_72449_c).func_225583_a_(wireTexture.func_94214_a((double)(vStep * (float)index)), v0).func_181675_d();
                        builder.func_225582_a_(scaleX * vec.field_72450_a, yB, vec.field_72449_c).func_225583_a_(wireTexture.func_94214_a((double)(vStep * (float)index)), v1).func_181675_d();
                    }
                }
            }
        }
    }

    public static ModelPowerpack getModel() {
        if (modelInstance == null) {
            modelInstance = new ModelPowerpack(0.0625f, 0.0f, 64, 32);
        }
        return modelInstance;
    }
}

