/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.connection;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.utils.QuadTransformer;
import blusunrize.immersiveengineering.api.utils.client.CombinedModelData;
import blusunrize.immersiveengineering.api.utils.client.SinglePropertyModelData;
import blusunrize.immersiveengineering.api.wires.WireApi;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.BakedIEModel;
import blusunrize.immersiveengineering.client.utils.ModelUtils;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.blocks.metal.FeedthroughTileEntity;
import blusunrize.immersiveengineering.common.util.DirectionUtils;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ItemTransformVec3f;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;

public class FeedthroughModel
extends BakedIEModel {
    public static final Cache<FeedthroughCacheKey, SpecificFeedthroughModel> CACHE = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).maximumSize(100L).build();
    private static final ModelProperty<FeedthroughTileEntity.FeedthroughData> FEEDTHROUGH = new ModelProperty();
    private ItemCameraTransforms transform = new ItemCameraTransforms(new ItemTransformVec3f(new Vector3f(75.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.375f, 0.375f, 0.375f)), new ItemTransformVec3f(new Vector3f(75.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.375f, 0.375f, 0.375f)), new ItemTransformVec3f(new Vector3f(0.0f, 225.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.4f, 0.4f, 0.4f)), new ItemTransformVec3f(new Vector3f(0.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.4f, 0.4f, 0.4f)), new ItemTransformVec3f(new Vector3f(), new Vector3f(), new Vector3f()), new ItemTransformVec3f(new Vector3f(30.0f, 225.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.6f, 0.6f, 0.6f)), new ItemTransformVec3f(new Vector3f(), new Vector3f(0.0f, 0.3f, 0.0f), new Vector3f(0.25f, 0.25f, 0.25f)), new ItemTransformVec3f(new Vector3f(0.0f, 180.0f, 45.0f), new Vector3f(0.0f, 0.0f, -0.1875f), new Vector3f(0.5f, 0.5f, 0.5f)));
    private static final FeedthroughItemOverride INSTANCE = new FeedthroughItemOverride();

    @Override
    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        BlockState baseState = Blocks.field_150348_b.func_176223_P();
        WireType wire = WireType.COPPER;
        Direction facing = Direction.NORTH;
        int offset = 1;
        Int2IntFunction colorMultiplier = i -> -1;
        if (extraData.hasProperty(FEEDTHROUGH)) {
            FeedthroughTileEntity.FeedthroughData data = (FeedthroughTileEntity.FeedthroughData)extraData.getData(FEEDTHROUGH);
            assert (data != null);
            baseState = data.baseState;
            wire = data.wire;
            facing = data.facing;
            offset = data.offset;
            colorMultiplier = data.colorMultiplier;
        }
        Int2IntFunction colorMultiplierFinal = colorMultiplier;
        FeedthroughCacheKey key = new FeedthroughCacheKey(wire, baseState, offset, facing, MinecraftForgeClient.getRenderLayer(), colorMultiplier);
        SpecificFeedthroughModel ret = (SpecificFeedthroughModel)CACHE.getIfPresent((Object)key);
        if (ret == null) {
            ret = new SpecificFeedthroughModel(key, colorMultiplierFinal);
            Preconditions.checkState((key.usedColorMultipliers != null ? 1 : 0) != 0);
            CACHE.put((Object)key, (Object)ret);
        }
        return ret.func_200117_a(state, side, rand);
    }

    @Nonnull
    public IModelData getModelData(@Nonnull IBlockDisplayReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        ArrayList<IModelData> ret = new ArrayList<IModelData>();
        ret.add(tileData);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof FeedthroughTileEntity) {
            FeedthroughTileEntity feedthrough = (FeedthroughTileEntity)te;
            int color = Minecraft.func_71410_x().func_184125_al().func_228054_a_(feedthrough.stateForMiddle, world, pos, 0);
            FeedthroughTileEntity.FeedthroughData d = new FeedthroughTileEntity.FeedthroughData(feedthrough.stateForMiddle, feedthrough.reference, (Direction)state.func_177229_b((Property)IEProperties.FACING_ALL), feedthrough.offset, i -> color);
            ret.add(new SinglePropertyModelData<FeedthroughTileEntity.FeedthroughData>(d, FEEDTHROUGH));
        }
        return CombinedModelData.combine(ret.toArray(new IModelData[0]));
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return ModelLoader.White.instance();
    }

    @Nonnull
    public ItemCameraTransforms func_177552_f() {
        return this.transform;
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return INSTANCE;
    }

    private static class SpecificFeedthroughModel
    extends FeedthroughModel {
        private static final float[] WHITE = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        private static final Vector3d[] vertices = new Vector3d[]{new Vector3d(0.75, (double)0.001f, 0.75), new Vector3d(0.75, (double)0.001f, 0.25), new Vector3d(0.25, (double)0.001f, 0.25), new Vector3d(0.25, (double)0.001f, 0.75)};
        List<List<BakedQuad>> quads = new ArrayList<List<BakedQuad>>(6);

        public SpecificFeedthroughModel(ItemStack stack) {
            WireType w = WireType.getValue(ItemNBTHelper.getString(stack, "wire"));
            BlockState state = NBTUtil.func_190008_d((CompoundNBT)ItemNBTHelper.getTagCompound(stack, "middle"));
            if (state.func_177230_c() == Blocks.field_150350_a) {
                state = Blocks.field_150342_X.func_176223_P();
            }
            this.init(new FeedthroughCacheKey(w, state, Integer.MAX_VALUE, Direction.NORTH, null), i -> ClientUtils.mc().getItemColors().func_186728_a(stack, i));
        }

        public SpecificFeedthroughModel(FeedthroughCacheKey key, Int2IntFunction colorMultiplier) {
            this.init(key, colorMultiplier);
        }

        private void init(FeedthroughCacheKey k, Int2IntFunction colorMultiplierBasic) {
            IBakedModel model = ClientUtils.mc().func_175602_ab().func_175023_a().func_178125_b(k.baseState);
            if (colorMultiplierBasic == null) {
                ItemColors colors = ClientUtils.mc().getItemColors();
                ItemStack stack = new ItemStack((IItemProvider)k.baseState.func_177230_c(), 1);
                colorMultiplierBasic = i -> colors.func_186728_a(stack, i);
            }
            Int2IntFunction colorMultiplierFinal = colorMultiplierBasic;
            k.usedColorMultipliers = new Int2IntOpenHashMap();
            Int2IntFunction colorMultiplier = i -> {
                int ret = colorMultiplierFinal.get(i);
                k.usedColorMultipliers.put(i, ret);
                return ret;
            };
            for (int j = 0; j < 7; ++j) {
                Direction side = j < 6 ? DirectionUtils.VALUES[j] : null;
                Direction facing = k.facing;
                switch (k.offset) {
                    case 0: {
                        if (k.layer != null && !RenderTypeLookup.canRenderInLayer((BlockState)k.baseState, (RenderType)k.layer)) break;
                        QuadTransformer tintTransformer = new QuadTransformer(TransformationMatrix.func_227983_a_(), colorMultiplier);
                        this.quads.add(model.getQuads(k.baseState, side, Utils.RAND, (IModelData)EmptyModelData.INSTANCE).stream().map(tintTransformer).collect(Collectors.toCollection(ArrayList::new)));
                        break;
                    }
                    case 1: {
                        facing = facing.func_176734_d();
                    }
                    case -1: {
                        if (k.layer != RenderType.func_228639_c_()) break;
                        this.quads.add(this.getConnQuads(facing, side, k.type, new Matrix4()));
                        break;
                    }
                    case 0x7FFFFFFF: {
                        Matrix4 mat = new Matrix4();
                        mat.translate(0.0, 0.0, 1.0);
                        ArrayList<BakedQuad> all = new ArrayList<BakedQuad>(this.getConnQuads(facing, side, k.type, mat));
                        mat = new Matrix4();
                        mat.translate(0.0, 0.0, -1.0);
                        all.addAll(this.getConnQuads(facing.func_176734_d(), side, k.type, mat));
                        QuadTransformer tintTransformer = new QuadTransformer(TransformationMatrix.func_227983_a_(), colorMultiplier);
                        all.addAll(model.func_200117_a(k.baseState, side, Utils.RAND).stream().map(tintTransformer).collect(Collectors.toCollection(ArrayList::new)));
                        this.quads.add(all);
                    }
                }
                if (this.quads.size() > j) continue;
                this.quads.add((List<BakedQuad>)ImmutableList.of());
            }
        }

        private List<BakedQuad> getConnQuads(Direction facing, Direction side, WireType type, Matrix4 mat) {
            QuadTransformer transf;
            WireApi.FeedthroughModelInfo info = WireApi.INFOS.get(type);
            mat.translate(0.5, 0.5, 0.5);
            if (facing.func_176740_k() == Direction.Axis.Y) {
                if (facing == Direction.UP) {
                    mat.rotate(Math.PI, 1.0, 0.0, 0.0);
                }
            } else {
                Direction rotateAround = DirectionUtils.rotateAround(facing, Direction.Axis.Y);
                mat.rotate(1.5707963267948966, rotateAround.func_82601_c(), rotateAround.func_96559_d(), rotateAround.func_82599_e());
            }
            mat.translate(-0.5, -0.5, -0.5);
            IBakedModel model = ClientUtils.mc().func_175602_ab().func_175023_a().func_178125_b((BlockState)info.conn.get().func_206870_a((Property)IEProperties.FACING_ALL, (Comparable)Direction.DOWN));
            ArrayList<BakedQuad> conn = new ArrayList<BakedQuad>(model.getQuads(null, side, Utils.RAND, (IModelData)EmptyModelData.INSTANCE));
            if (side == facing) {
                conn.add(ModelUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, vertices, Direction.UP, info.tex, info.uvs, WHITE, false));
            }
            if ((transf = new QuadTransformer(new TransformationMatrix(mat.toMatrix4f()), null)) != null) {
                return conn.stream().map(transf).collect(Collectors.toList());
            }
            return conn;
        }

        @Override
        @Nonnull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
            return this.quads.get(side == null ? 6 : side.func_176745_a());
        }
    }

    private static class FeedthroughCacheKey {
        final WireType type;
        final BlockState baseState;
        final int offset;
        final Direction facing;
        final RenderType layer;
        @Nullable
        Int2IntMap usedColorMultipliers;
        @Nullable
        final Int2IntFunction allColorMultipliers;

        public FeedthroughCacheKey(WireType type, BlockState baseState, int offset, Direction facing, RenderType layer) {
            this.type = type;
            this.baseState = baseState;
            this.offset = offset;
            this.facing = facing;
            this.layer = layer;
            this.allColorMultipliers = null;
            this.usedColorMultipliers = new Int2IntOpenHashMap();
        }

        public FeedthroughCacheKey(WireType type, BlockState baseState, int offset, Direction facing, RenderType layer, Int2IntFunction colorMultiplier) {
            this.type = type;
            this.baseState = baseState;
            this.offset = offset;
            this.facing = facing;
            this.layer = layer;
            this.allColorMultipliers = colorMultiplier;
            this.usedColorMultipliers = null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FeedthroughCacheKey that = (FeedthroughCacheKey)o;
            return this.offset == that.offset && Objects.equals(this.type, that.type) && this.baseState.equals(that.baseState) && this.facing == that.facing && Objects.equals(this.layer, that.layer) && this.sameColorMultipliersAs(that);
        }

        private boolean sameColorMultipliersAs(FeedthroughCacheKey that) {
            if (that.usedColorMultipliers != null && this.usedColorMultipliers != null) {
                return this.usedColorMultipliers.equals(that.usedColorMultipliers);
            }
            if (that.usedColorMultipliers != null && this.allColorMultipliers != null) {
                IntIterator intIterator = that.usedColorMultipliers.keySet().iterator();
                while (intIterator.hasNext()) {
                    int i = (Integer)intIterator.next();
                    if (this.allColorMultipliers.get(i) == that.usedColorMultipliers.get(i)) continue;
                    return false;
                }
                return true;
            }
            if (that.allColorMultipliers != null && this.usedColorMultipliers != null) {
                return that.sameColorMultipliersAs(this);
            }
            throw new IllegalStateException("Can't compare FeedthroughCacheKey's that use functions!");
        }

        public int hashCode() {
            int ret = Utils.hashBlockstate(this.baseState);
            return 31 * ret + Objects.hash(this.type, this.offset, this.facing, this.layer);
        }
    }

    private static class FeedthroughItemOverride
    extends ItemOverrideList {
        private static Cache<ItemStack, FeedthroughModel> ITEM_MODEL_CACHE = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(60L, TimeUnit.SECONDS).build();

        private FeedthroughItemOverride() {
        }

        @Nonnull
        public IBakedModel func_239290_a_(@Nonnull IBakedModel originalModel, ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity entity) {
            Item connItem = Item.func_150898_a((Block)IEBlocks.Connectors.feedthrough);
            if (stack.func_77973_b() == connItem) {
                try {
                    return (IBakedModel)ITEM_MODEL_CACHE.get((Object)stack, () -> new SpecificFeedthroughModel(stack));
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
            return originalModel;
        }
    }
}

