/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.api.crafting.ClocheRecipe;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import blusunrize.immersiveengineering.client.utils.RenderUtils;
import blusunrize.immersiveengineering.client.utils.TransformingVertexBuilder;
import blusunrize.immersiveengineering.common.blocks.metal.ClocheTileEntity;
import blusunrize.immersiveengineering.common.util.Utils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import org.apache.commons.lang3.tuple.Pair;

public class ClocheRenderer
extends TileEntityRenderer<ClocheTileEntity> {
    private static final Map<BlockState, List<BakedQuad>> plantQuads = new HashMap<BlockState, List<BakedQuad>>();

    public ClocheRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(ClocheTileEntity tile, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (tile.dummy != 0 || !tile.getWorldNonnull().func_175667_e(tile.func_174877_v())) {
            return;
        }
        BlockRendererDispatcher blockRenderer = Minecraft.func_71410_x().func_175602_ab();
        BlockPos blockPos = tile.func_174877_v();
        matrixStack.func_227860_a_();
        ActiveRenderInfo activeInfo = Minecraft.func_71410_x().field_71460_t.func_215316_n();
        matrixStack.func_227861_a_(activeInfo.func_216785_c().field_72450_a - (double)tile.func_174877_v().func_177958_n(), activeInfo.func_216785_c().field_72448_b - (double)tile.func_174877_v().func_177956_o(), activeInfo.func_216785_c().field_72449_c - (double)tile.func_174877_v().func_177952_p());
        IVertexBuilder baseBuffer = IERenderTypes.disableLighting(bufferIn).getBuffer(RenderType.func_228638_b_((ResourceLocation)AtlasTexture.field_215262_g));
        TransformingVertexBuilder particleBuilder = new TransformingVertexBuilder(baseBuffer, matrixStack);
        particleBuilder.setNormal(0.0f, 1.0f, 0.0f);
        particleBuilder.setOverlay(OverlayTexture.field_229196_a_);
        for (Particle p : tile.particles) {
            p.func_225606_a_((IVertexBuilder)particleBuilder, activeInfo, partialTicks);
        }
        matrixStack.func_227865_b_();
        ClocheRecipe recipe = tile.getRecipe();
        if (recipe != null) {
            IVertexBuilder baseBuilder = bufferIn.getBuffer(RenderType.func_228643_e_());
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, 1.0625, 0.0);
            NonNullList<ItemStack> inventory = tile.getInventory();
            ItemStack seed = (ItemStack)inventory.get(1);
            ItemStack soil = (ItemStack)inventory.get(0);
            float growth = MathHelper.func_76131_a((float)(tile.renderGrowth / (float)recipe.getTime(seed, soil)), (float)0.0f, (float)1.0f);
            float scale = recipe.renderFunction.getScale(seed, growth);
            matrixStack.func_227861_a_((double)((1.0f - scale) / 2.0f), 0.0, (double)((1.0f - scale) / 2.0f));
            matrixStack.func_227862_a_(scale, scale, scale);
            Collection<Pair<BlockState, TransformationMatrix>> blocks = recipe.renderFunction.getBlocks(seed, growth);
            for (Pair<BlockState, TransformationMatrix> block : blocks) {
                BlockState state = (BlockState)block.getLeft();
                List<BakedQuad> plantQuadList = plantQuads.get(state);
                if (plantQuadList == null) {
                    IBakedModel plantModel = blockRenderer.func_184389_a(state);
                    plantQuadList = new ArrayList<BakedQuad>(plantModel.getQuads(state, null, Utils.RAND, (IModelData)EmptyModelData.INSTANCE));
                    for (Direction f : Direction.values()) {
                        plantQuadList.addAll(plantModel.getQuads(state, f, Utils.RAND, (IModelData)EmptyModelData.INSTANCE));
                    }
                    plantQuads.put(state, plantQuadList);
                }
                int col = ClientUtils.mc().func_184125_al().func_228054_a_(state, null, blockPos, -1);
                ((TransformationMatrix)block.getRight()).push(matrixStack);
                RenderUtils.renderModelTESRFancy(plantQuadList, new TransformingVertexBuilder(baseBuilder, matrixStack), tile.getWorldNonnull(), blockPos, false, col, combinedLightIn);
                matrixStack.func_227865_b_();
            }
            ArrayList<BakedQuad> injectedQuadList = new ArrayList<BakedQuad>();
            Consumer<Object> quadInjector = object -> {
                if (object instanceof BakedQuad) {
                    injectedQuadList.add((BakedQuad)object);
                }
            };
            recipe.renderFunction.injectQuads(seed, growth, quadInjector);
            if (injectedQuadList.size() > 0) {
                RenderUtils.renderModelTESRFancy(injectedQuadList, new TransformingVertexBuilder(baseBuilder, matrixStack), tile.getWorldNonnull(), blockPos, false, -1, combinedLightIn);
            }
            matrixStack.func_227865_b_();
        }
    }

    public static void reset() {
        plantQuads.clear();
    }
}

