/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.utils;

import blusunrize.immersiveengineering.client.utils.CollectingVertexBuilder;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;

public class BatchingRenderTypeBuffer
implements IRenderTypeBuffer {
    private final Map<RenderType, CollectingVertexBuilder> builders = new HashMap<RenderType, CollectingVertexBuilder>();

    @Nonnull
    public IVertexBuilder getBuffer(@Nonnull RenderType type) {
        return this.builders.computeIfAbsent(type, s -> new CollectingVertexBuilder());
    }

    public void pipe(IRenderTypeBuffer out) {
        ImmutableList delay = ImmutableList.of((Object)RenderType.func_228653_j_(), (Object)RenderType.func_228655_k_());
        for (Map.Entry<RenderType, CollectingVertexBuilder> e : this.builders.entrySet()) {
            if (delay.contains(e.getKey())) continue;
            e.getValue().pipeAndClear(out.getBuffer(e.getKey()));
        }
        for (RenderType rt : delay) {
            if (!this.builders.containsKey(rt)) continue;
            this.builders.get(rt).pipeAndClear(out.getBuffer(rt));
        }
        this.builders.clear();
    }
}

