/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import blusunrize.immersiveengineering.common.blocks.IIEBlock;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

public class BlockItemIE
extends BlockItem {
    private int burnTime;

    public BlockItemIE(Block b, Item.Properties props) {
        super(b, props);
    }

    public BlockItemIE(Block b) {
        this(b, new Item.Properties().func_200916_a(ImmersiveEngineering.itemGroup));
        this.setRegistryName(b.getRegistryName());
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_179223_d().func_149739_a();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        FluidStack fs;
        IIEBlock ieBlock;
        if (this.func_179223_d() instanceof IIEBlock && (ieBlock = (IIEBlock)this.func_179223_d()).hasFlavour()) {
            String flavourKey = "desc.immersiveengineering.flavour." + ieBlock.getNameForFlavour();
            tooltip.add((ITextComponent)TextUtils.applyFormat((ITextComponent)new TranslationTextComponent(flavourKey), TextFormatting.GRAY));
        }
        super.func_77624_a(stack, world, tooltip, advanced);
        if (ItemNBTHelper.hasKey(stack, "energyStorage")) {
            tooltip.add((ITextComponent)TextUtils.applyFormat((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.info.energyStored", new Object[]{ItemNBTHelper.getInt(stack, "energyStorage")}), TextFormatting.GRAY));
        }
        if (ItemNBTHelper.hasKey(stack, "tank") && (fs = FluidStack.loadFluidStackFromNBT((CompoundNBT)ItemNBTHelper.getTagCompound(stack, "tank"))) != null) {
            tooltip.add((ITextComponent)TextUtils.applyFormat((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.info.fluidStored", new Object[]{fs.getDisplayName(), fs.getAmount()}), TextFormatting.GRAY));
        }
    }

    public BlockItemIE setBurnTime(int burnTime) {
        this.burnTime = burnTime;
        return this;
    }

    public int getBurnTime(ItemStack itemStack) {
        return this.burnTime;
    }

    protected boolean func_195941_b(BlockItemUseContext context, BlockState newState) {
        Block b = newState.func_177230_c();
        if (b instanceof IEBaseBlock) {
            IEBaseBlock ieBlock = (IEBaseBlock)b;
            if (!ieBlock.canIEBlockBePlaced(newState, context)) {
                return false;
            }
            boolean ret = super.func_195941_b(context, newState);
            if (ret) {
                ieBlock.onIEBlockPlacedBy(context, newState);
            }
            return ret;
        }
        return super.func_195941_b(context, newState);
    }

    protected boolean func_195943_a(BlockPos pos, World worldIn, @Nullable PlayerEntity player, ItemStack stack, BlockState state) {
        if (!state.func_235901_b_((Property)IEProperties.MULTIBLOCKSLAVE)) {
            return super.func_195943_a(pos, worldIn, player, stack, state);
        }
        return false;
    }

    public static class BlockItemIENoInventory
    extends BlockItemIE {
        public BlockItemIENoInventory(Block b, Item.Properties props) {
            super(b, props);
        }

        @Nullable
        public CompoundNBT getShareTag(ItemStack stack) {
            CompoundNBT ret = super.getShareTag(stack);
            if (ret != null) {
                ret = ret.func_74737_b();
                ret.func_82580_o("inventory");
            }
            return ret;
        }
    }
}

