/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.IIEBlock;
import blusunrize.immersiveengineering.common.items.HammerItem;
import blusunrize.immersiveengineering.common.items.ScrewdriverItem;
import blusunrize.immersiveengineering.common.items.WirecutterItem;
import java.util.function.BiFunction;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;

public class IEBaseBlock
extends Block
implements IIEBlock,
IWaterLoggable {
    public final String name;
    boolean isHidden;
    boolean hasFlavour;
    protected int lightOpacity;
    protected PushReaction mobilityFlag = PushReaction.NORMAL;
    protected boolean canHammerHarvest;
    protected final boolean notNormalBlock = !this.func_176223_P().func_200132_m();

    public IEBaseBlock(String name, AbstractBlock.Properties blockProps, BiFunction<Block, Item.Properties, Item> createItemBlock) {
        super(blockProps.func_208770_d());
        this.name = name;
        this.func_180632_j(this.getInitDefaultState());
        ResourceLocation registryName = this.createRegistryName();
        this.setRegistryName(registryName);
        IEContent.registeredIEBlocks.add(this);
        Item item = createItemBlock.apply(this, new Item.Properties().func_200916_a(ImmersiveEngineering.itemGroup));
        if (item != null) {
            item.setRegistryName(registryName);
            IEContent.registeredIEItems.add(item);
        }
        this.lightOpacity = 15;
    }

    public IEBaseBlock setHidden(boolean shouldHide) {
        this.isHidden = shouldHide;
        return this;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public IEBaseBlock setHasFlavour(boolean shouldHave) {
        this.hasFlavour = shouldHave;
        return this;
    }

    @Override
    public String getNameForFlavour() {
        return this.name;
    }

    @Override
    public boolean hasFlavour() {
        return this.hasFlavour;
    }

    public IEBaseBlock setLightOpacity(int opacity) {
        this.lightOpacity = opacity;
        return this;
    }

    public int func_200011_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        if (this.notNormalBlock) {
            return 0;
        }
        if (state.func_200015_d(worldIn, pos)) {
            return this.lightOpacity;
        }
        return state.func_200131_a(worldIn, pos) ? 0 : 1;
    }

    public IEBaseBlock setMobility(PushReaction flag) {
        this.mobilityFlag = flag;
        return this;
    }

    public PushReaction func_149656_h(BlockState state) {
        return this.mobilityFlag;
    }

    public float func_220080_a(BlockState state, IBlockReader world, BlockPos pos) {
        return this.notNormalBlock ? 1.0f : super.func_220080_a(state, world, pos);
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return this.notNormalBlock || super.func_200123_i(state, reader, pos);
    }

    protected BlockState getInitDefaultState() {
        BlockState state = (BlockState)this.field_176227_L.func_177621_b();
        if (state.func_235901_b_((Property)BlockStateProperties.field_208198_y)) {
            state = (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.FALSE);
        }
        return state;
    }

    protected <V extends Comparable<V>> BlockState applyProperty(BlockState in, Property<V> prop, Object val) {
        return (BlockState)in.func_206870_a(prop, (Comparable)val);
    }

    public void onIEBlockPlacedBy(BlockItemUseContext context, BlockState state) {
    }

    public boolean canIEBlockBePlaced(BlockState newState, BlockItemUseContext context) {
        return true;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((IItemProvider)this, 1));
    }

    public boolean func_189539_a(BlockState state, World worldIn, BlockPos pos, int eventID, int eventParam) {
        if (worldIn.field_72995_K && eventID == 255) {
            worldIn.func_184138_a(pos, state, state, 3);
            return true;
        }
        return super.func_189539_a(state, worldIn, pos, eventID, eventParam);
    }

    public IEBaseBlock setHammerHarvest() {
        this.canHammerHarvest = true;
        return this;
    }

    public boolean allowHammerHarvest(BlockState blockState) {
        return this.canHammerHarvest;
    }

    public boolean allowWirecutterHarvest(BlockState blockState) {
        return false;
    }

    public boolean isToolEffective(BlockState state, ToolType tool) {
        if (this.allowHammerHarvest(state) && tool == HammerItem.HAMMER_TOOL) {
            return true;
        }
        if (this.allowWirecutterHarvest(state) && tool == WirecutterItem.CUTTER_TOOL) {
            return true;
        }
        return super.isToolEffective(state, tool);
    }

    public ResourceLocation createRegistryName() {
        return new ResourceLocation("immersiveengineering", this.name);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack activeStack = player.func_184586_b(hand);
        if (activeStack.getToolTypes().contains(HammerItem.HAMMER_TOOL)) {
            return this.hammerUseSide(hit.func_216354_b(), player, hand, world, pos, hit);
        }
        if (activeStack.getToolTypes().contains(ScrewdriverItem.SCREWDRIVER_TOOL)) {
            return this.screwdriverUseSide(hit.func_216354_b(), player, hand, world, pos, hit);
        }
        return super.func_225533_a_(state, world, pos, player, hand, hit);
    }

    public ActionResultType hammerUseSide(Direction side, PlayerEntity player, Hand hand, World w, BlockPos pos, BlockRayTraceResult hit) {
        return ActionResultType.PASS;
    }

    public ActionResultType screwdriverUseSide(Direction side, PlayerEntity player, Hand hand, World w, BlockPos pos, BlockRayTraceResult hit) {
        return ActionResultType.PASS;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public static BlockState applyLocationalWaterlogging(BlockState state, World world, BlockPos pos) {
        if (state.func_235901_b_((Property)BlockStateProperties.field_208198_y)) {
            return (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(world.func_204610_c(pos).func_206886_c() == Fluids.field_204546_a));
        }
        return state;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = this.func_176223_P();
        state = IEBaseBlock.applyLocationalWaterlogging(state, context.func_195991_k(), context.func_195995_a());
        return state;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (stateIn.func_235901_b_((Property)BlockStateProperties.field_208198_y) && ((Boolean)stateIn.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public FluidState func_204507_t(BlockState state) {
        if (state.func_235901_b_((Property)BlockStateProperties.field_208198_y) && ((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
            return Fluids.field_204546_a.func_207204_a(false);
        }
        return super.func_204507_t(state);
    }

    public boolean func_204510_a(IBlockReader worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return state.func_235901_b_((Property)BlockStateProperties.field_208198_y) && super.func_204510_a(worldIn, pos, state, fluidIn);
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        return state.func_235901_b_((Property)BlockStateProperties.field_208198_y) && super.func_204509_a(worldIn, pos, state, fluidStateIn);
    }

    public Fluid func_204508_a(IWorld worldIn, BlockPos pos, BlockState state) {
        if (state.func_235901_b_((Property)BlockStateProperties.field_208198_y)) {
            return super.func_204508_a(worldIn, pos, state);
        }
        return Fluids.field_204541_a;
    }

    public static abstract class IELadderBlock
    extends IEBaseBlock {
        public IELadderBlock(String name, AbstractBlock.Properties material, BiFunction<Block, Item.Properties, Item> itemBlock) {
            super(name, material, itemBlock);
        }

        public boolean isLadder(BlockState state, IWorldReader world, BlockPos pos, LivingEntity entity) {
            return true;
        }

        public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
            super.func_196262_a(state, worldIn, pos, entityIn);
            if (entityIn instanceof LivingEntity && this.isLadder(state, (IWorldReader)worldIn, pos, (LivingEntity)entityIn)) {
                IELadderBlock.applyLadderLogic(entityIn);
            }
        }

        public static void applyLadderLogic(Entity entityIn) {
            if (entityIn instanceof LivingEntity && !((LivingEntity)entityIn).func_70617_f_()) {
                Vector3d motion = entityIn.func_213322_ci();
                float maxMotion = 0.15f;
                motion = new Vector3d(MathHelper.func_151237_a((double)motion.field_72450_a, (double)(-maxMotion), (double)maxMotion), Math.max(motion.field_72448_b, (double)(-maxMotion)), MathHelper.func_151237_a((double)motion.field_72449_c, (double)(-maxMotion), (double)maxMotion));
                entityIn.field_70143_R = 0.0f;
                if (motion.field_72448_b < 0.0 && entityIn instanceof PlayerEntity && entityIn.func_225608_bj_()) {
                    motion = new Vector3d(motion.field_72450_a, 0.0, motion.field_72449_c);
                } else if (entityIn.field_70123_F) {
                    motion = new Vector3d(motion.field_72450_a, 0.2, motion.field_72449_c);
                }
                entityIn.func_213317_d(motion);
            }
        }
    }
}

