/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import blusunrize.immersiveengineering.common.blocks.IEBaseTileEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.DirectionUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.Collection;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class IETileProviderBlock
extends IEBaseBlock
implements IEBlockInterfaces.IColouredBlock {
    private boolean hasColours = false;

    public IETileProviderBlock(String name, AbstractBlock.Properties blockProps, BiFunction<Block, Item.Properties, Item> itemBlock) {
        super(name, blockProps, itemBlock);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Override
    protected BlockState getInitDefaultState() {
        BlockState ret = super.getInitDefaultState();
        if (ret.func_235901_b_((Property)IEProperties.FACING_ALL)) {
            ret = (BlockState)ret.func_206870_a((Property)IEProperties.FACING_ALL, (Comparable)this.getDefaultFacing());
        } else if (ret.func_235901_b_((Property)IEProperties.FACING_HORIZONTAL)) {
            ret = (BlockState)ret.func_206870_a((Property)IEProperties.FACING_HORIZONTAL, (Comparable)this.getDefaultFacing());
        }
        return ret;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tile = world.func_175625_s(pos);
        if (state.func_177230_c() != newState.func_177230_c()) {
            if (tile instanceof IEBaseTileEntity) {
                ((IEBaseTileEntity)tile).setOverrideState(state);
            }
            if (tile instanceof IEBlockInterfaces.IHasDummyBlocks) {
                ((IEBlockInterfaces.IHasDummyBlocks)tile).breakDummies(pos, state);
            }
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    public void func_180657_a(World world, PlayerEntity player, BlockPos pos, BlockState state, TileEntity tile, ItemStack stack) {
        Collection<ItemStack> stacks;
        if (tile instanceof IEBlockInterfaces.IAdditionalDrops && (stacks = ((IEBlockInterfaces.IAdditionalDrops)tile).getExtraDrops(player, state)) != null && !stacks.isEmpty()) {
            for (ItemStack s : stacks) {
                if (s.func_190926_b()) continue;
                IETileProviderBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)s);
            }
        }
        super.func_180657_a(world, player, pos, state, tile, stack);
    }

    public boolean canEntityDestroy(BlockState state, IBlockReader world, BlockPos pos, Entity entity) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IEBlockInterfaces.IEntityProof) {
            return ((IEBlockInterfaces.IEntityProof)tile).canEntityDestroy(entity);
        }
        return super.canEntityDestroy(state, world, pos, entity);
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        ItemStack s;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IEBlockInterfaces.ITileDrop && target instanceof BlockRayTraceResult && !(s = ((IEBlockInterfaces.ITileDrop)tile).getPickBlock(player, world.func_180495_p(pos), target)).func_190926_b()) {
            return s;
        }
        Item item = this.func_199767_j();
        return item == Items.field_190931_a ? ItemStack.field_190927_a : new ItemStack((IItemProvider)item, 1);
    }

    @Override
    public boolean func_189539_a(BlockState state, World worldIn, BlockPos pos, int eventID, int eventParam) {
        super.func_189539_a(state, worldIn, pos, eventID, eventParam);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity != null && tileentity.func_145842_c(eventID, eventParam);
    }

    protected Direction getDefaultFacing() {
        return Direction.NORTH;
    }

    @Override
    public void onIEBlockPlacedBy(BlockItemUseContext context, BlockState state) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        TileEntity tile = world.func_175625_s(pos);
        PlayerEntity placer = context.func_195999_j();
        Direction side = context.func_196000_l();
        float hitX = (float)context.func_221532_j().field_72450_a - (float)pos.func_177958_n();
        float hitY = (float)context.func_221532_j().field_72448_b - (float)pos.func_177956_o();
        float hitZ = (float)context.func_221532_j().field_72449_c - (float)pos.func_177952_p();
        ItemStack stack = context.func_195996_i();
        if (tile instanceof IEBlockInterfaces.IDirectionalTile) {
            Direction f = ((IEBlockInterfaces.IDirectionalTile)tile).getFacingForPlacement((LivingEntity)placer, pos, side, hitX, hitY, hitZ);
            ((IEBlockInterfaces.IDirectionalTile)tile).setFacing(f);
            if (tile instanceof IEBlockInterfaces.IAdvancedDirectionalTile) {
                ((IEBlockInterfaces.IAdvancedDirectionalTile)tile).onDirectionalPlacement(side, hitX, hitY, hitZ, (LivingEntity)placer);
            }
        }
        if (tile instanceof IEBlockInterfaces.IReadOnPlacement) {
            ((IEBlockInterfaces.IReadOnPlacement)tile).readOnPlacement((LivingEntity)placer, stack);
        }
        if (tile instanceof IEBlockInterfaces.IHasDummyBlocks) {
            ((IEBlockInterfaces.IHasDummyBlocks)tile).placeDummies(context, state);
        }
        if (tile instanceof IEBlockInterfaces.IPlacementInteraction) {
            ((IEBlockInterfaces.IPlacementInteraction)tile).onTilePlaced(world, pos, state, side, hitX, hitY, hitZ, (LivingEntity)placer, stack);
        }
    }

    @Override
    public ActionResultType hammerUseSide(Direction side, PlayerEntity player, Hand hand, World w, BlockPos pos, BlockRayTraceResult hit) {
        TileEntity tile = w.func_175625_s(pos);
        if (tile instanceof IEBlockInterfaces.IHammerInteraction) {
            boolean b = ((IEBlockInterfaces.IHammerInteraction)tile).hammerUseSide(side, player, hand, hit.func_216347_e());
            if (b) {
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.FAIL;
        }
        return super.hammerUseSide(side, player, hand, w, pos, hit);
    }

    @Override
    public ActionResultType screwdriverUseSide(Direction side, PlayerEntity player, Hand hand, World w, BlockPos pos, BlockRayTraceResult hit) {
        ActionResultType teResult;
        TileEntity tile = w.func_175625_s(pos);
        if (tile instanceof IEBlockInterfaces.IScrewdriverInteraction && (teResult = ((IEBlockInterfaces.IScrewdriverInteraction)tile).screwdriverUseSide(side, player, hand, hit.func_216347_e())) != ActionResultType.PASS) {
            return teResult;
        }
        return super.screwdriverUseSide(side, player, hand, w, pos, hit);
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        boolean b;
        ActionResultType superResult = super.func_225533_a_(state, world, pos, player, hand, hit);
        if (superResult.func_226246_a_()) {
            return superResult;
        }
        Direction side = hit.func_216354_b();
        float hitX = (float)hit.func_216347_e().field_72450_a - (float)pos.func_177958_n();
        float hitY = (float)hit.func_216347_e().field_72448_b - (float)pos.func_177956_o();
        float hitZ = (float)hit.func_216347_e().field_72449_c - (float)pos.func_177952_p();
        ItemStack heldItem = player.func_184586_b(hand);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IEBlockInterfaces.IDirectionalTile && Utils.isHammer(heldItem) && ((IEBlockInterfaces.IDirectionalTile)tile).canHammerRotate(side, hit.func_216347_e().func_178788_d(Vector3d.func_237491_b_((Vector3i)pos)), (LivingEntity)player) && !world.field_72995_K) {
            Direction f;
            Direction oldF = f = ((IEBlockInterfaces.IDirectionalTile)tile).getFacing();
            IEBlockInterfaces.IDirectionalTile.PlacementLimitation limit = ((IEBlockInterfaces.IDirectionalTile)tile).getFacingLimitation();
            switch (limit) {
                case SIDE_CLICKED: {
                    f = DirectionUtils.VALUES[Math.floorMod(f.ordinal() + (player.func_225608_bj_() ? -1 : 1), DirectionUtils.VALUES.length)];
                    break;
                }
                case PISTON_LIKE: {
                    f = player.func_225608_bj_() != (side.func_176743_c() == Direction.AxisDirection.NEGATIVE) ? DirectionUtils.rotateAround(f, side.func_176740_k()).func_176734_d() : DirectionUtils.rotateAround(f, side.func_176740_k());
                    break;
                }
                case HORIZONTAL: 
                case HORIZONTAL_PREFER_SIDE: 
                case HORIZONTAL_QUADRANT: 
                case HORIZONTAL_AXIS: {
                    f = player.func_225608_bj_() != side.equals((Object)Direction.DOWN) ? f.func_176735_f() : f.func_176746_e();
                }
            }
            ((IEBlockInterfaces.IDirectionalTile)tile).setFacing(f);
            ((IEBlockInterfaces.IDirectionalTile)tile).afterRotation(oldF, f);
            tile.func_70296_d();
            world.func_184138_a(pos, state, state, 3);
            world.func_175641_c(tile.func_174877_v(), tile.func_195044_w().func_177230_c(), 255, 0);
            return ActionResultType.SUCCESS;
        }
        if (tile instanceof IEBlockInterfaces.IPlayerInteraction && (b = ((IEBlockInterfaces.IPlayerInteraction)tile).interact(side, player, hand, heldItem, hitX, hitY, hitZ))) {
            return ActionResultType.SUCCESS;
        }
        if (tile instanceof IEBlockInterfaces.IInteractionObjectIE && hand == Hand.MAIN_HAND && !player.func_225608_bj_()) {
            IEBlockInterfaces.IInteractionObjectIE interaction = (IEBlockInterfaces.IInteractionObjectIE)tile;
            if ((interaction = interaction.getGuiMaster()) != null && interaction.canUseGui(player) && !world.field_72995_K) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)interaction, (BlockPos)((TileEntity)interaction).func_174877_v());
            }
            return ActionResultType.SUCCESS;
        }
        return superResult;
    }

    @Nullable
    private Property<Direction> findFacingProperty(BlockState state) {
        if (state.func_235901_b_((Property)IEProperties.FACING_ALL)) {
            return IEProperties.FACING_ALL;
        }
        if (state.func_235901_b_((Property)IEProperties.FACING_HORIZONTAL)) {
            return IEProperties.FACING_HORIZONTAL;
        }
        return null;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        Property<Direction> facingProp = this.findFacingProperty(state);
        if (facingProp != null && this.canRotate()) {
            Direction currentDirection = (Direction)state.func_177229_b(facingProp);
            Direction newDirection = rot.func_185831_a(currentDirection);
            return (BlockState)state.func_206870_a(facingProp, (Comparable)newDirection);
        }
        return super.func_185499_a(state, rot);
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        if (state.func_235901_b_((Property)IEProperties.MIRRORED) && this.canRotate() && mirrorIn == Mirror.LEFT_RIGHT) {
            return (BlockState)state.func_206870_a((Property)IEProperties.MIRRORED, (Comparable)Boolean.valueOf((Boolean)state.func_177229_b((Property)IEProperties.MIRRORED) == false));
        }
        Property<Direction> facingProp = this.findFacingProperty(state);
        if (facingProp != null && this.canRotate()) {
            Direction currentDirection = (Direction)state.func_177229_b(facingProp);
            Direction newDirection = mirrorIn.func_185803_b(currentDirection);
            return (BlockState)state.func_206870_a(facingProp, (Comparable)newDirection);
        }
        return super.func_185471_a(state, mirrorIn);
    }

    protected boolean canRotate() {
        return !this.func_176194_O().func_177623_d().contains((Object)IEProperties.MULTIBLOCKSLAVE);
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        TileEntity tile;
        if (!world.field_72995_K && (tile = world.func_175625_s(pos)) instanceof IEBaseTileEntity) {
            ((IEBaseTileEntity)tile).onNeighborBlockChange(fromPos);
        }
    }

    public IETileProviderBlock setHasColours() {
        this.hasColours = true;
        return this;
    }

    @Override
    public boolean hasCustomBlockColours() {
        return this.hasColours;
    }

    @Override
    public int getRenderColour(BlockState state, @Nullable IBlockReader worldIn, @Nullable BlockPos pos, int tintIndex) {
        TileEntity tile;
        if (worldIn != null && pos != null && (tile = worldIn.func_175625_s(pos)) instanceof IEBlockInterfaces.IColouredTile) {
            return ((IEBlockInterfaces.IColouredTile)tile).getRenderColour(tintIndex);
        }
        return 0xFFFFFF;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        TileEntity te;
        if (state.func_177230_c() == this && (te = world.func_175625_s(pos)) instanceof IEBlockInterfaces.ISelectionBounds) {
            return ((IEBlockInterfaces.ISelectionBounds)te).getSelectionShape(context);
        }
        return super.func_220053_a(state, world, pos, context);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        TileEntity te;
        if (state.func_177230_c() == this && (te = world.func_175625_s(pos)) instanceof IEBlockInterfaces.ICollisionBounds) {
            return ((IEBlockInterfaces.ICollisionBounds)te).getCollisionShape(context);
        }
        return super.func_220071_b(state, world, pos, context);
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader world, BlockPos pos) {
        TileEntity te;
        if (world.func_180495_p(pos).func_177230_c() == this && (te = world.func_175625_s(pos)) instanceof IEBlockInterfaces.ISelectionBounds) {
            return ((IEBlockInterfaces.ISelectionBounds)te).getSelectionShape(null);
        }
        return super.func_199600_g(state, world, pos);
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IEBlockInterfaces.IComparatorOverride) {
            return ((IEBlockInterfaces.IComparatorOverride)te).getComparatorInputOverride();
        }
        return 0;
    }

    public int func_180656_a(BlockState blockState, IBlockReader world, BlockPos pos, Direction side) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IEBlockInterfaces.IRedstoneOutput) {
            return ((IEBlockInterfaces.IRedstoneOutput)te).getWeakRSOutput(side);
        }
        return 0;
    }

    public int func_176211_b(BlockState blockState, IBlockReader world, BlockPos pos, Direction side) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IEBlockInterfaces.IRedstoneOutput) {
            return ((IEBlockInterfaces.IRedstoneOutput)te).getStrongRSOutput(side);
        }
        return 0;
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IEBlockInterfaces.IRedstoneOutput) {
            return ((IEBlockInterfaces.IRedstoneOutput)te).canConnectRedstone(side);
        }
        return false;
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IEBaseTileEntity) {
            ((IEBaseTileEntity)te).onEntityCollision(world, entity);
        }
    }

    public static boolean areAllReplaceable(BlockPos start, BlockPos end, BlockItemUseContext context) {
        World w = context.func_195991_k();
        return BlockPos.func_218281_b((BlockPos)start, (BlockPos)end).allMatch(pos -> {
            BlockItemUseContext subContext = BlockItemUseContext.func_221536_a((BlockItemUseContext)context, (BlockPos)pos, (Direction)context.func_196000_l());
            return w.func_180495_p(pos).func_196953_a(subContext);
        });
    }
}

