/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.generic;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.client.IModelOffsetProvider;
import blusunrize.immersiveengineering.api.multiblocks.TemplateMultiblock;
import blusunrize.immersiveengineering.api.utils.SafeChunkUtils;
import blusunrize.immersiveengineering.api.utils.shapes.CachedShapesWithTransform;
import blusunrize.immersiveengineering.common.blocks.IEBaseTileEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IETemplateMultiblock;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.common.util.DirectionUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.ComputerControlState;
import java.util.EnumMap;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.tuple.Pair;

public abstract class MultiblockPartTileEntity<T extends MultiblockPartTileEntity<T>>
extends IEBaseTileEntity
implements ITickableTileEntity,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IGeneralMultiblock,
IEBlockInterfaces.IScrewdriverInteraction,
IEBlockInterfaces.IMirrorAble,
IModelOffsetProvider {
    public boolean formed = false;
    public BlockPos posInMultiblock = BlockPos.field_177992_a;
    public BlockPos offsetToMaster = BlockPos.field_177992_a;
    protected final IETemplateMultiblock multiblockInstance;
    public long onlyLocalDissassembly = -1L;
    protected final Lazy<Vector3i> structureDimensions;
    protected final boolean hasRedstoneControl;
    protected boolean redstoneControlInverted = false;
    public ComputerControlState computerControl = ComputerControlState.NO_COMPUTER;
    private EnumMap<Direction, LazyOptional<IFluidHandler>> fluidCaps = new EnumMap(Direction.class);

    protected MultiblockPartTileEntity(IETemplateMultiblock multiblockInstance, TileEntityType<? extends T> type, boolean hasRSControl) {
        super(type);
        for (Direction f : DirectionUtils.VALUES) {
            LazyOptional<MultiblockFluidWrapper> forSide = this.registerConstantCap(new MultiblockFluidWrapper(this, f));
            this.fluidCaps.put(f, forSide);
        }
        this.multiblockInstance = multiblockInstance;
        this.structureDimensions = Lazy.of(() -> multiblockInstance.getSize(this.field_145850_b));
        this.hasRedstoneControl = hasRSControl;
    }

    @Override
    @Nonnull
    public Direction getFacing() {
        return IEBlockInterfaces.IStateBasedDirectional.super.getFacing();
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    public IEBlockInterfaces.IDirectionalTile.PlacementLimitation getFacingLimitation() {
        return IEBlockInterfaces.IDirectionalTile.PlacementLimitation.HORIZONTAL;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return false;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vector3d hit, LivingEntity entity) {
        return false;
    }

    @Override
    public boolean canRotate(Direction axis) {
        return false;
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        this.formed = nbt.func_74767_n("formed");
        this.posInMultiblock = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("posInMultiblock"));
        this.offsetToMaster = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("offset"));
        this.redstoneControlInverted = nbt.func_74767_n("redstoneControlInverted");
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        nbt.func_74757_a("formed", this.formed);
        nbt.func_218657_a("posInMultiblock", (INBT)NBTUtil.func_186859_a((BlockPos)new BlockPos((Vector3i)this.posInMultiblock)));
        nbt.func_218657_a("offset", (INBT)NBTUtil.func_186859_a((BlockPos)new BlockPos((Vector3i)this.offsetToMaster)));
        nbt.func_74757_a("redstoneControlInverted", this.redstoneControlInverted);
    }

    @Nonnull
    public <C> LazyOptional<C> getCapability(@Nonnull Capability<C> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing != null && this.getAccessibleFluidTanks(facing).length > 0) {
            return this.fluidCaps.get(facing).cast();
        }
        return super.getCapability(capability, facing);
    }

    @Nonnull
    protected abstract IFluidTank[] getAccessibleFluidTanks(Direction var1);

    protected abstract boolean canFillTankFrom(int var1, Direction var2, FluidStack var3);

    protected abstract boolean canDrainTankFrom(int var1, Direction var2);

    public static boolean _Immovable() {
        return true;
    }

    @Nullable
    public T master() {
        if (this.offsetToMaster.equals((Object)Vector3i.field_177959_e)) {
            return (T)this;
        }
        if (this.tempMasterTE != null) {
            return (T)((MultiblockPartTileEntity)this.tempMasterTE);
        }
        BlockPos masterPos = this.func_174877_v().func_177973_b((Vector3i)this.offsetToMaster);
        TileEntity te = Utils.getExistingTileEntity(this.field_145850_b, masterPos);
        return (T)(this.getClass().isInstance(te) ? (MultiblockPartTileEntity)te : null);
    }

    public void updateMasterBlock(BlockState state, boolean blockUpdate) {
        IEBlockInterfaces.IGeneralMultiblock master = this.master();
        if (master != null) {
            master.func_70296_d();
            if (blockUpdate) {
                ((IEBaseTileEntity)((Object)master)).markContainingBlockForUpdate(state);
            }
        }
    }

    @Override
    public boolean isDummy() {
        return !this.offsetToMaster.equals((Object)Vector3i.field_177959_e);
    }

    public BlockState getOriginalBlock() {
        for (Template.BlockInfo block : this.multiblockInstance.getStructure(this.field_145850_b)) {
            if (!block.field_186242_a.equals((Object)this.posInMultiblock)) continue;
            return block.field_186243_b;
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public void disassemble() {
        if (this.formed && !this.field_145850_b.field_72995_K) {
            this.tempMasterTE = this.master();
            BlockPos startPos = this.getOrigin();
            this.multiblockInstance.disassemble(this.field_145850_b, startPos, this.getIsMirrored(), this.multiblockInstance.untransformDirection(this.getFacing()));
            this.field_145850_b.func_217377_a(this.field_174879_c, false);
        }
    }

    public BlockPos getOrigin() {
        return TemplateMultiblock.withSettingsAndOffset(this.field_174879_c, BlockPos.field_177992_a.func_177973_b((Vector3i)this.posInMultiblock), this.getIsMirrored(), this.multiblockInstance.untransformDirection(this.getFacing()));
    }

    public BlockPos getBlockPosForPos(BlockPos targetPos) {
        BlockPos origin = this.getOrigin();
        return TemplateMultiblock.withSettingsAndOffset(origin, targetPos, this.getIsMirrored(), this.multiblockInstance.untransformDirection(this.getFacing()));
    }

    public void replaceStructureBlock(BlockPos pos, BlockState state, ItemStack stack, int h, int l, int w) {
        if (state.func_177230_c() == this.func_195044_w().func_177230_c()) {
            this.getWorldNonnull().func_217377_a(pos, false);
        }
        this.getWorldNonnull().func_175656_a(pos, state);
        TileEntity tile = this.getWorldNonnull().func_175625_s(pos);
        if (tile instanceof IEBlockInterfaces.IReadOnPlacement) {
            ((IEBlockInterfaces.IReadOnPlacement)tile).readOnPlacement(null, stack);
        }
    }

    public Set<BlockPos> getRedstonePos() {
        throw new UnsupportedOperationException("Tried to get RS position for a multiblock without RS control!");
    }

    public boolean isRedstonePos() {
        if (!this.hasRedstoneControl || this.getRedstonePos() == null) {
            return false;
        }
        for (BlockPos i : this.getRedstonePos()) {
            if (!this.posInMultiblock.equals((Object)i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ActionResultType screwdriverUseSide(Direction side, PlayerEntity player, Hand hand, Vector3d hitVec) {
        if (this.isRedstonePos() && this.hasRedstoneControl) {
            IEBlockInterfaces.IGeneralMultiblock master;
            if (!this.field_145850_b.field_72995_K && (master = this.master()) != null) {
                ((MultiblockPartTileEntity)master).redstoneControlInverted = !((MultiblockPartTileEntity)master).redstoneControlInverted;
                ChatUtils.sendServerNoSpamMessages(player, new ITextComponent[]{new TranslationTextComponent("chat.immersiveengineering.info.rsControl." + (((MultiblockPartTileEntity)master).redstoneControlInverted ? "invertedOn" : "invertedOff"))});
                this.updateMasterBlock(null, true);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public boolean isRSDisabled() {
        Set<BlockPos> rsPositions = this.getRedstonePos();
        if (rsPositions == null || rsPositions.isEmpty()) {
            return false;
        }
        IEBlockInterfaces.IGeneralMultiblock master = this.master();
        if (master == null) {
            master = this;
        }
        if (((MultiblockPartTileEntity)master).computerControl.isStillAttached()) {
            return !((MultiblockPartTileEntity)master).computerControl.isEnabled();
        }
        ((MultiblockPartTileEntity)master).computerControl = ComputerControlState.NO_COMPUTER;
        for (BlockPos rsPos : rsPositions) {
            boolean b;
            T tile = this.getTileForPos(rsPos);
            if (tile == null || this.redstoneControlInverted == (b = ((IEBaseTileEntity)tile).isRSPowered())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public T getTileForPos(BlockPos targetPosInMB) {
        BlockPos target = this.getBlockPosForPos(targetPosInMB);
        TileEntity tile = SafeChunkUtils.getSafeTE((IWorld)this.getWorldNonnull(), target);
        if (this.getClass().isInstance(tile)) {
            return (T)((MultiblockPartTileEntity)tile);
        }
        return null;
    }

    @Override
    @Nonnull
    public BlockPos getModelOffset(BlockState state, @Nullable Vector3i size) {
        BlockPos mirroredPosInMB = this.posInMultiblock;
        if (size == null) {
            size = this.multiblockInstance.getSize(this.field_145850_b);
        }
        if (this.getIsMirrored()) {
            mirroredPosInMB = new BlockPos(size.func_177958_n() - mirroredPosInMB.func_177958_n() - 1, mirroredPosInMB.func_177956_o(), mirroredPosInMB.func_177952_p());
        }
        return this.multiblockInstance.multiblockToModelPos(mirroredPosInMB);
    }

    public VoxelShape getShape(CachedShapesWithTransform<BlockPos, Pair<Direction, Boolean>> cache) {
        return cache.get(this.posInMultiblock, (Pair<Direction, Boolean>)Pair.of((Object)this.getFacing(), (Object)this.getIsMirrored()));
    }

    public static class MultiblockFluidWrapper
    implements IFluidHandler {
        final MultiblockPartTileEntity multiblock;
        final Direction side;

        public MultiblockFluidWrapper(MultiblockPartTileEntity multiblock, Direction side) {
            this.multiblock = multiblock;
            this.side = side;
        }

        public int getTanks() {
            return this.multiblock.getAccessibleFluidTanks(this.side).length;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return this.multiblock.getAccessibleFluidTanks(this.side)[tank].getFluid();
        }

        public int getTankCapacity(int tank) {
            return this.multiblock.getAccessibleFluidTanks(this.side)[tank].getCapacity();
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return this.multiblock.getAccessibleFluidTanks(this.side)[tank].isFluidValid(stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
            IFluidTank tank;
            int i;
            if (!this.multiblock.formed || resource == null) {
                return 0;
            }
            IFluidTank[] tanks = this.multiblock.getAccessibleFluidTanks(this.side);
            int fill = -1;
            for (i = 0; !(i >= tanks.length || (tank = tanks[i]) != null && this.multiblock.canFillTankFrom(i, this.side, resource) && tank.getFluid() != null && tank.getFluid().isFluidEqual(resource) && (fill = tank.fill(resource, doFill)) > 0); ++i) {
            }
            if (fill == -1) {
                for (i = 0; !(i >= tanks.length || (tank = tanks[i]) != null && this.multiblock.canFillTankFrom(i, this.side, resource) && (fill = tank.fill(resource, doFill)) > 0); ++i) {
                }
            }
            if (fill > 0) {
                this.multiblock.updateMasterBlock(null, true);
            }
            return Math.max(fill, 0);
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
            IFluidTank tank;
            if (!this.multiblock.formed || resource == null) {
                return FluidStack.EMPTY;
            }
            IFluidTank[] tanks = this.multiblock.getAccessibleFluidTanks(this.side);
            FluidStack drain = FluidStack.EMPTY;
            for (int i = 0; i < tanks.length && ((tank = tanks[i]) == null || !this.multiblock.canDrainTankFrom(i, this.side) || (drain = tank instanceof IFluidHandler ? ((IFluidHandler)tank).drain(resource, doDrain) : tank.drain(resource.getAmount(), doDrain)).isEmpty()); ++i) {
            }
            if (!drain.isEmpty()) {
                this.multiblock.updateMasterBlock(null, true);
            }
            return drain;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
            IFluidTank tank;
            if (!this.multiblock.formed || maxDrain == 0) {
                return FluidStack.EMPTY;
            }
            IFluidTank[] tanks = this.multiblock.getAccessibleFluidTanks(this.side);
            FluidStack drain = FluidStack.EMPTY;
            for (int i = 0; i < tanks.length && ((tank = tanks[i]) == null || !this.multiblock.canDrainTankFrom(i, this.side) || (drain = tank.drain(maxDrain, doDrain)).isEmpty()); ++i) {
            }
            if (!drain.isEmpty()) {
                this.multiblock.updateMasterBlock(null, true);
            }
            return drain;
        }
    }
}

