/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.generic;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.IPostBlock;
import blusunrize.immersiveengineering.api.client.IModelOffsetProvider;
import blusunrize.immersiveengineering.api.utils.client.SinglePropertyModelData;
import blusunrize.immersiveengineering.common.blocks.BlockItemIE;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.DirectionUtils;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.loot.LootContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.IModelData;

public class PostBlock
extends IEBaseBlock
implements IEBlockInterfaces.IModelDataBlock,
IPostBlock,
IModelOffsetProvider {
    public static final IntegerProperty POST_SLAVE = IntegerProperty.func_177719_a((String)"post_slave", (int)0, (int)3);
    public static final EnumProperty<HorizontalOffset> HORIZONTAL_OFFSET = EnumProperty.func_177709_a((String)"horizontal_offset", HorizontalOffset.class);
    ThreadLocal<Boolean> recursionLock = new ThreadLocal();

    public PostBlock(String name, AbstractBlock.Properties blockProps) {
        super(name, blockProps, BlockItemIE::new);
        this.setMobility(PushReaction.BLOCK);
        this.lightOpacity = 0;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{POST_SLAVE, HORIZONTAL_OFFSET, BlockStateProperties.field_208198_y});
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        return ImmutableList.of();
    }

    public void func_196243_a(@Nonnull BlockState state, World world, @Nonnull BlockPos pos, BlockState newState, boolean moving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            int dummyState = (Integer)state.func_177229_b((Property)POST_SLAVE);
            HorizontalOffset offset = (HorizontalOffset)((Object)state.func_177229_b(HORIZONTAL_OFFSET));
            if (dummyState > 0 && offset == HorizontalOffset.NONE) {
                world.func_175656_a(pos.func_177979_c(dummyState), Blocks.field_150350_a.func_176223_P());
            } else if (dummyState == 0) {
                PostBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)this));
                int highestBlock = 3;
                BlockPos armStart = pos.func_177981_b(3);
                for (Direction d : DirectionUtils.BY_HORIZONTAL_INDEX) {
                    BlockPos armPos = armStart.func_177972_a(d);
                    BlockState armState = world.func_180495_p(armPos);
                    if (armState.func_177230_c() != this || !((HorizontalOffset)((Object)armState.func_177229_b(HORIZONTAL_OFFSET))).getOffset().equals((Object)d.func_176730_m())) continue;
                    world.func_175656_a(armPos, Blocks.field_150350_a.func_176223_P());
                }
                for (int i = 0; i <= 3; ++i) {
                    world.func_175656_a(pos.func_177981_b(i), Blocks.field_150350_a.func_176223_P());
                }
            }
        }
        super.func_196243_a(state, world, pos, newState, moving);
    }

    @Override
    public boolean canIEBlockBePlaced(@Nonnull BlockState newState, BlockItemUseContext context) {
        BlockPos startingPos = context.func_195995_a();
        World world = context.func_195991_k();
        for (int hh = 1; hh <= 3; ++hh) {
            BlockPos pos = startingPos.func_177981_b(hh);
            BlockItemUseContext dummyContext = BlockItemUseContext.func_221536_a((BlockItemUseContext)context, (BlockPos)pos, (Direction)context.func_196000_l());
            BlockState oldState = world.func_180495_p(pos);
            if (!World.func_189509_E((BlockPos)pos) && oldState.func_177230_c().func_196253_a(oldState, dummyContext)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onIEBlockPlacedBy(BlockItemUseContext context, BlockState state) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        for (int i = 1; i <= 3; ++i) {
            BlockPos dummyPos = pos.func_177981_b(i);
            world.func_175656_a(dummyPos, IEBaseBlock.applyLocationalWaterlogging((BlockState)state.func_206870_a((Property)POST_SLAVE, (Comparable)Integer.valueOf(i)), world, dummyPos));
            world.func_175641_c(pos.func_177982_a(0, i, 0), (Block)this, 255, 0);
        }
    }

    public boolean isLadder(BlockState state, IWorldReader world, BlockPos pos, LivingEntity entity) {
        return true;
    }

    private boolean hasArmFor(BlockPos center, Direction side, IBlockReader world) {
        int highest = 3;
        BlockState centerState = world.func_180495_p(center);
        if (centerState.func_177230_c() != this || (Integer)centerState.func_177229_b((Property)POST_SLAVE) != 3 || centerState.func_177229_b(HORIZONTAL_OFFSET) != HorizontalOffset.NONE) {
            return false;
        }
        BlockState armState = world.func_180495_p(center.func_177972_a(side));
        return armState.func_177230_c() == this && (Integer)armState.func_177229_b((Property)POST_SLAVE) == 3 && ((HorizontalOffset)((Object)armState.func_177229_b(HORIZONTAL_OFFSET))).getOffset().equals((Object)side.func_176730_m());
    }

    @Override
    public ActionResultType hammerUseSide(Direction side, PlayerEntity player, Hand hand, World world, BlockPos pos, BlockRayTraceResult hit) {
        BlockState state = world.func_180495_p(pos);
        int dummy = (Integer)state.func_177229_b((Property)POST_SLAVE);
        HorizontalOffset offset = (HorizontalOffset)((Object)state.func_177229_b(HORIZONTAL_OFFSET));
        boolean changed = false;
        if (dummy == 3 && offset == HorizontalOffset.NONE && side.func_176740_k() != Direction.Axis.Y) {
            BlockPos offsetPos = pos.func_177972_a(side);
            BlockItemUseContext context = new BlockItemUseContext(new ItemUseContext(player, hand, hit));
            if (!world.func_180495_p(offsetPos).func_196953_a(context)) {
                return ActionResultType.FAIL;
            }
            for (Direction forbidden : ImmutableList.of((Object)side.func_176746_e(), (Object)side.func_176735_f())) {
                if (!this.hasArmFor(pos, forbidden, (IBlockReader)world)) continue;
                return ActionResultType.FAIL;
            }
            BlockState arm_state = (BlockState)((BlockState)this.func_196258_a(context).func_206870_a((Property)POST_SLAVE, (Comparable)Integer.valueOf(3))).func_206870_a(HORIZONTAL_OFFSET, (Comparable)((Object)HorizontalOffset.get(side)));
            world.func_175656_a(offsetPos, arm_state);
            changed = true;
        } else if (dummy == 3 && offset != HorizontalOffset.NONE) {
            world.func_217377_a(pos, false);
            changed = true;
        }
        if (changed) {
            BlockPos masterPos = pos.func_177979_c(dummy).func_177973_b(offset.getOffset());
            BlockState masterState = world.func_180495_p(masterPos);
            world.func_184138_a(masterPos, masterState, masterState, 3);
            return ActionResultType.SUCCESS;
        }
        return super.hammerUseSide(side, player, hand, world, pos, hit);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197882_b((VoxelShape)this.getMainShape(state, worldIn, pos), (VoxelShape)this.getConnectionShapes(state, worldIn, pos), (IBooleanFunction)IBooleanFunction.field_223244_o_);
    }

    private VoxelShape getMainShape(BlockState state, IBlockReader world, BlockPos pos) {
        int dummy = (Integer)state.func_177229_b((Property)POST_SLAVE);
        if (dummy == 0) {
            return VoxelShapes.func_197873_a((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)1.0, (double)0.75);
        }
        if (dummy <= 2) {
            return VoxelShapes.func_197873_a((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)1.0, (double)0.6875);
        }
        if (dummy == 3) {
            float down = this.hasConnection(state, Direction.DOWN, world, pos) ? 0.0f : 0.4375f;
            float up = down > 0.0f ? 1.0f : 0.5625f;
            switch ((HorizontalOffset)((Object)state.func_177229_b(HORIZONTAL_OFFSET))) {
                case NONE: {
                    return VoxelShapes.func_197873_a((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)1.0, (double)0.6875);
                }
                case NORTH: {
                    return VoxelShapes.func_197873_a((double)0.3125, (double)down, (double)0.3125, (double)0.6875, (double)up, (double)1.0);
                }
                case SOUTH: {
                    return VoxelShapes.func_197873_a((double)0.3125, (double)down, (double)0.0, (double)0.6875, (double)up, (double)0.6875);
                }
                case EAST: {
                    return VoxelShapes.func_197873_a((double)0.0, (double)down, (double)0.3125, (double)0.6875, (double)up, (double)0.6875);
                }
                case WEST: {
                    return VoxelShapes.func_197873_a((double)0.3125, (double)down, (double)0.3125, (double)1.0, (double)up, (double)0.6875);
                }
            }
        }
        return VoxelShapes.func_197868_b();
    }

    private VoxelShape getConnectionShapes(BlockState state, IBlockReader world, BlockPos pos) {
        HorizontalOffset offset = (HorizontalOffset)((Object)state.func_177229_b(HORIZONTAL_OFFSET));
        if (offset == HorizontalOffset.NONE) {
            int dummy = (Integer)state.func_177229_b((Property)POST_SLAVE);
            if (dummy == 0) {
                return VoxelShapes.func_197880_a();
            }
            double baseWidth = dummy == 3 ? 0.375 : 0.25;
            VoxelShape ret = VoxelShapes.func_197880_a();
            for (Direction neighbor : DirectionUtils.BY_HORIZONTAL_INDEX) {
                double maxY;
                double minY;
                if (!this.hasConnection(state, neighbor, world, pos)) continue;
                if (dummy < 3) {
                    minY = 0.25;
                    maxY = 0.8125;
                } else {
                    BlockPos neighborPos = pos.func_177972_a(neighbor);
                    BlockState neighborState = world.func_180495_p(neighborPos);
                    if (this.hasConnection(neighborState, Direction.DOWN, world, neighborPos)) {
                        minY = 0.0;
                        maxY = 0.5625;
                    } else {
                        minY = 0.4375;
                        maxY = 1.0;
                    }
                }
                double[] horizontalBounds = new double[]{(1.0 - baseWidth) / 2.0, (1.0 + baseWidth) / 2.0, (1.0 - baseWidth) / 2.0, (1.0 + baseWidth) / 2.0};
                int minIndex = neighbor.func_176740_k() == Direction.Axis.X ? 0 : 2;
                int maxIndex = minIndex + 1;
                if (neighbor.func_176743_c() == Direction.AxisDirection.POSITIVE) {
                    horizontalBounds[minIndex] = horizontalBounds[maxIndex];
                    horizontalBounds[maxIndex] = 1.0;
                } else {
                    horizontalBounds[maxIndex] = horizontalBounds[minIndex];
                    horizontalBounds[minIndex] = 0.0;
                }
                VoxelShape sideShape = VoxelShapes.func_197873_a((double)horizontalBounds[0], (double)minY, (double)horizontalBounds[2], (double)horizontalBounds[1], (double)maxY, (double)horizontalBounds[3]);
                ret = VoxelShapes.func_197882_b((VoxelShape)ret, (VoxelShape)sideShape, (IBooleanFunction)IBooleanFunction.field_223244_o_);
            }
            return ret;
        }
        return VoxelShapes.func_197880_a();
    }

    public boolean hasConnection(BlockState stateHere, Direction dir, IBlockReader world, BlockPos pos) {
        if (this.recursionLock.get() != null && this.recursionLock.get().booleanValue()) {
            return true;
        }
        this.recursionLock.set(true);
        BlockPos neighborPos = pos.func_177972_a(dir);
        int dummy = (Integer)stateHere.func_177229_b((Property)POST_SLAVE);
        boolean ret = false;
        if (dummy > 0 && dummy < 3) {
            BlockState neighborState = world.func_180495_p(neighborPos);
            VoxelShape shape = neighborState.func_196954_c(world, neighborPos);
            if (!shape.func_197766_b()) {
                boolean connect;
                AxisAlignedBB aabb = shape.func_197752_a();
                double distance = dir == Direction.NORTH ? aabb.field_72334_f - 1.0 : (dir == Direction.SOUTH ? aabb.field_72339_c : (dir == Direction.WEST ? aabb.field_72336_d - 1.0 : aabb.field_72340_a));
                double eps = 1.0E-7;
                boolean bl = connect = distance < 1.0E-7 && distance > -1.0E-7;
                if (connect) {
                    ret = dir.func_176740_k() == Direction.Axis.Z ? aabb.field_72340_a > 1.0E-7 && aabb.field_72336_d < 0.9999999 : aabb.field_72339_c > 1.0E-7 && aabb.field_72334_f < 0.9999999;
                }
            }
        } else if (dummy == 3) {
            HorizontalOffset offset = (HorizontalOffset)((Object)stateHere.func_177229_b(HORIZONTAL_OFFSET));
            if (offset == HorizontalOffset.NONE) {
                ret = this.hasArmFor(pos, dir, world);
            } else if (world.func_180495_p(neighborPos).isAir(world, neighborPos) || dir.func_176740_k() != Direction.Axis.Y) {
                ret = false;
            } else {
                BlockState neighborState = world.func_180495_p(neighborPos);
                if (neighborState.func_185904_a().func_76222_j()) {
                    ret = false;
                } else {
                    VoxelShape shape = neighborState.func_196954_c(world, neighborPos);
                    ret = this.shapeReachesBlockFace(shape, dir.func_176734_d());
                }
            }
        }
        this.recursionLock.set(false);
        return ret;
    }

    private boolean shapeReachesBlockFace(VoxelShape shape, Direction face) {
        if (face.func_176743_c() == Direction.AxisDirection.POSITIVE) {
            return shape.func_197758_c(face.func_176740_k()) == 1.0;
        }
        return shape.func_197762_b(face.func_176740_k()) == 0.0;
    }

    @Override
    @Nonnull
    public IModelData getModelData(@Nonnull IBlockDisplayReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        ArrayList<String> visible = new ArrayList<String>();
        visible.add("base");
        int height = (Integer)state.func_177229_b((Property)POST_SLAVE);
        BlockPos centerPos = pos.func_177973_b(((HorizontalOffset)((Object)state.func_177229_b(HORIZONTAL_OFFSET))).getOffset());
        BlockState centerState = world.func_180495_p(centerPos);
        if (centerState.func_177230_c() == this) {
            for (Direction f : DirectionUtils.BY_HORIZONTAL_INDEX) {
                if (!this.hasConnection(centerState, f, (IBlockReader)world, centerPos)) continue;
                String name = f.func_176734_d().func_176610_l();
                if (height == 3) {
                    BlockPos armPos = centerPos.func_177972_a(f);
                    boolean down = this.hasConnection(world.func_180495_p(armPos), Direction.DOWN, (IBlockReader)world, armPos);
                    if (down) {
                        visible.add("arm_" + name + "_down");
                        continue;
                    }
                    visible.add("arm_" + name + "_up");
                    continue;
                }
                visible.add("con_" + (height - 1) + "_" + name);
            }
        }
        IEProperties.IEObjState modelState = new IEProperties.IEObjState(IEProperties.VisibilityList.show(visible));
        return new SinglePropertyModelData<IEProperties.IEObjState>(modelState, IEProperties.Model.IE_OBJ_STATE);
    }

    @Override
    public boolean canConnectTransformer(IBlockReader world, BlockPos pos) {
        int offset = (Integer)world.func_180495_p(pos).func_177229_b((Property)POST_SLAVE);
        return offset > 0;
    }

    @Override
    @Nonnull
    public BlockPos getModelOffset(BlockState state, @Nullable Vector3i size) {
        HorizontalOffset d = (HorizontalOffset)((Object)state.func_177229_b(HORIZONTAL_OFFSET));
        return new BlockPos(0, ((Integer)state.func_177229_b((Property)POST_SLAVE)).intValue(), 0).func_177971_a(d.getOffset());
    }

    @Override
    public int func_200011_d(@Nonnull BlockState state, @Nonnull IBlockReader worldIn, @Nonnull BlockPos pos) {
        return 0;
    }

    static enum HorizontalOffset implements IStringSerializable
    {
        NONE,
        NORTH,
        SOUTH,
        EAST,
        WEST;


        public static HorizontalOffset get(Direction side) {
            switch (side) {
                case NORTH: {
                    return NORTH;
                }
                case SOUTH: {
                    return SOUTH;
                }
                case WEST: {
                    return WEST;
                }
                case EAST: {
                    return EAST;
                }
            }
            throw new IllegalArgumentException("No horizontal offset for " + side.name());
        }

        Vector3i getOffset() {
            switch (this) {
                case NORTH: {
                    return Direction.NORTH.func_176730_m();
                }
                case SOUTH: {
                    return Direction.SOUTH.func_176730_m();
                }
                case EAST: {
                    return Direction.EAST.func_176730_m();
                }
                case WEST: {
                    return Direction.WEST.func_176730_m();
                }
                case NONE: {
                    return BlockPos.field_177959_e;
                }
            }
            throw new IllegalStateException();
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

