/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.ImmersiveConnectableTileEntity;
import blusunrize.immersiveengineering.common.blocks.metal.EnergyConnectorTileEntity;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;

public class ConnectorStructuralTileEntity
extends ImmersiveConnectableTileEntity
implements IEBlockInterfaces.IHammerInteraction,
IOBJModelCallback<BlockState>,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IStateBasedDirectional {
    public float rotation = 0.0f;

    public ConnectorStructuralTileEntity() {
        super((TileEntityType<? extends ImmersiveConnectableTileEntity>)((TileEntityType)IETileTypes.CONNECTOR_STRUCTURAL.get()));
    }

    public ConnectorStructuralTileEntity(TileEntityType<? extends ConnectorStructuralTileEntity> type) {
        super((TileEntityType<? extends ImmersiveConnectableTileEntity>)type);
    }

    @Override
    public boolean hammerUseSide(Direction side, PlayerEntity player, Hand hand, Vector3d hitVec) {
        if (!this.field_145850_b.field_72995_K) {
            this.rotation += player.func_225608_bj_() ? -22.5f : 22.5f;
            this.rotation %= 360.0f;
            this.func_70296_d();
            this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_195044_w().func_177230_c(), 254, 0);
        }
        return true;
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74776_a("rotation", this.rotation);
    }

    @Override
    public void readCustomNBT(@Nonnull CompoundNBT nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.rotation = nbt.func_74760_g("rotation");
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.markContainingBlockForUpdate(null);
        }
    }

    @Override
    public Vector3d getConnectionOffset(@Nonnull Connection con, ConnectionPoint here) {
        Direction side = this.getFacing().func_176734_d();
        double conRadius = 0.03125;
        return new Vector3d(0.5 + (double)side.func_82601_c() * (-0.125 - conRadius), 0.5 + (double)side.func_96559_d() * (-0.125 - conRadius), 0.5 + (double)side.func_82599_e() * (-0.125 - conRadius));
    }

    @Override
    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vector3i offset) {
        return "STRUCTURE".equals(cableType.getCategory());
    }

    @Override
    public TransformationMatrix applyTransformations(BlockState object, String group, TransformationMatrix transform) {
        return transform.compose(new TransformationMatrix(new Vector3f(0.0f, 0.0f, 0.0f), new Quaternion(0.0f, this.rotation, 0.0f, true), null, null));
    }

    @Override
    public String getCacheKey(BlockState object) {
        return Float.toString(this.rotation);
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable ISelectionContext ctx) {
        return EnergyConnectorTileEntity.getConnectorBounds(this.getFacing(), 0.3125f, 0.5f);
    }

    @Override
    public IEBlockInterfaces.IDirectionalTile.PlacementLimitation getFacingLimitation() {
        return IEBlockInterfaces.IDirectionalTile.PlacementLimitation.SIDE_CLICKED;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return true;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vector3d hit, LivingEntity entity) {
        return false;
    }

    @Override
    public boolean canRotate(Direction axis) {
        return false;
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_ALL;
    }
}

