/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.SawmillRecipe;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.api.utils.DirectionalBlockPos;
import blusunrize.immersiveengineering.api.utils.shapes.CachedShapesWithTransform;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.PoweredMultiblockTileEntity;
import blusunrize.immersiveengineering.common.blocks.metal.ConveyorBeltTileEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.ListUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public class SawmillTileEntity
extends PoweredMultiblockTileEntity<SawmillTileEntity, MultiblockRecipe>
implements ConveyorHandler.IConveyorAttachable,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IPlayerInteraction {
    public float animation_bladeRotation = 0.0f;
    public ItemStack sawblade = ItemStack.field_190927_a;
    public List<SawmillProcess> sawmillProcessQueue = new ArrayList<SawmillProcess>();
    private int combinedLogs = 0;
    private final CapabilityReference<IItemHandler> outputCap = CapabilityReference.forTileEntityAt(this, () -> {
        Direction outDir = this.getIsMirrored() ? this.getFacing().func_176735_f() : this.getFacing().func_176746_e();
        return new DirectionalBlockPos(this.getBlockPosForPos(new BlockPos(4, 1, 1)).func_177972_a(outDir), outDir.func_176734_d());
    }, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    private final CapabilityReference<IItemHandler> secondaryOutputCap = CapabilityReference.forTileEntityAt(this, this::getSecondaryOutputCapPos, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    private static final CachedShapesWithTransform<BlockPos, Pair<Direction, Boolean>> SHAPES = CachedShapesWithTransform.createForMultiblock(SawmillTileEntity::getShape);
    private int cachedComparatorLevel = -1;
    private static final AxisAlignedBB SAWBLADE_AABB = new AxisAlignedBB(2.6875, 1.0, 1.375, 4.3125, 2.0, 1.625);
    private static final Function<SawmillTileEntity, AxisAlignedBB> CACHED_SAWBLADE_AABB = new Function<SawmillTileEntity, AxisAlignedBB>(){
        Map<Pair<Direction, Boolean>, AxisAlignedBB> cache = new ConcurrentHashMap<Pair<Direction, Boolean>, AxisAlignedBB>();

        @Override
        public AxisAlignedBB apply(SawmillTileEntity tile) {
            return this.cache.computeIfAbsent((Pair<Direction, Boolean>)Pair.of((Object)tile.getFacing(), (Object)tile.getIsMirrored()), key -> CachedShapesWithTransform.withFacingAndMirror(SAWBLADE_AABB, (Direction)key.getLeft(), (Boolean)key.getRight())).func_186670_a(tile.getOrigin());
        }
    };
    LazyOptional<IItemHandler> insertionHandler = this.registerConstantCap(new PoweredMultiblockTileEntity.MultiblockInventoryHandler_DirectProcessing(this){

        @Override
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            stack = stack.func_77946_l();
            SawmillTileEntity.this.insertItemToProcess(stack, simulate);
            return stack;
        }
    });

    public SawmillTileEntity() {
        super(IEMultiblocks.SAWMILL, 32000, true, (TileEntityType)IETileTypes.SAWMILL.get());
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.sawblade = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("sawblade"));
        ListNBT processNBT = nbt.func_150295_c("sawmillQueue", 10);
        this.sawmillProcessQueue.clear();
        for (int i = 0; i < processNBT.size(); ++i) {
            CompoundNBT tag = processNBT.func_150305_b(i);
            SawmillProcess process = SawmillProcess.readFromNBT(tag);
            this.sawmillProcessQueue.add(process);
        }
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (!this.sawblade.func_190926_b()) {
            nbt.func_218657_a("sawblade", (INBT)this.sawblade.func_77955_b(new CompoundNBT()));
        }
        ListNBT processNBT = new ListNBT();
        for (SawmillProcess process : this.sawmillProcessQueue) {
            processNBT.add((Object)process.writeToNBT());
        }
        nbt.func_218657_a("sawmillQueue", (INBT)processNBT);
    }

    @Override
    public void receiveMessageFromClient(CompoundNBT message) {
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.isDummy() || this.isRSDisabled()) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            if (this.shouldRenderAsActive()) {
                Optional<SawmillProcess> process;
                this.animation_bladeRotation += 36.0f;
                this.animation_bladeRotation %= 360.0f;
                if (!this.sawblade.func_190926_b() && (process = this.sawmillProcessQueue.stream().filter(SawmillProcess::isSawing).findFirst()).isPresent()) {
                    Direction particleDir = this.getIsMirrored() ? this.getFacing().func_176746_e() : this.getFacing().func_176735_f();
                    AxisAlignedBB aabb = CACHED_SAWBLADE_AABB.apply(this);
                    double posX = aabb.field_72340_a + this.field_145850_b.field_73012_v.nextDouble() * (aabb.field_72336_d - aabb.field_72340_a);
                    double posY = aabb.field_72338_b + this.field_145850_b.field_73012_v.nextDouble() * (aabb.field_72337_e - aabb.field_72338_b);
                    double posZ = aabb.field_72339_c + this.field_145850_b.field_73012_v.nextDouble() * (aabb.field_72334_f - aabb.field_72339_c);
                    double vX = this.field_145850_b.field_73012_v.nextDouble() * (double)particleDir.func_82601_c() * 0.3;
                    double vY = this.field_145850_b.field_73012_v.nextDouble() * 0.3;
                    double vZ = this.field_145850_b.field_73012_v.nextDouble() * (double)particleDir.func_82599_e() * 0.3;
                    this.field_145850_b.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, process.get().getCurrentStack(true)), posX, posY, posZ, vX, vY, vZ);
                }
            }
            return;
        }
        this.tickedProcesses = 0;
        int max = this.getMaxProcessPerTick();
        int i = 0;
        Iterator<SawmillProcess> processIterator = this.sawmillProcessQueue.iterator();
        this.tickedProcesses = 0;
        HashSet<ItemStack> secondaries = new HashSet<ItemStack>();
        while (processIterator.hasNext() && i++ < max) {
            SawmillProcess process = processIterator.next();
            if (process.processStep(this, secondaries)) {
                ++this.tickedProcesses;
            }
            if (!process.processFinished) continue;
            this.doProcessOutput(process.getCurrentStack(!this.sawblade.func_190926_b()).func_77946_l());
            processIterator.remove();
            if (this.sawblade.func_96631_a(((Integer)IEServerConfig.MACHINES.sawmill_bladeDamage.get()).intValue(), Utils.RAND, null)) {
                this.sawblade = ItemStack.field_190927_a;
                this.updateMasterBlock(null, true);
            }
            this.updateComparatorLevel(false);
        }
        for (ItemStack output : secondaries) {
            this.doSecondaryOutput(output.func_77946_l());
        }
    }

    @Override
    public boolean interact(Direction side, PlayerEntity player, Hand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        SawmillTileEntity master = (SawmillTileEntity)this.master();
        if (master != null) {
            if (player.func_225608_bj_() && !master.sawblade.func_190926_b()) {
                if (heldItem.func_190926_b()) {
                    player.func_184611_a(hand, master.sawblade.func_77946_l());
                } else if (!this.field_145850_b.field_72995_K) {
                    player.func_70099_a(master.sawblade.func_77946_l(), 0.0f);
                }
                master.sawblade = ItemStack.field_190927_a;
                master.updateComparatorLevel(false);
                this.updateMasterBlock(null, true);
                return true;
            }
            if (IETags.sawblades.func_230235_a_((Object)heldItem.func_77973_b())) {
                ItemStack tempBlade = !master.sawblade.func_190926_b() ? master.sawblade.func_77946_l() : ItemStack.field_190927_a;
                master.sawblade = ItemHandlerHelper.copyStackWithSize((ItemStack)heldItem, (int)1);
                heldItem.func_190918_g(1);
                if (heldItem.func_190916_E() <= 0) {
                    heldItem = ItemStack.field_190927_a;
                } else {
                    player.func_184611_a(hand, heldItem);
                }
                if (!tempBlade.func_190926_b()) {
                    if (heldItem.func_190926_b()) {
                        player.func_184611_a(hand, tempBlade);
                    } else if (!this.field_145850_b.field_72995_K) {
                        player.func_70099_a(tempBlade, 0.0f);
                    }
                }
                master.updateComparatorLevel(false);
                this.updateMasterBlock(null, true);
                return true;
            }
        }
        return false;
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable ISelectionContext ctx) {
        return SHAPES.get(this.posInMultiblock, (Pair<Direction, Boolean>)Pair.of((Object)this.getFacing(), (Object)this.getIsMirrored()));
    }

    private static List<AxisAlignedBB> getShape(BlockPos posInMultiblock) {
        ImmutableSet slabs = ImmutableSet.of((Object)new BlockPos(0, 0, 0), (Object)new BlockPos(4, 0, 0), (Object)new BlockPos(4, 0, 2));
        if (slabs.contains(posInMultiblock)) {
            return VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0).func_197756_d();
        }
        if (new BlockPos(0, 0, 2).equals((Object)posInMultiblock)) {
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0)});
            list.add(new AxisAlignedBB(0.125, 0.5, 0.625, 0.25, 1.0, 0.875));
            list.add(new AxisAlignedBB(0.75, 0.5, 0.625, 0.875, 1.0, 0.875));
            return list;
        }
        if (new BlockPos(0, 1, 2).equals((Object)posInMultiblock)) {
            return VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0, (double)1.0).func_197756_d();
        }
        if (new BlockPos(1, 1, 1).equals((Object)posInMultiblock)) {
            return VoxelShapes.func_197873_a((double)0.25, (double)0.0, (double)0.0, (double)0.875, (double)1.0, (double)1.0).func_197756_d();
        }
        if (new BlockPos(1, 1, 2).equals((Object)posInMultiblock)) {
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(0.25, 0.0, 0.0, 0.875, 1.0, 0.125)});
            list.add(new AxisAlignedBB(0.25, 0.0, 0.125, 0.875, 0.875, 0.75));
            list.add(new AxisAlignedBB(0.1875, 0.0, 0.0, 0.9375, 0.125, 0.8125));
            return list;
        }
        if (new BlockPos(1, 0, 2).equals((Object)posInMultiblock)) {
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0)});
            list.add(new AxisAlignedBB(0.1875, 0.5, 0.0, 0.9375, 1.0, 0.8125));
            list.add(new AxisAlignedBB(0.9375, 0.5, 0.25, 1.0, 0.875, 0.625));
            return list;
        }
        if (new BlockPos(2, 0, 2).equals((Object)posInMultiblock)) {
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0)});
            list.add(new AxisAlignedBB(0.0, 0.5, 0.25, 1.0, 0.875, 0.625));
            return list;
        }
        if (posInMultiblock.func_177956_o() == 1 && posInMultiblock.func_177952_p() == 1) {
            return VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.125, (double)1.0).func_197756_d();
        }
        return VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0).func_197756_d();
    }

    @Override
    public Set<BlockPos> getEnergyPos() {
        return ImmutableSet.of((Object)new BlockPos(2, 1, 0));
    }

    @Override
    public Set<BlockPos> getRedstonePos() {
        return ImmutableSet.of((Object)new BlockPos(0, 1, 2));
    }

    private void updateComparatorLevel(boolean force) {
        float damage = 1.0f - (float)this.sawblade.func_77952_i() / (float)this.sawblade.func_77958_k();
        int level = MathHelper.func_76141_d((float)(damage * 15.0f));
        if (level != this.cachedComparatorLevel || force) {
            this.cachedComparatorLevel = level;
            this.func_70296_d();
            Set<BlockPos> rsPositions = this.getRedstonePos();
            for (BlockPos rsPos : rsPositions) {
                SawmillTileEntity tile = (SawmillTileEntity)this.getTileForPos(rsPos);
                if (tile == null) continue;
                tile.cachedComparatorLevel = level;
                tile.func_70296_d();
                tile.markContainingBlockForUpdate(null);
            }
        }
    }

    @Override
    public int getComparatorInputOverride() {
        SawmillTileEntity master;
        if (!this.isRedstonePos()) {
            return 0;
        }
        if (this.cachedComparatorLevel < 0 && (master = (SawmillTileEntity)this.master()) != null) {
            master.updateComparatorLevel(true);
        }
        return this.cachedComparatorLevel;
    }

    @Override
    public boolean shouldRenderAsActive() {
        return this.getEnergyStored(null) > 0 && !this.isRSDisabled() && !this.sawblade.func_190926_b();
    }

    @Override
    public void replaceStructureBlock(BlockPos pos, BlockState state, ItemStack stack, int h, int l, int w) {
        TileEntity tile;
        super.replaceStructureBlock(pos, state, stack, h, l, w);
        if (h == 1 && l == 1 && (tile = this.field_145850_b.func_175625_s(pos)) instanceof ConveyorBeltTileEntity) {
            ((ConveyorBeltTileEntity)tile).setFacing(this.getIsMirrored() ? this.getFacing().func_176735_f() : this.getFacing().func_176746_e());
        }
    }

    private void insertItemToProcess(ItemStack stack, boolean simulate) {
        if (this.sawmillProcessQueue.size() < this.getProcessQueueMaxLength()) {
            float dist = 1.0f;
            float minProcessDist = 0.1f;
            SawmillProcess p = null;
            if (this.sawmillProcessQueue.size() > 0) {
                p = this.sawmillProcessQueue.get(this.sawmillProcessQueue.size() - 1);
                if (p != null) {
                    dist = p.getRelativeProcessStep();
                    if (!stack.func_77969_a(p.input) || this.combinedLogs > 2) {
                        if (!simulate) {
                            this.combinedLogs = 0;
                        }
                        minProcessDist = 0.5f;
                    }
                }
            } else if (this.combinedLogs > 0) {
                this.combinedLogs = 0;
            }
            if (p != null && dist < minProcessDist) {
                return;
            }
            if (!simulate) {
                p = new SawmillProcess(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
                this.sawmillProcessQueue.add(p);
                this.func_70296_d();
                this.markContainingBlockForUpdate(null);
                ++this.combinedLogs;
            }
            stack.func_190918_g(1);
        }
    }

    @Override
    public void onEntityCollision(World world, Entity entity) {
        if (!world.field_72995_K && entity != null && entity.func_70089_S()) {
            SawmillTileEntity master = (SawmillTileEntity)this.master();
            if (master == null) {
                return;
            }
            if (new BlockPos(0, 1, 1).equals((Object)this.posInMultiblock) && entity instanceof ItemEntity) {
                ItemStack stack = ((ItemEntity)entity).func_92059_d();
                if (stack.func_190926_b()) {
                    return;
                }
                master.insertItemToProcess(stack, false);
                if (stack.func_190916_E() <= 0) {
                    entity.func_70106_y();
                }
            } else if (entity instanceof LivingEntity && !master.sawblade.func_190926_b() && CACHED_SAWBLADE_AABB.apply(master).func_72326_a(entity.func_174813_aQ())) {
                if (entity instanceof PlayerEntity && ((PlayerEntity)entity).field_71075_bZ.field_75102_a) {
                    return;
                }
                int consumed = master.energyStorage.extractEnergy(80, true);
                if (consumed > 0) {
                    master.energyStorage.extractEnergy(consumed, false);
                    entity.func_70097_a(IEDamageSources.sawmill, 7.0f);
                }
            }
        }
    }

    @Override
    public boolean isInWorldProcessingMachine() {
        return true;
    }

    @Override
    public boolean additionalCanProcessCheck(PoweredMultiblockTileEntity.MultiblockProcess<MultiblockRecipe> process) {
        return true;
    }

    @Override
    public void doProcessOutput(ItemStack output) {
        if (!(output = Utils.insertStackIntoInventory(this.outputCap, output, false)).func_190926_b()) {
            Direction outDir = this.getIsMirrored() ? this.getFacing().func_176735_f() : this.getFacing().func_176746_e();
            BlockPos pos = this.func_174877_v().func_177967_a(outDir, 3);
            Utils.dropStackAtPos(this.field_145850_b, pos, output, outDir);
        }
    }

    public void doSecondaryOutput(ItemStack output) {
        if (!(output = Utils.insertStackIntoInventory(this.secondaryOutputCap, output, false)).func_190926_b()) {
            DirectionalBlockPos secondaryPos = this.getSecondaryOutputCapPos();
            Utils.dropStackAtPos(this.field_145850_b, secondaryPos.getPosition(), output, secondaryPos.getSide().func_176734_d());
        }
    }

    @Override
    public void doProcessFluidOutput(FluidStack output) {
    }

    @Override
    public void onProcessFinish(PoweredMultiblockTileEntity.MultiblockProcess<MultiblockRecipe> process) {
    }

    @Override
    public int getMaxProcessPerTick() {
        return 6;
    }

    @Override
    public int getProcessQueueMaxLength() {
        return 6;
    }

    @Override
    public float getMinProcessDistance(PoweredMultiblockTileEntity.MultiblockProcess<MultiblockRecipe> process) {
        return 0.5f;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return null;
    }

    @Override
    public NonNullList<ItemStack> getDroppedItems() {
        return ListUtils.fromItems(this.sawblade);
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public int[] getOutputSlots() {
        return null;
    }

    @Override
    public int[] getOutputTanks() {
        return new int[0];
    }

    @Override
    public IFluidTank[] getInternalTanks() {
        return new IFluidTank[0];
    }

    @Override
    public void doGraphicalUpdates(int slot) {
        this.func_70296_d();
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public MultiblockRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    @Override
    protected MultiblockRecipe getRecipeForId(ResourceLocation id) {
        return null;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            SawmillTileEntity master = (SawmillTileEntity)this.master();
            if (master == null) {
                return LazyOptional.empty();
            }
            if (new BlockPos(0, 1, 1).equals((Object)this.posInMultiblock) && facing == (this.getIsMirrored() ? this.getFacing().func_176746_e() : this.getFacing().func_176735_f())) {
                return master.insertionHandler.cast();
            }
            return LazyOptional.empty();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    protected IFluidTank[] getAccessibleFluidTanks(Direction side) {
        return new FluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, Direction side, FluidStack resource) {
        return false;
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, Direction side) {
        return false;
    }

    @Override
    public Direction[] sigOutputDirections() {
        if (new BlockPos(4, 1, 1).equals((Object)this.posInMultiblock)) {
            return new Direction[]{this.getIsMirrored() ? this.getFacing().func_176735_f() : this.getFacing().func_176746_e()};
        }
        return new Direction[0];
    }

    private DirectionalBlockPos getSecondaryOutputCapPos() {
        Direction shiftDir = this.getFacing().func_176734_d();
        return new DirectionalBlockPos(this.getBlockPosForPos(new BlockPos(3, 0, 2)).func_177972_a(shiftDir), shiftDir.func_176734_d());
    }

    public static class SawmillProcess {
        private final ItemStack input;
        private final SawmillRecipe recipe;
        private final float maxProcessTicks;
        private final int energyPerTick;
        private int processTick;
        private boolean stripped = false;
        private boolean sawed = false;
        private boolean processFinished = false;

        public SawmillProcess(ItemStack input) {
            this.input = input;
            this.recipe = SawmillRecipe.findRecipe(input);
            if (this.recipe != null) {
                this.maxProcessTicks = this.recipe.getTotalProcessTime();
                this.energyPerTick = this.recipe.getTotalProcessEnergy() / this.recipe.getTotalProcessTime();
            } else {
                this.maxProcessTicks = 80.0f;
                this.energyPerTick = 40;
            }
        }

        public boolean processStep(SawmillTileEntity tile, Set<ItemStack> secondaries) {
            if (tile.energyStorage.extractEnergy(this.energyPerTick, true) >= this.energyPerTick) {
                tile.energyStorage.extractEnergy(this.energyPerTick, false);
                ++this.processTick;
                float relative = this.getRelativeProcessStep();
                if (this.recipe != null) {
                    if (!this.stripped && (double)relative >= 0.3125) {
                        this.stripped = true;
                        secondaries.addAll((Collection<ItemStack>)this.recipe.secondaryStripping);
                    }
                    if (!this.sawed && (double)relative >= 0.8625) {
                        this.sawed = true;
                        if (!tile.sawblade.func_190926_b()) {
                            secondaries.addAll((Collection<ItemStack>)this.recipe.secondaryOutputs);
                        }
                    }
                }
                if (relative >= 1.0f) {
                    this.processFinished = true;
                }
                return true;
            }
            return false;
        }

        public float getRelativeProcessStep() {
            return (float)this.processTick / this.maxProcessTicks;
        }

        public ItemStack getCurrentStack(boolean sawblade) {
            if (this.recipe == null) {
                return this.input;
            }
            if (!this.stripped) {
                return this.input;
            }
            ItemStack stripped = this.recipe.stripped;
            if (stripped.func_190926_b()) {
                stripped = this.input;
            }
            if (!this.sawed) {
                return stripped;
            }
            return sawblade ? this.recipe.output : stripped;
        }

        public boolean isSawing() {
            return (double)this.getRelativeProcessStep() > 0.5375 && !this.sawed;
        }

        public CompoundNBT writeToNBT() {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_218657_a("input", (INBT)this.input.func_77955_b(new CompoundNBT()));
            nbt.func_74768_a("processTick", this.processTick);
            nbt.func_74757_a("stripped", this.stripped);
            nbt.func_74757_a("sawed", this.sawed);
            return nbt;
        }

        public static SawmillProcess readFromNBT(CompoundNBT nbt) {
            ItemStack input = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("input"));
            SawmillProcess process = new SawmillProcess(input);
            process.processTick = nbt.func_74762_e("processTick");
            process.stripped = nbt.func_74767_n("stripped");
            process.sawed = nbt.func_74767_n("sawed");
            return process;
        }
    }
}

