/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBaseTileEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.DirectionUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidSorterTileEntity
extends IEBaseTileEntity
implements IEBlockInterfaces.IInteractionObjectIE {
    public byte[] sortWithNBT = new byte[]{1, 1, 1, 1, 1, 1};
    public FluidStack[][] filters = new FluidStack[6][8];
    private static Set<BlockPos> usedRouters = null;
    private EnumMap<Direction, CapabilityReference<IFluidHandler>> neighborCaps = new EnumMap(Direction.class);
    private EnumMap<Direction, LazyOptional<IFluidHandler>> insertionHandlers = new EnumMap(Direction.class);

    public FluidSorterTileEntity() {
        super((TileEntityType<? extends TileEntity>)((TileEntityType)IETileTypes.FLUID_SORTER.get()));
        for (Direction f : DirectionUtils.VALUES) {
            LazyOptional<SorterFluidHandler> forSide = this.registerConstantCap(new SorterFluidHandler(this, f));
            this.insertionHandlers.put(f, forSide);
        }
        for (Direction f : DirectionUtils.VALUES) {
            this.neighborCaps.put(f, CapabilityReference.forNeighbor((TileEntity)this, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, f));
        }
    }

    public int routeFluid(Direction inputSide, FluidStack stack, IFluidHandler.FluidAction doFill) {
        int ret = 0;
        if (!this.field_145850_b.field_72995_K && this.canRoute()) {
            boolean first = this.startRouting();
            Direction[][] validOutputs = this.getValidOutputs(inputSide, stack);
            ret += this.doInsert(stack, validOutputs[0], doFill);
            if (validOutputs[0].length == 0) {
                ret += this.doInsert(stack, validOutputs[1], doFill);
            }
            if (first) {
                usedRouters = null;
            }
        }
        return ret;
    }

    private boolean canRoute() {
        return usedRouters == null || !usedRouters.contains(this.field_174879_c);
    }

    private boolean startRouting() {
        boolean first;
        boolean bl = first = usedRouters == null;
        if (first) {
            usedRouters = new HashSet<BlockPos>();
        }
        usedRouters.add(this.field_174879_c);
        return first;
    }

    private int doInsert(FluidStack stack, Direction[] sides, IFluidHandler.FluidAction doFill) {
        int ret = 0;
        for (int lengthFiltered = sides.length; lengthFiltered > 0 && stack.getAmount() > 0; --lengthFiltered) {
            int rand = Utils.RAND.nextInt(lengthFiltered);
            Direction currentSide = sides[rand];
            CapabilityReference<IFluidHandler> capRef = this.neighborCaps.get(currentSide);
            IFluidHandler fluidOut = capRef.getNullable();
            if (fluidOut != null) {
                int filledHere = fluidOut.fill(stack, doFill);
                stack.shrink(filledHere);
                ret += filledHere;
            }
            sides[rand] = sides[lengthFiltered - 1];
        }
        return ret;
    }

    public boolean doNBT(int side) {
        if (side >= 0 && side < this.sortWithNBT.length) {
            return this.sortWithNBT[side] == 1;
        }
        return false;
    }

    @Override
    public boolean canUseGui(PlayerEntity player) {
        return true;
    }

    @Override
    public IEBlockInterfaces.IInteractionObjectIE getGuiMaster() {
        return this;
    }

    @Override
    public void receiveMessageFromClient(CompoundNBT message) {
        if (message.func_150297_b("sideConfig", 7)) {
            this.sortWithNBT = message.func_74770_j("sideConfig");
        }
        if (message.func_150297_b("filter_side", 3)) {
            int side = message.func_74762_e("filter_side");
            int slot = message.func_74762_e("filter_slot");
            this.filters[side][slot] = FluidStack.loadFluidStackFromNBT((CompoundNBT)message.func_74775_l("filter"));
        }
        this.func_70296_d();
    }

    public Direction[][] getValidOutputs(Direction inputSide, @Nullable FluidStack fluidStack) {
        if (fluidStack == null) {
            return new Direction[2][0];
        }
        ArrayList<Direction> validFilteredInvOuts = new ArrayList<Direction>(6);
        ArrayList<Direction> validUnfilteredInvOuts = new ArrayList<Direction>(6);
        for (Direction side : Direction.values()) {
            if (side == inputSide || !this.field_145850_b.func_175667_e(this.func_174877_v().func_177972_a(side))) continue;
            boolean unmapped = true;
            boolean allowed = false;
            for (FluidStack filterStack : this.filters[side.ordinal()]) {
                boolean b;
                if (filterStack == null) continue;
                unmapped = false;
                boolean bl = b = filterStack.getFluid() == fluidStack.getFluid();
                if (this.doNBT(side.ordinal())) {
                    b &= FluidStack.areFluidStackTagsEqual((FluidStack)filterStack, (FluidStack)fluidStack);
                }
                if (!b) continue;
                allowed = true;
                break;
            }
            if (allowed) {
                validFilteredInvOuts.add(side);
                continue;
            }
            if (!unmapped) continue;
            validUnfilteredInvOuts.add(side);
        }
        return new Direction[][]{validFilteredInvOuts.toArray(new Direction[0]), validUnfilteredInvOuts.toArray(new Direction[0])};
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        this.sortWithNBT = nbt.func_74770_j("sortWithNBT");
        for (int side = 0; side < 6; ++side) {
            ListNBT filterList = nbt.func_150295_c("filter_" + side, 10);
            for (int i = 0; i < filterList.size(); ++i) {
                this.filters[side][i] = FluidStack.loadFluidStackFromNBT((CompoundNBT)filterList.func_150305_b(i));
            }
        }
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        nbt.func_74773_a("sortWithNBT", this.sortWithNBT);
        for (int side = 0; side < 6; ++side) {
            ListNBT filterList = new ListNBT();
            for (int i = 0; i < this.filters[side].length; ++i) {
                CompoundNBT tag = new CompoundNBT();
                if (this.filters[side][i] != null) {
                    this.filters[side][i].writeToNBT(tag);
                }
                filterList.add((Object)tag);
            }
            nbt.func_218657_a("filter_" + side, (INBT)filterList);
        }
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing != null) {
            return this.insertionHandlers.get(facing).cast();
        }
        return super.getCapability(capability, facing);
    }

    static class SorterFluidHandler
    implements IFluidHandler {
        FluidSorterTileEntity tile;
        Direction facing;

        SorterFluidHandler(FluidSorterTileEntity tile, Direction facing) {
            this.tile = tile;
            this.facing = facing;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource == null) {
                return 0;
            }
            return this.tile.routeFluid(this.facing, resource, action);
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
            return FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
            return FluidStack.EMPTY;
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return 1000;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return true;
        }
    }
}

