/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBaseTileEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.RotationUtil;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

public class TurntableTileEntity
extends IEBaseTileEntity
implements IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IHammerInteraction {
    private Rotation[] rotationMapping = new Rotation[]{Rotation.CLOCKWISE_90, Rotation.CLOCKWISE_90, Rotation.CLOCKWISE_90, Rotation.CLOCKWISE_90};
    private boolean[] redstone = new boolean[]{false, false, false, false};
    private static final int[] rotationDirectionIndexMap = new int[]{0, 2, 1, 3, 1};

    public TurntableTileEntity() {
        super((TileEntityType<? extends TileEntity>)((TileEntityType)IETileTypes.TURNTABLE.get()));
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        byte redstoneByte = nbt.func_74771_c("redstone");
        byte rotationMapValue = nbt.func_74771_c("rotationMapping");
        for (int i = 0; i < this.rotationMapping.length; ++i) {
            this.rotationMapping[i] = this.intToRotation(rotationMapValue >> 2 * i & 3);
            this.redstone[i] = (redstoneByte & 1 << i) != 0;
        }
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        byte rotationMapValue = 0;
        byte redstoneByte = 0;
        for (int i = 0; i < this.rotationMapping.length; ++i) {
            rotationMapValue = (byte)(rotationMapValue + (this.rotationToInt(this.rotationMapping[i]) << 2 * i));
            if (!this.redstone[i]) continue;
            redstoneByte = (byte)(redstoneByte + (1 << i));
        }
        nbt.func_74774_a("redstone", redstoneByte);
        nbt.func_74774_a("rotationMapping", rotationMapValue);
    }

    @Override
    public void onNeighborBlockChange(BlockPos otherPos) {
        int directionIndex;
        boolean r;
        super.onNeighborBlockChange(otherPos);
        Direction facing = this.getFacing();
        BlockPos difference = otherPos.func_177973_b((Vector3i)this.field_174879_c);
        Direction otherDir = Direction.func_176737_a((float)difference.func_177958_n(), (float)difference.func_177956_o(), (float)difference.func_177952_p());
        if (otherDir.func_176740_k() != facing.func_176740_k() && (r = this.field_145850_b.func_175709_b(this.field_174879_c.func_177972_a(otherDir), otherDir)) != this.redstone[directionIndex = this.getRotationDirectionIndexFromFacing(otherDir, facing)]) {
            this.redstone[directionIndex] = r;
            if (this.redstone[directionIndex]) {
                BlockPos target = this.field_174879_c.func_177972_a(facing);
                RotationUtil.rotateBlock(this.field_145850_b, target, this.rotationMapping[directionIndex]);
            }
        }
    }

    @Override
    public IEBlockInterfaces.IDirectionalTile.PlacementLimitation getFacingLimitation() {
        return IEBlockInterfaces.IDirectionalTile.PlacementLimitation.PISTON_LIKE;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return placer.func_225608_bj_();
    }

    @Override
    public boolean canHammerRotate(Direction side, Vector3d hit, LivingEntity entity) {
        return !entity.func_225608_bj_();
    }

    @Override
    public boolean canRotate(Direction axis) {
        return true;
    }

    @Override
    public boolean hammerUseSide(Direction side, PlayerEntity player, Hand hand, Vector3d hitVec) {
        Direction facing = this.getFacing();
        if (player.func_225608_bj_() && side.func_176740_k() != facing.func_176740_k()) {
            if (!this.field_145850_b.field_72995_K) {
                int directionIndex = this.getRotationDirectionIndexFromFacing(side, facing);
                this.rotationMapping[directionIndex] = this.intToRotation(this.rotationToInt(this.rotationMapping[directionIndex]) % 3 + 1);
                this.func_70296_d();
                this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_195044_w().func_177230_c(), 254, 0);
            }
            return true;
        }
        return false;
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_ALL;
    }

    private Rotation intToRotation(int rotationValue) {
        switch (rotationValue) {
            case 2: {
                return Rotation.CLOCKWISE_180;
            }
            case 3: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        return Rotation.CLOCKWISE_90;
    }

    private int rotationToInt(Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                return 2;
            }
            case COUNTERCLOCKWISE_90: {
                return 3;
            }
        }
        return 1;
    }

    private int getRotationDirectionIndexFromFacing(Direction indexee, Direction facing) {
        int index = indexee.func_176745_a();
        if (facing.func_176745_a() < index) {
            index -= 2;
        }
        if (index >= 2 && facing.func_176743_c() == Direction.AxisDirection.POSITIVE != (facing.func_176740_k() == Direction.Axis.Z)) {
            ++index;
        }
        return rotationDirectionIndexMap[index];
    }

    public Rotation getRotationFromSide(Direction side) {
        Direction facing = this.getFacing();
        if (side.func_176740_k() == facing.func_176740_k()) {
            return Rotation.NONE;
        }
        return this.rotationMapping[this.getRotationDirectionIndexFromFacing(side, facing)];
    }

    public void rotateRotationMap(Rotation rotation) {
        if (rotation == Rotation.NONE) {
            return;
        }
        int offset = this.rotationToInt(rotation);
        for (int i = 0; i < this.rotationMapping.length; ++i) {
            this.rotationMapping[i] = this.rotationMapping[Math.floorMod(i - offset, this.rotationMapping.length)];
        }
    }

    public void verticalTransitionRotationMap(Direction facingOld, Direction facingNew) {
        Direction horizontalFacing;
        boolean toVert = false;
        if (facingNew.func_176740_k() == Direction.Axis.Y) {
            toVert = true;
        }
        if (facingOld.func_176740_k() == Direction.Axis.Y == toVert) {
            return;
        }
        Direction direction = horizontalFacing = toVert ? facingOld : facingNew;
        int offset = horizontalFacing.func_176740_k() == Direction.Axis.Z ? (facingNew.func_176743_c() == facingOld.func_176743_c() ? 2 : 0) : (horizontalFacing.func_176743_c() == Direction.AxisDirection.POSITIVE == toVert ? 3 : 1);
        Rotation[] oldRotMap = (Rotation[])this.rotationMapping.clone();
        boolean[] oldRedstone = (boolean[])this.redstone.clone();
        for (int i = 0; i < this.rotationMapping.length; ++i) {
            int sourceIndex = Math.floorMod(i + offset, this.rotationMapping.length);
            this.rotationMapping[i] = oldRotMap[sourceIndex];
            this.redstone[i] = oldRedstone[sourceIndex];
        }
    }
}

