/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.api.tool.ChemthrowerHandler;
import blusunrize.immersiveengineering.common.entities.IEProjectileEntity;
import blusunrize.immersiveengineering.common.util.fluids.IEFluid;
import blusunrize.immersiveengineering.mixin.accessors.EntityAccess;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

public class ChemthrowerShotEntity
extends IEProjectileEntity {
    private FluidStack fluid;
    private static final DataParameter<Optional<FluidStack>> dataMarker_fluid = EntityDataManager.func_187226_a(ChemthrowerShotEntity.class, IEFluid.OPTIONAL_FLUID_STACK);
    public static final EntityType<ChemthrowerShotEntity> TYPE = EntityType.Builder.func_220322_a(ChemthrowerShotEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.1f, 0.1f).func_206830_a("immersiveengineering:chemthrower_shot");

    public ChemthrowerShotEntity(EntityType<ChemthrowerShotEntity> type, World world) {
        super(type, world);
    }

    public ChemthrowerShotEntity(World world, double x, double y, double z, double ax, double ay, double az, FluidStack fluid) {
        super(TYPE, world, x, y, z);
        this.fluid = fluid;
        this.setFluidSynced();
    }

    public ChemthrowerShotEntity(World world, LivingEntity living, double ax, double ay, double az, FluidStack fluid) {
        super(TYPE, world, living, ax, ay, az);
        this.fluid = fluid;
        this.setFluidSynced();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(dataMarker_fluid, Optional.empty());
    }

    public void setFluidSynced() {
        if (this.getFluid() != null) {
            this.field_70180_af.func_187227_b(dataMarker_fluid, Optional.of(this.getFluid()));
        }
    }

    public FluidStack getFluidSynced() {
        return ((Optional)this.field_70180_af.func_187225_a(dataMarker_fluid)).orElse(null);
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    @Override
    public double getGravity() {
        if (this.getFluid() != null) {
            FluidStack fluidStack = this.getFluid();
            boolean isGas = fluidStack.getFluid().getAttributes().isGaseous(fluidStack);
            return (isGas ? 0.025f : 0.05f) * (float)(fluidStack.getFluid().getAttributes().getDensity(fluidStack) < 0 ? -1 : 1);
        }
        return super.getGravity();
    }

    @Override
    public boolean canIgnite() {
        return ChemthrowerHandler.isFlammable(this.getFluid() == null ? null : this.getFluid().getFluid());
    }

    public void func_70030_z() {
        BlockState state;
        Block b;
        if (this.getFluid() == null && this.field_70170_p.field_72995_K) {
            this.fluid = this.getFluidSynced();
        }
        if ((b = (state = this.field_70170_p.func_180495_p(this.func_233580_cy_())).func_177230_c()) != null && this.canIgnite() && (state.func_185904_a() == Material.field_151581_o || state.func_185904_a() == Material.field_151587_i)) {
            this.func_70015_d(6);
        }
        super.func_70030_z();
    }

    public void func_70015_d(int seconds) {
        if (!this.canIgnite()) {
            return;
        }
        super.func_70015_d(seconds);
    }

    @Override
    public void func_70227_a(RayTraceResult mop) {
        if (!this.field_70170_p.field_72995_K && this.getFluid() != null) {
            boolean fire;
            FluidStack fluidStack = this.getFluid();
            Fluid fluid = fluidStack.getFluid();
            ChemthrowerHandler.ChemthrowerEffect effect = ChemthrowerHandler.getEffect(fluid);
            boolean bl = fire = fluid.getAttributes().getTemperature(fluidStack) > 1000;
            if (effect != null) {
                ItemStack thrower = ItemStack.field_190927_a;
                PlayerEntity shooter = (PlayerEntity)this.func_234616_v_();
                if (shooter != null) {
                    thrower = shooter.func_184586_b(Hand.MAIN_HAND);
                }
                if (mop.func_216346_c() == RayTraceResult.Type.ENTITY && ((EntityRayTraceResult)mop).func_216348_a() instanceof LivingEntity) {
                    effect.applyToEntity((LivingEntity)((EntityRayTraceResult)mop).func_216348_a(), shooter, thrower, fluidStack);
                } else if (mop.func_216346_c() == RayTraceResult.Type.BLOCK) {
                    effect.applyToBlock(this.field_70170_p, mop, shooter, thrower, fluidStack);
                }
            } else if (mop.func_216346_c() == RayTraceResult.Type.ENTITY && fluid.getAttributes().getTemperature(fluidStack) > 500) {
                int tempDiff = fluid.getAttributes().getTemperature(fluidStack) - 300;
                int damage = Math.abs(tempDiff) / 500;
                Entity hit = ((EntityRayTraceResult)mop).func_216348_a();
                if (hit.func_70097_a(DamageSource.field_76371_c, (float)damage)) {
                    hit.field_70172_ad = (int)((double)hit.field_70172_ad * 0.75);
                }
            }
            if (mop.func_216346_c() == RayTraceResult.Type.ENTITY) {
                int f;
                int n = this.func_70027_ad() ? ((EntityAccess)((Object)this)).getFire() : (f = fire ? 3 : 0);
                if (f > 0) {
                    Entity hit = ((EntityRayTraceResult)mop).func_216348_a();
                    hit.func_70015_d(f);
                    if (hit.func_70097_a(DamageSource.field_76372_a, 2.0f)) {
                        hit.field_70172_ad = (int)((double)hit.field_70172_ad * 0.75);
                    }
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getBrightnessForRender() {
        FluidStack fluidStack = this.getFluid();
        if (fluidStack != null) {
            int light = this.func_70027_ad() ? 15 : fluidStack.getFluid().getAttributes().getLuminosity(fluidStack);
            int superBrightness = 0;
            if ((light = superBrightness & 0xFF00000 | light << 4) > 0) {
                return Math.max(light, superBrightness);
            }
        }
        return 0;
    }

    public float func_70013_c() {
        FluidStack fluidStack = this.getFluid();
        if (fluidStack != null) {
            int light;
            int n = light = this.func_70027_ad() ? 15 : fluidStack.getFluid().getAttributes().getLuminosity(fluidStack);
            if (light > 0) {
                return Math.max((float)light, super.func_70013_c());
            }
        }
        return super.func_70013_c();
    }

    static {
        TYPE.setRegistryName("immersiveengineering", "chemthrower_shot");
    }
}

