/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.fluid.FluidUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.thread.EffectiveSide;

public class IEItemInterfaces {

    public static interface IScrollwheel {
        public void onScrollwheel(ItemStack var1, PlayerEntity var2, boolean var3);
    }

    public static interface IBulletContainer {
        public NonNullList<ItemStack> getBullets(ItemStack var1, boolean var2);

        default public NonNullList<ItemStack> getBullets(ItemStack container) {
            return this.getBullets(container, EffectiveSide.get() == LogicalSide.CLIENT);
        }

        public int getBulletCount(ItemStack var1);
    }

    public static interface ITextureOverride {
        @OnlyIn(value=Dist.CLIENT)
        public String getModelCacheKey(ItemStack var1);

        @OnlyIn(value=Dist.CLIENT)
        public List<ResourceLocation> getTextures(ItemStack var1, String var2);
    }

    public static interface IAdvancedFluidItem {
        public int getCapacity(ItemStack var1, int var2);

        default public boolean allowFluid(ItemStack container, FluidStack fluid) {
            return true;
        }

        default public FluidStack getFluid(ItemStack container) {
            Optional<FluidStack> optional = FluidUtils.getFluidContained(container);
            if (optional.isPresent()) {
                return optional.orElseThrow(RuntimeException::new);
            }
            return null;
        }
    }

    public static interface IColouredItem {
        default public boolean hasCustomItemColours() {
            return false;
        }

        default public int getColourForIEItem(ItemStack stack, int pass) {
            return 0xFFFFFF;
        }
    }
}

