/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.utils.CapabilityUtils;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.util.fluids.PotionFluid;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.registries.ForgeRegistries;

public class PotionBucketItem
extends IEBaseItem {
    public PotionBucketItem() {
        super("potion_bucket", new Item.Properties().func_200917_a(1));
    }

    public static ItemStack forPotion(Potion type) {
        if (type == Potions.field_185230_b || type == null) {
            return new ItemStack((IItemProvider)Items.field_151131_as);
        }
        ItemStack result = new ItemStack((IItemProvider)PotionFluid.bucket);
        result.func_196082_o().func_74778_a("Potion", type.getRegistryName().toString());
        return result;
    }

    public static Potion getPotion(ItemStack stack) {
        return PotionFluid.fromTag(stack.func_77978_p());
    }

    public void func_150895_a(@Nonnull ItemGroup group, @Nonnull NonNullList<ItemStack> items) {
        if (!this.func_194125_a(group)) {
            return;
        }
        ArrayList<Potion> sortedPotions = new ArrayList<Potion>(ForgeRegistries.POTION_TYPES.getValues());
        sortedPotions.sort(Comparator.comparing(e -> PotionBucketItem.getPotionName(e).getString()));
        for (Potion p : sortedPotions) {
            if (p == Potions.field_185230_b) continue;
            items.add((Object)PotionBucketItem.forPotion(p));
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new FluidHandler(stack);
    }

    @Nonnull
    public ITextComponent func_200295_i(@Nonnull ItemStack stack) {
        return new TranslationTextComponent("item.immersiveengineering.potion_bucket", new Object[]{PotionBucketItem.getPotionName(PotionBucketItem.getPotion(stack))});
    }

    private static ITextComponent getPotionName(Potion potion) {
        String potionKey = potion.func_185174_b(Items.field_151068_bn.func_77658_a() + ".effect.");
        return new TranslationTextComponent(potionKey);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World worldIn, @Nonnull PlayerEntity playerIn, @Nonnull Hand handIn) {
        BlockRayTraceResult rayTraceResult = PotionBucketItem.func_219968_a((World)worldIn, (PlayerEntity)playerIn, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.NONE);
        ItemStack stack = playerIn.func_184586_b(handIn);
        ActionResult forgeResult = ForgeEventFactory.onBucketUse((PlayerEntity)playerIn, (World)worldIn, (ItemStack)stack, (RayTraceResult)rayTraceResult);
        if (forgeResult != null) {
            return forgeResult;
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flagIn) {
        PotionUtils.func_185182_a((ItemStack)stack, tooltip, (float)1.0f);
    }

    private static class FluidHandler
    implements IFluidHandlerItem,
    ICapabilityProvider {
        private final ItemStack stack;
        private boolean empty = false;
        private final LazyOptional<IFluidHandlerItem> lazyOpt = CapabilityUtils.constantOptional(this);

        private FluidHandler(ItemStack stack) {
            this.stack = stack;
        }

        private FluidStack getFluid() {
            if (this.empty) {
                return FluidStack.EMPTY;
            }
            return PotionFluid.getFluidStackForType(PotionBucketItem.getPotion(this.stack), 1000);
        }

        @Nonnull
        public ItemStack getContainer() {
            return this.empty ? new ItemStack((IItemProvider)Items.field_151133_ar) : this.stack;
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            if (tank == 0) {
                return this.getFluid();
            }
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return tank == 0 ? 1000 : 0;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return false;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            FluidStack fluid = this.getFluid();
            if (!fluid.isFluidEqual(resource) || !Objects.equals(fluid.getTag(), resource.getTag())) {
                return FluidStack.EMPTY;
            }
            return this.drain(resource.getAmount(), action);
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (this.empty || this.stack.func_190916_E() > 1 || maxDrain < 1000) {
                return FluidStack.EMPTY;
            }
            FluidStack potion = this.getFluid();
            if (action.execute()) {
                this.empty = true;
            }
            return potion;
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY) {
                return this.lazyOpt.cast();
            }
            return LazyOptional.empty();
        }
    }
}

