/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.tool.IUpgrade;
import blusunrize.immersiveengineering.api.tool.IUpgradeableTool;
import blusunrize.immersiveengineering.common.items.InternalStorageItem;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public abstract class UpgradeableToolItem
extends InternalStorageItem
implements IUpgradeableTool {
    private String upgradeType;

    public UpgradeableToolItem(String name, Item.Properties props, String upgradeType) {
        super(name, props);
        this.upgradeType = upgradeType;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !ItemStack.func_77989_b((ItemStack)oldStack, (ItemStack)newStack);
    }

    @Override
    public CompoundNBT getUpgrades(ItemStack stack) {
        return ItemNBTHelper.getTagCompound(stack, "upgrades");
    }

    @Override
    public void clearUpgrades(ItemStack stack) {
        ItemNBTHelper.remove(stack, "upgrades");
    }

    @Override
    public void finishUpgradeRecalculation(ItemStack stack) {
    }

    @Override
    public void recalculateUpgrades(ItemStack stack, World w, PlayerEntity player) {
        if (w.field_72995_K) {
            return;
        }
        this.clearUpgrades(stack);
        LazyOptional lazyInv = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        lazyInv.ifPresent(inv -> {
            CompoundNBT upgradeTag = this.getUpgradeBase(stack).func_74737_b();
            for (int i = 0; i < inv.getSlots(); ++i) {
                IUpgrade upg;
                ItemStack u = inv.getStackInSlot(i);
                if (u.func_190926_b() || !(u.func_77973_b() instanceof IUpgrade) || !(upg = (IUpgrade)u.func_77973_b()).getUpgradeTypes(u).contains(this.upgradeType) || !upg.canApplyUpgrades(stack, u)) continue;
                upg.applyUpgrades(stack, u, upgradeTag);
            }
            ItemNBTHelper.setTagCompound(stack, "upgrades", upgradeTag);
            this.finishUpgradeRecalculation(stack);
        });
    }

    public CompoundNBT getUpgradeBase(ItemStack stack) {
        return new CompoundNBT();
    }

    @Override
    public boolean canTakeFromWorkbench(ItemStack stack) {
        return true;
    }

    @Override
    public void removeFromWorkbench(PlayerEntity player, ItemStack stack) {
    }

    @Override
    public abstract boolean canModify(ItemStack var1);

    @Override
    public abstract Slot[] getWorkbenchSlots(Container var1, ItemStack var2, Supplier<World> var3, Supplier<PlayerEntity> var4);
}

