/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.immersiveflux.IFluxProvider;
import blusunrize.immersiveengineering.api.energy.immersiveflux.IFluxReceiver;
import blusunrize.immersiveengineering.api.tool.ITool;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.localhandlers.EnergyTransferHandler;
import blusunrize.immersiveengineering.api.wires.utils.WireLink;
import blusunrize.immersiveengineering.api.wires.utils.WirecoilUtils;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class VoltmeterItem
extends IEBaseItem
implements ITool {
    public VoltmeterItem() {
        super("voltmeter", new Item.Properties().func_200917_a(1));
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (WirecoilUtils.hasWireLink(stack)) {
            WireLink link = WireLink.readFromItem(stack);
            tooltip.add((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.info.attachedToDim", new Object[]{link.cp.getX(), link.cp.getY(), link.cp.getZ(), link.dimension.toString()}));
        }
    }

    @Override
    public boolean isTool(ItemStack item) {
        return true;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        Direction side = context.func_196000_l();
        PlayerEntity player = context.func_195999_j();
        ItemStack stack = context.func_195996_i();
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(player != null && player.func_225608_bj_() || !(tileEntity instanceof IFluxReceiver) && !(tileEntity instanceof IFluxProvider))) {
            int stored;
            int max;
            if (tileEntity instanceof IFluxReceiver) {
                max = ((IFluxReceiver)tileEntity).getMaxEnergyStored(side);
                stored = ((IFluxReceiver)tileEntity).getEnergyStored(side);
            } else {
                max = ((IFluxProvider)tileEntity).getMaxEnergyStored(side);
                stored = ((IFluxProvider)tileEntity).getEnergyStored(side);
            }
            if (max > 0) {
                ChatUtils.sendServerNoSpamMessages(player, new ITextComponent[]{new TranslationTextComponent("chat.immersiveengineering.info.energyStorage", new Object[]{stored, max})});
            }
            return ActionResultType.SUCCESS;
        }
        if (player != null && player.func_225608_bj_() && tileEntity instanceof IImmersiveConnectable) {
            if (world.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            TargetingInfo targetingInfo = new TargetingInfo(context);
            BlockPos masterPos = ((IImmersiveConnectable)tileEntity).getConnectionMaster(null, targetingInfo);
            BlockPos delta = pos.func_177973_b((Vector3i)masterPos);
            ConnectionPoint cp = ((IImmersiveConnectable)tileEntity).getTargetedPoint(targetingInfo, (Vector3i)delta);
            if (cp == null) {
                return ActionResultType.FAIL;
            }
            if (!WirecoilUtils.hasWireLink(stack)) {
                WireLink link = WireLink.create(cp, world, delta, targetingInfo);
                link.writeToItem(stack);
            } else {
                EnergyTransferHandler energyHandler;
                LocalWireNetwork netLink;
                GlobalWireNetwork global;
                LocalWireNetwork netHere;
                WireLink link = WireLink.readFromItem(stack);
                if (link.dimension.equals((Object)world.func_234923_W_()) && (netHere = (global = GlobalWireNetwork.getNetwork(world)).getNullableLocalNet(cp)) == (netLink = global.getNullableLocalNet(link.cp)) && netHere != null && (energyHandler = netHere.getHandler(EnergyTransferHandler.ID, EnergyTransferHandler.class)) != null) {
                    EnergyTransferHandler.Path energyPath = energyHandler.getPath(link.cp, cp);
                    double loss = energyPath != null ? energyPath.loss : 1.0;
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("chat.immersiveengineering.info.averageLoss", new Object[]{Utils.formatDouble(loss * 100.0, "###.000")}), Util.field_240973_b_);
                }
                WirecoilUtils.clearWireLink(stack);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }
}

