/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import blusunrize.immersiveengineering.api.multiblocks.TemplateMultiblock;
import blusunrize.immersiveengineering.common.blocks.multiblocks.StaticTemplateManager;
import blusunrize.immersiveengineering.common.network.IMessage;
import blusunrize.immersiveengineering.common.network.PacketUtils;
import blusunrize.immersiveengineering.mixin.accessors.PaletteAccess;
import blusunrize.immersiveengineering.mixin.accessors.TemplateAccess;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.GameData;

public class MessageMultiblockSync
implements IMessage {
    private final List<SyncedTemplate> templates;

    public MessageMultiblockSync(List<SyncedTemplate> templatesToSync) {
        this.templates = templatesToSync;
    }

    public MessageMultiblockSync(PacketBuffer buf) {
        this.templates = PacketUtils.readList(buf, SyncedTemplate::new);
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        PacketUtils.writeList(buf, this.templates, SyncedTemplate::writeTo);
    }

    @Override
    public void process(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            for (SyncedTemplate synced : this.templates) {
                Template template = new Template();
                TemplateAccess access = (TemplateAccess)template;
                access.setSize(synced.size);
                access.getBlocks().add(synced.parts);
                StaticTemplateManager.SYNCED_CLIENT_TEMPLATES.put(synced.name, template);
            }
            for (MultiblockHandler.IMultiblock mb : MultiblockHandler.getMultiblocks()) {
                if (!(mb instanceof TemplateMultiblock)) continue;
                ((TemplateMultiblock)mb).reset();
            }
            ImmersiveEngineering.proxy.resetManual();
        });
    }

    public static class SyncedTemplate {
        private final BlockPos size;
        private final ResourceLocation name;
        private final Template.Palette parts;

        public SyncedTemplate(Template template, ResourceLocation name) {
            this.size = template.func_186259_a();
            this.parts = ((TemplateAccess)template).getBlocks().get(0);
            this.name = name;
        }

        public SyncedTemplate(PacketBuffer buffer) {
            this.size = buffer.func_179259_c();
            this.name = buffer.func_192575_l();
            this.parts = PaletteAccess.construct(PacketUtils.readList(buffer, SyncedTemplate::readPart));
        }

        public void writeTo(PacketBuffer buffer) {
            buffer.func_179255_a(this.size);
            buffer.func_192572_a(this.name);
            PacketUtils.writeList(buffer, this.parts.func_237157_a_(), SyncedTemplate::writePart);
        }

        private static Template.BlockInfo readPart(PacketBuffer buffer) {
            ObjectIntIdentityMap stateIds = GameData.getBlockStateIDMap();
            BlockState state = (BlockState)stateIds.func_148745_a(buffer.func_150792_a());
            BlockPos pos = buffer.func_179259_c();
            CompoundNBT nbt = buffer.func_150793_b();
            return new Template.BlockInfo(pos, Objects.requireNonNull(state), nbt);
        }

        private static void writePart(Template.BlockInfo info, PacketBuffer buffer) {
            ObjectIntIdentityMap stateIds = GameData.getBlockStateIDMap();
            buffer.func_150787_b(stateIds.func_148757_b((Object)info.field_186243_b));
            buffer.func_179255_a(info.field_186242_a);
            buffer.func_150786_a(info.field_186244_c);
        }
    }
}

