/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.api.fluid.FluidUtils;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.api.utils.DirectionalBlockPos;
import blusunrize.immersiveengineering.api.utils.Raytracer;
import blusunrize.immersiveengineering.common.items.HammerItem;
import blusunrize.immersiveengineering.common.items.ScrewdriverItem;
import blusunrize.immersiveengineering.common.items.WirecutterItem;
import blusunrize.immersiveengineering.common.util.DirectionUtils;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.HandSide;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class Utils {
    public static final Random RAND = new Random();
    public static final DecimalFormat NUMBERFORMAT_PREFIXED = new DecimalFormat("+#;-#");
    public static final BiMap<ResourceLocation, DyeColor> DYES_BY_TAG = ImmutableBiMap.builder().put((Object)Tags.Items.DYES_BLACK.func_230234_a_(), (Object)DyeColor.BLACK).put((Object)Tags.Items.DYES_RED.func_230234_a_(), (Object)DyeColor.RED).put((Object)Tags.Items.DYES_GREEN.func_230234_a_(), (Object)DyeColor.GREEN).put((Object)Tags.Items.DYES_BROWN.func_230234_a_(), (Object)DyeColor.BROWN).put((Object)Tags.Items.DYES_BLUE.func_230234_a_(), (Object)DyeColor.BLUE).put((Object)Tags.Items.DYES_PURPLE.func_230234_a_(), (Object)DyeColor.PURPLE).put((Object)Tags.Items.DYES_CYAN.func_230234_a_(), (Object)DyeColor.CYAN).put((Object)Tags.Items.DYES_LIGHT_GRAY.func_230234_a_(), (Object)DyeColor.LIGHT_GRAY).put((Object)Tags.Items.DYES_GRAY.func_230234_a_(), (Object)DyeColor.GRAY).put((Object)Tags.Items.DYES_PINK.func_230234_a_(), (Object)DyeColor.PINK).put((Object)Tags.Items.DYES_LIME.func_230234_a_(), (Object)DyeColor.LIME).put((Object)Tags.Items.DYES_YELLOW.func_230234_a_(), (Object)DyeColor.YELLOW).put((Object)Tags.Items.DYES_LIGHT_BLUE.func_230234_a_(), (Object)DyeColor.LIGHT_BLUE).put((Object)Tags.Items.DYES_MAGENTA.func_230234_a_(), (Object)DyeColor.MAGENTA).put((Object)Tags.Items.DYES_ORANGE.func_230234_a_(), (Object)DyeColor.ORANGE).put((Object)Tags.Items.DYES_WHITE.func_230234_a_(), (Object)DyeColor.WHITE).build();
    private static final long UUID_BASE = 109406000905L;
    private static long UUIDAdd = 1L;
    private static Method m_getHarvestLevel = null;

    public static boolean isInTag(ItemStack stack, ResourceLocation tagName) {
        ITag tag = ItemTags.func_199903_a().func_199910_a(tagName);
        return tag != null && tag.func_230235_a_((Object)stack.func_77973_b());
    }

    public static boolean compareItemNBT(ItemStack stack1, ItemStack stack2) {
        boolean hasTag2;
        if (stack1.func_190926_b() != stack2.func_190926_b()) {
            return false;
        }
        boolean hasTag1 = stack1.func_77942_o();
        if (hasTag1 != (hasTag2 = stack2.func_77942_o())) {
            return false;
        }
        if (hasTag1 && !stack1.func_196082_o().equals((Object)stack2.func_196082_o())) {
            return false;
        }
        return stack1.areCapsCompatible((CapabilityProvider)stack2);
    }

    @Nullable
    public static DyeColor getDye(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        Collection owners = ItemTags.func_199903_a().func_199913_a((Object)stack.func_77973_b());
        if (owners.contains(Tags.Items.DYES.func_230234_a_())) {
            for (ResourceLocation tag : owners) {
                if (!DYES_BY_TAG.containsKey((Object)tag)) continue;
                return (DyeColor)DYES_BY_TAG.get((Object)tag);
            }
        }
        return null;
    }

    public static boolean isDye(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        return stack.func_77973_b().func_206844_a((ITag)Tags.Items.DYES);
    }

    public static FluidStack copyFluidStackWithAmount(FluidStack stack, int amount, boolean stripPressure) {
        return FluidUtils.copyFluidStackWithAmount(stack, amount, stripPressure);
    }

    public static UUID generateNewUUID() {
        UUID uuid = new UUID(109406000905L, UUIDAdd);
        ++UUIDAdd;
        return uuid;
    }

    public static boolean isBlockAt(World world, BlockPos pos, Block b) {
        return world.func_180495_p(pos).func_177230_c() == b;
    }

    public static double generateLuckInfluencedDouble(double median, double deviation, double luck, Random rng, boolean isBad, double luckScale) {
        double number = rng.nextDouble() * deviation;
        if (isBad) {
            number = -number;
        }
        number += luckScale * luck;
        number = deviation < 0.0 ? Math.max(number, deviation) : Math.min(number, deviation);
        return median + number;
    }

    public static String formatDouble(double d, String s) {
        DecimalFormat df = new DecimalFormat(s);
        return df.format(d);
    }

    public static String toScientificNotation(int value, String decimalPrecision, int useKilo) {
        float formatted;
        float f = value >= 1000000000 ? (float)value / 1.0E9f : (value >= 1000000 ? (float)value / 1000000.0f : (formatted = value >= useKilo ? (float)value / 1000.0f : (float)value));
        String notation = value >= 1000000000 ? "G" : (value >= 1000000 ? "M" : (value >= useKilo ? "K" : ""));
        return Utils.formatDouble(formatted, "0." + decimalPrecision) + notation;
    }

    public static String toCamelCase(String s) {
        return s.substring(0, 1).toUpperCase(Locale.ENGLISH) + s.substring(1).toLowerCase(Locale.ENGLISH);
    }

    public static String getHarvestLevelName(int lvl) {
        if (ModList.get().isLoaded("tconstruct")) {
            try {
                Class<?> clazz;
                if (m_getHarvestLevel == null && (clazz = Class.forName("tconstruct.library.util")) != null) {
                    m_getHarvestLevel = clazz.getDeclaredMethod("getHarvestLevelName", Integer.TYPE);
                }
                if (m_getHarvestLevel != null) {
                    return (String)m_getHarvestLevel.invoke(null, lvl);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return I18n.func_135052_a((String)("desc.immersiveengineering.info.mininglvl." + Math.max(-1, Math.min(lvl, 6))), (Object[])new Object[0]);
    }

    public static String getModName(String modid) {
        return ModList.get().getModContainerById(modid).map(container -> container.getModInfo().getDisplayName()).orElse(modid);
    }

    public static <T> int findSequenceInList(List<T> list, T[] sequence, BiPredicate<T, T> equal) {
        if (list.size() <= 0 || list.size() < sequence.length) {
            return -1;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (!equal.test(sequence[0], list.get(i))) continue;
            boolean found = true;
            for (int j = 1; j < sequence.length && (found = equal.test(sequence[j], list.get(i + j))); ++j) {
            }
            if (!found) continue;
            return i;
        }
        return -1;
    }

    public static Direction rotateFacingTowardsDir(Direction f, Direction dir) {
        if (dir == Direction.NORTH) {
            return f;
        }
        if (dir == Direction.SOUTH && f.func_176740_k() != Direction.Axis.Y) {
            return f.func_176746_e().func_176746_e();
        }
        if (dir == Direction.WEST && f.func_176740_k() != Direction.Axis.Y) {
            return f.func_176735_f();
        }
        if (dir == Direction.EAST && f.func_176740_k() != Direction.Axis.Y) {
            return f.func_176746_e();
        }
        if (dir == Direction.DOWN && f.func_176740_k() != Direction.Axis.Y) {
            return DirectionUtils.rotateAround(f, Direction.Axis.X);
        }
        if (dir == Direction.UP && f.func_176740_k() != Direction.Axis.X) {
            return DirectionUtils.rotateAround(f, Direction.Axis.X).func_176734_d();
        }
        return f;
    }

    public static Vector3d getLivingFrontPos(LivingEntity entity, double offset, double height, HandSide hand, boolean useSteppedYaw, float partialTicks) {
        double offsetX = hand == HandSide.LEFT ? -0.3125 : (hand == HandSide.RIGHT ? 0.3125 : 0.0);
        float yaw = entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * partialTicks;
        if (useSteppedYaw) {
            yaw = entity.field_70760_ar + (entity.field_70761_aq - entity.field_70760_ar) * partialTicks;
        }
        float pitch = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * partialTicks;
        float yawCos = MathHelper.func_76134_b((float)(-yaw * (float)Math.PI / 180.0f - (float)Math.PI));
        float yawSin = MathHelper.func_76126_a((float)(-yaw * (float)Math.PI / 180.0f - (float)Math.PI));
        float pitchCos = -MathHelper.func_76134_b((float)(-pitch * (float)Math.PI / 180.0f));
        float pitchSin = MathHelper.func_76126_a((float)(-pitch * (float)Math.PI / 180.0f));
        return new Vector3d(entity.func_226277_ct_() + offsetX * (double)yawCos + offset * (double)pitchCos * (double)yawSin, entity.func_226278_cu_() + offset * (double)pitchSin + height, entity.func_226281_cx_() + offset * (double)pitchCos * (double)yawCos - offsetX * (double)yawSin);
    }

    public static List<LivingEntity> getTargetsInCone(World world, Vector3d start, Vector3d dir, float spreadAngle, float truncationLength) {
        double length = dir.func_72433_c();
        Vector3d dirNorm = dir.func_72432_b();
        double radius = Math.tan(spreadAngle / 2.0f) * length;
        Vector3d endLow = start.func_178787_e(dir).func_178786_a(radius, radius, radius);
        Vector3d endHigh = start.func_178787_e(dir).func_72441_c(radius, radius, radius);
        AxisAlignedBB box = new AxisAlignedBB(Utils.minInArray(start.field_72450_a, endLow.field_72450_a, endHigh.field_72450_a), Utils.minInArray(start.field_72448_b, endLow.field_72448_b, endHigh.field_72448_b), Utils.minInArray(start.field_72449_c, endLow.field_72449_c, endHigh.field_72449_c), Utils.maxInArray(start.field_72450_a, endLow.field_72450_a, endHigh.field_72450_a), Utils.maxInArray(start.field_72448_b, endLow.field_72448_b, endHigh.field_72448_b), Utils.maxInArray(start.field_72449_c, endLow.field_72449_c, endHigh.field_72449_c));
        List list = world.func_217357_a(LivingEntity.class, box);
        list.removeIf(e -> !Utils.isPointInCone(dirNorm, radius, length, truncationLength, e.func_213303_ch().func_178788_d(start)));
        return list;
    }

    public static boolean isPointInCone(Vector3d normDirection, double radius, double length, float truncationLength, Vector3d relativePoint) {
        double projectedDist = relativePoint.func_72430_b(normDirection);
        if (projectedDist < (double)truncationLength || projectedDist > length) {
            return false;
        }
        double radiusAtDist = projectedDist / length * radius;
        Vector3d orthVec = relativePoint.func_178788_d(normDirection.func_186678_a(projectedDist));
        return orthVec.func_189985_c() < radiusAtDist * radiusAtDist;
    }

    public static boolean isPointInTriangle(Vector3d tA, Vector3d tB, Vector3d tC, Vector3d point) {
        Vector3d v0 = tC.func_178788_d(tA);
        Vector3d v1 = tB.func_178788_d(tA);
        Vector3d v2 = point.func_178788_d(tA);
        return Utils.isPointInTriangle(v0, v1, v2);
    }

    private static boolean isPointInTriangle(Vector3d leg0, Vector3d leg1, Vector3d targetVec) {
        double dot00 = leg0.func_72430_b(leg0);
        double dot01 = leg0.func_72430_b(leg1);
        double dot02 = leg0.func_72430_b(targetVec);
        double dot11 = leg1.func_72430_b(leg1);
        double dot12 = leg1.func_72430_b(targetVec);
        double invDenom = 1.0 / (dot00 * dot11 - dot01 * dot01);
        double u = (dot11 * dot02 - dot01 * dot12) * invDenom;
        double v = (dot00 * dot12 - dot01 * dot02) * invDenom;
        return u >= 0.0 && v >= 0.0 && u + v < 1.0;
    }

    public static void attractEnemies(LivingEntity target, float radius) {
        Utils.attractEnemies(target, radius, null);
    }

    public static void attractEnemies(LivingEntity target, float radius, Predicate<MonsterEntity> predicate) {
        AxisAlignedBB aabb = new AxisAlignedBB(target.func_226277_ct_() - (double)radius, target.func_226278_cu_() - (double)radius, target.func_226281_cx_() - (double)radius, target.func_226277_ct_() + (double)radius, target.func_226278_cu_() + (double)radius, target.func_226281_cx_() + (double)radius);
        List list = target.func_130014_f_().func_217357_a(MonsterEntity.class, aabb);
        for (MonsterEntity mob : list) {
            if (predicate != null && !predicate.test(mob)) continue;
            mob.func_70624_b(target);
            mob.func_70625_a((Entity)target, 180.0f, 0.0f);
        }
    }

    public static boolean isHammer(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        return stack.func_77973_b().getToolTypes(stack).contains(HammerItem.HAMMER_TOOL);
    }

    public static boolean isWirecutter(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        return stack.func_77973_b().getToolTypes(stack).contains(WirecutterItem.CUTTER_TOOL);
    }

    public static boolean isScrewdriver(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        return stack.func_77973_b().getToolTypes(stack).contains(ScrewdriverItem.SCREWDRIVER_TOOL);
    }

    public static boolean canBlockDamageSource(LivingEntity entity, DamageSource damageSourceIn) {
        Vector3d vec3d;
        if (!damageSourceIn.func_76363_c() && entity.func_184585_cz() && (vec3d = damageSourceIn.func_188404_v()) != null) {
            Vector3d vec3d1 = entity.func_70676_i(1.0f);
            Vector3d vec3d2 = vec3d.func_72444_a(entity.func_213303_ch()).func_72432_b();
            vec3d2 = new Vector3d(vec3d2.field_72450_a, 0.0, vec3d2.field_72449_c);
            return vec3d2.func_72430_b(vec3d1) < 0.0;
        }
        return false;
    }

    public static Vector3d getFlowVector(World world, BlockPos pos) {
        BlockState bState = world.func_180495_p(pos);
        FluidState fState = bState.func_204520_s();
        return fState.func_215673_c((IBlockReader)world, pos);
    }

    public static double minInArray(double ... f) {
        if (f.length < 1) {
            return 0.0;
        }
        double min = f[0];
        for (int i = 1; i < f.length; ++i) {
            min = Math.min(min, f[i]);
        }
        return min;
    }

    public static double maxInArray(double ... f) {
        if (f.length < 1) {
            return 0.0;
        }
        double max = f[0];
        for (int i = 1; i < f.length; ++i) {
            max = Math.max(max, f[i]);
        }
        return max;
    }

    public static boolean isVecInEntityHead(LivingEntity entity, Vector3d vec) {
        if (entity.func_213302_cg() / entity.func_213311_cf() < 2.0f) {
            return false;
        }
        double d = vec.field_72448_b - (entity.func_226278_cu_() + (double)entity.func_70047_e());
        return Math.abs(d) < 0.25;
    }

    public static void unlockIEAdvancement(PlayerEntity player, String name) {
        if (player instanceof ServerPlayerEntity) {
            PlayerAdvancements advancements = ((ServerPlayerEntity)player).func_192039_O();
            AdvancementManager manager = ((ServerWorld)player.func_130014_f_()).func_73046_m().func_191949_aK();
            Advancement advancement = manager.func_192778_a(new ResourceLocation("immersiveengineering", name));
            if (advancement != null) {
                advancements.func_192750_a(advancement, "code_trigger");
            }
        }
    }

    public static CompoundNBT getRandomFireworkExplosion(Random rand, int preType) {
        int type;
        CompoundNBT tag = new CompoundNBT();
        CompoundNBT expl = new CompoundNBT();
        expl.func_74757_a("Flicker", true);
        expl.func_74757_a("Trail", true);
        int[] colors = new int[rand.nextInt(8) + 1];
        for (int i = 0; i < colors.length; ++i) {
            int j = rand.nextInt(11) + 1;
            if (j > 2) {
                ++j;
            }
            if (j > 6) {
                j += 2;
            }
            colors[i] = DyeColor.func_196056_a((int)j).func_196060_f();
        }
        expl.func_74783_a("Colors", colors);
        int n = type = preType >= 0 ? preType : rand.nextInt(4);
        if (preType < 0 && type == 3) {
            type = 4;
        }
        expl.func_74774_a("Type", (byte)type);
        ListNBT list = new ListNBT();
        list.add((Object)expl);
        tag.func_218657_a("Explosions", (INBT)list);
        return tag;
    }

    public static int intFromRGBA(Vector4f rgba) {
        float[] array = new float[]{rgba.func_195910_a(), rgba.func_195913_b(), rgba.func_195914_c(), rgba.func_195915_d()};
        return Utils.intFromRGBA(array);
    }

    public static int intFromRGBA(float[] rgba) {
        int ret = (int)(255.0f * rgba[3]);
        ret = (ret << 8) + (int)(255.0f * rgba[0]);
        ret = (ret << 8) + (int)(255.0f * rgba[1]);
        ret = (ret << 8) + (int)(255.0f * rgba[2]);
        return ret;
    }

    public static Vector4f vec4fFromDye(DyeColor dyeColor) {
        if (dyeColor == null) {
            return new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
        }
        float[] rgb = dyeColor.func_193349_f();
        return new Vector4f(rgb[0], rgb[1], rgb[2], 1.0f);
    }

    public static FluidStack drainFluidBlock(World world, BlockPos pos, IFluidHandler.FluidAction action) {
        BlockState b = world.func_180495_p(pos);
        FluidState f = b.func_204520_s();
        if (f.func_206889_d() && b.func_177230_c() instanceof IBucketPickupHandler) {
            if (action.execute()) {
                ((IBucketPickupHandler)b.func_177230_c()).func_204508_a((IWorld)world, pos, b);
            }
            return new FluidStack(f.func_206886_c(), 1000);
        }
        return FluidStack.EMPTY;
    }

    public static Fluid getRelatedFluid(World w, BlockPos pos) {
        return w.func_180495_p(pos).func_204520_s().func_206886_c();
    }

    public static boolean placeFluidBlock(World worldIn, BlockPos posIn, FluidStack fluidStack) {
        Fluid fluid = fluidStack.getFluid();
        if (!(fluid instanceof FlowingFluid) || fluidStack.getAmount() < 1000) {
            return false;
        }
        BlockState blockstate = worldIn.func_180495_p(posIn);
        Material material = blockstate.func_185904_a();
        boolean flag = !material.func_76220_a();
        boolean flag1 = material.func_76222_j();
        if (worldIn.func_175623_d(posIn) || flag || flag1 || blockstate.func_177230_c() instanceof ILiquidContainer && ((ILiquidContainer)blockstate.func_177230_c()).func_204510_a((IBlockReader)worldIn, posIn, blockstate, fluid)) {
            if (worldIn.func_230315_m_().func_236040_e_() && fluid.func_207185_a((ITag)FluidTags.field_206959_a)) {
                int i = posIn.func_177958_n();
                int j = posIn.func_177956_o();
                int k = posIn.func_177952_p();
                worldIn.func_184133_a(null, posIn, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.8f);
                for (int l = 0; l < 8; ++l) {
                    worldIn.func_195594_a((IParticleData)ParticleTypes.field_197594_E, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
                }
            } else if (blockstate.func_177230_c() instanceof ILiquidContainer && fluid == Fluids.field_204546_a) {
                ((ILiquidContainer)blockstate.func_177230_c()).func_204509_a((IWorld)worldIn, posIn, blockstate, ((FlowingFluid)fluid).func_207204_a(false));
            } else {
                if (!worldIn.field_72995_K && (flag || flag1) && !material.func_76224_d()) {
                    worldIn.func_175655_b(posIn, true);
                }
                worldIn.func_180501_a(posIn, fluid.func_207188_f().func_206883_i(), 11);
            }
            fluidStack.shrink(1000);
            return true;
        }
        return false;
    }

    public static BlockState getStateFromItemStack(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        if (block != Blocks.field_150350_a) {
            return block.func_176223_P();
        }
        return null;
    }

    public static boolean canInsertStackIntoInventory(CapabilityReference<IItemHandler> ref, ItemStack stack) {
        ItemStack temp = Utils.insertStackIntoInventory(ref, stack, true);
        return temp.func_190926_b() || temp.func_190916_E() < stack.func_190916_E();
    }

    public static ItemStack insertStackIntoInventory(CapabilityReference<IItemHandler> ref, ItemStack stack, boolean simulate) {
        IItemHandler handler = ref.getNullable();
        if (handler != null && !stack.func_190926_b()) {
            return ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack.func_77946_l(), (boolean)simulate);
        }
        return stack;
    }

    public static void dropStackAtPos(World world, DirectionalBlockPos pos, ItemStack stack) {
        Utils.dropStackAtPos(world, pos.getPosition(), stack, pos.getSide());
    }

    public static void dropStackAtPos(World world, BlockPos pos, ItemStack stack, @Nonnull Direction facing) {
        if (!stack.func_190926_b()) {
            ItemEntity ei = new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack.func_77946_l());
            ei.func_213293_j(0.075 * (double)facing.func_82601_c(), 0.025, 0.075 * (double)facing.func_82599_e());
            world.func_217376_c((Entity)ei);
        }
    }

    public static void dropStackAtPos(World world, BlockPos pos, ItemStack stack) {
        InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
    }

    public static ItemStack fillFluidContainer(IFluidHandler handler, ItemStack containerIn, ItemStack containerOut, @Nullable PlayerEntity player) {
        if (containerIn == null || containerIn.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        FluidActionResult result = FluidUtil.tryFillContainer((ItemStack)containerIn, (IFluidHandler)handler, (int)Integer.MAX_VALUE, (PlayerEntity)player, (boolean)false);
        if (result.isSuccess()) {
            ItemStack full = result.getResult();
            if (containerOut.func_190926_b() || ItemHandlerHelper.canItemStacksStack((ItemStack)containerOut, (ItemStack)full)) {
                if (!containerOut.func_190926_b() && containerOut.func_190916_E() + full.func_190916_E() > containerOut.func_77976_d()) {
                    return ItemStack.field_190927_a;
                }
                result = FluidUtil.tryFillContainer((ItemStack)containerIn, (IFluidHandler)handler, (int)Integer.MAX_VALUE, (PlayerEntity)player, (boolean)true);
                if (result.isSuccess()) {
                    return result.getResult();
                }
            }
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack drainFluidContainer(IFluidHandler handler, ItemStack containerIn, ItemStack containerOut) {
        FluidActionResult result;
        if (containerIn == null || containerIn.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (containerIn.func_77942_o() && containerIn.func_196082_o().isEmpty()) {
            containerIn.func_77982_d(null);
        }
        if ((result = FluidUtils.tryEmptyContainer(containerIn, handler, Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE)).isSuccess()) {
            ItemStack empty = result.getResult();
            if (containerOut.func_190926_b() || ItemHandlerHelper.canItemStacksStack((ItemStack)containerOut, (ItemStack)empty)) {
                if (!containerOut.func_190926_b() && containerOut.func_190916_E() + empty.func_190916_E() > containerOut.func_77976_d()) {
                    return ItemStack.field_190927_a;
                }
                result = FluidUtils.tryEmptyContainer(containerIn, handler, Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
                if (result.isSuccess()) {
                    return result.getResult();
                }
            }
        }
        return ItemStack.field_190927_a;
    }

    public static boolean isFluidContainerFull(ItemStack stack) {
        return FluidUtil.getFluidHandler((ItemStack)stack).map(handler -> {
            for (int t = 0; t < handler.getTanks(); ++t) {
                if (handler.getFluidInTank(t).getAmount() >= handler.getTankCapacity(t)) continue;
                return false;
            }
            return true;
        }).orElse(true);
    }

    public static boolean isFluidRelatedItemStack(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        return stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent();
    }

    public static Optional<ICraftingRecipe> findCraftingRecipe(CraftingInventory crafting, World world) {
        return world.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)crafting, world);
    }

    public static NonNullList<ItemStack> createNonNullItemStackListFromItemStack(ItemStack stack) {
        NonNullList list = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
        list.set(0, (Object)stack);
        return list;
    }

    public static float[] rotateToFacing(float[] in, Direction facing) {
        int i;
        int i2 = 0;
        while (i2 < in.length) {
            int n = i2++;
            in[n] = in[n] - 0.5f;
        }
        float[] ret = new float[in.length];
        for (i = 0; i < in.length; i += 3) {
            for (int j = 0; j < 3; ++j) {
                ret[i + j] = j == 0 ? in[i + 0] * (float)facing.func_82599_e() + in[i + 1] * (float)facing.func_82601_c() + in[i + 2] * (float)facing.func_96559_d() : (j == 1 ? in[i + 0] * (float)facing.func_82601_c() + in[i + 1] * (float)facing.func_96559_d() + in[i + 2] * (float)facing.func_82599_e() : in[i + 0] * (float)facing.func_96559_d() + in[i + 1] * (float)facing.func_82599_e() + in[i + 2] * (float)facing.func_82601_c());
            }
        }
        i = 0;
        while (i < in.length) {
            int n = i++;
            ret[n] = (float)((double)ret[n] + 0.5);
        }
        return ret;
    }

    public static int hashBlockstate(BlockState state) {
        int val = 0;
        int prime = 31;
        for (Property n : state.func_235904_r_()) {
            Comparable o = state.func_177229_b(n);
            val = 31 * val + Objects.hash(o);
        }
        return val;
    }

    public static boolean areArraysEqualIncludingBlockstates(Object[] a, Object[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            Object o1 = a[i];
            Object o2 = a2[i];
            if (o1 != null ? o1.equals(o2) : o2 == null) continue;
            return false;
        }
        return true;
    }

    public static boolean isVecInBlock(Vector3d vec3d, BlockPos pos, BlockPos offset, double eps) {
        return vec3d.field_72450_a >= (double)(pos.func_177958_n() - offset.func_177958_n()) - eps && vec3d.field_72450_a <= (double)(pos.func_177958_n() - offset.func_177958_n() + 1) + eps && vec3d.field_72448_b >= (double)(pos.func_177956_o() - offset.func_177956_o()) - eps && vec3d.field_72448_b <= (double)(pos.func_177956_o() - offset.func_177956_o() + 1) + eps && vec3d.field_72449_c >= (double)(pos.func_177952_p() - offset.func_177952_p()) - eps && vec3d.field_72449_c <= (double)(pos.func_177952_p() - offset.func_177952_p() + 1) + eps;
    }

    public static Vector3d withCoordinate(Vector3d vertex, Direction.Axis axis, double value) {
        switch (axis) {
            case X: {
                return new Vector3d(value, vertex.field_72448_b, vertex.field_72449_c);
            }
            case Y: {
                return new Vector3d(vertex.field_72450_a, value, vertex.field_72449_c);
            }
            case Z: {
                return new Vector3d(vertex.field_72450_a, vertex.field_72448_b, value);
            }
        }
        return vertex;
    }

    public static BlockPos rayTraceForFirst(Vector3d start, Vector3d end, World w, Set<BlockPos> ignore) {
        Set<BlockPos> trace = Raytracer.rayTrace(start, end, w);
        for (BlockPos cc : ignore) {
            trace.remove(cc);
        }
        if (start.field_72450_a != end.field_72450_a) {
            trace = Utils.findMinOrMax(trace, start.field_72450_a > end.field_72450_a, 0);
        }
        if (start.field_72448_b != end.field_72448_b) {
            trace = Utils.findMinOrMax(trace, start.field_72448_b > end.field_72448_b, 0);
        }
        if (start.field_72449_c != end.field_72449_c) {
            trace = Utils.findMinOrMax(trace, start.field_72449_c > end.field_72449_c, 0);
        }
        if (trace.size() > 0) {
            return trace.iterator().next();
        }
        return null;
    }

    public static Set<BlockPos> findMinOrMax(Set<BlockPos> in, boolean max, int coord) {
        int curr;
        HashSet<BlockPos> ret = new HashSet<BlockPos>();
        int currMinMax = max ? Integer.MIN_VALUE : Integer.MAX_VALUE;
        for (BlockPos cc : in) {
            curr = coord == 0 ? cc.func_177958_n() : (coord == 1 ? cc.func_177956_o() : cc.func_177956_o());
            if (!(max ^ curr < currMinMax)) continue;
            currMinMax = curr;
        }
        for (BlockPos cc : in) {
            curr = coord == 0 ? cc.func_177958_n() : (coord == 1 ? cc.func_177956_o() : cc.func_177952_p());
            if (curr != currMinMax) continue;
            ret.add(cc);
        }
        return ret;
    }

    public static TileEntity getExistingTileEntity(World world, BlockPos pos) {
        if (world == null) {
            return null;
        }
        if (world.func_175667_e(pos)) {
            return world.func_175625_s(pos);
        }
        return null;
    }

    @Deprecated
    public static NonNullList<ItemStack> readInventory(ListNBT nbt, int size) {
        NonNullList inv = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
        int max = nbt.size();
        for (int i = 0; i < max; ++i) {
            CompoundNBT itemTag = nbt.func_150305_b(i);
            int slot = itemTag.func_74771_c("Slot") & 0xFF;
            if (slot < 0 || slot >= size) continue;
            inv.set(slot, (Object)ItemStack.func_199557_a((CompoundNBT)itemTag));
        }
        return inv;
    }

    @Deprecated
    public static ListNBT writeInventory(ItemStack[] inv) {
        ListNBT invList = new ListNBT();
        for (int i = 0; i < inv.length; ++i) {
            if (inv[i].func_190926_b()) continue;
            CompoundNBT itemTag = new CompoundNBT();
            itemTag.func_74774_a("Slot", (byte)i);
            inv[i].func_77955_b(itemTag);
            invList.add((Object)itemTag);
        }
        return invList;
    }

    @Deprecated
    public static ListNBT writeInventory(Collection<ItemStack> inv) {
        ListNBT invList = new ListNBT();
        byte slot = 0;
        for (ItemStack s : inv) {
            if (!s.func_190926_b()) {
                CompoundNBT itemTag = new CompoundNBT();
                itemTag.func_74774_a("Slot", slot);
                s.func_77955_b(itemTag);
                invList.add((Object)itemTag);
            }
            slot = (byte)(slot + 1);
        }
        return invList;
    }

    @Deprecated
    public static NonNullList<ItemStack> loadItemStacksFromNBT(INBT nbt) {
        NonNullList itemStacks = NonNullList.func_191196_a();
        if (nbt instanceof CompoundNBT) {
            ItemStack stack = ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)nbt));
            itemStacks.add((Object)stack);
            return itemStacks;
        }
        if (nbt instanceof ListNBT) {
            ListNBT list = (ListNBT)nbt;
            return Utils.readInventory(list, list.size());
        }
        return itemStacks;
    }

    public static void modifyInvStackSize(NonNullList<ItemStack> inv, int slot, int amount) {
        if (slot >= 0 && slot < inv.size() && !((ItemStack)inv.get(slot)).func_190926_b()) {
            ((ItemStack)inv.get(slot)).func_190917_f(amount);
            if (((ItemStack)inv.get(slot)).func_190916_E() <= 0) {
                inv.set(slot, (Object)ItemStack.field_190927_a);
            }
        }
    }

    public static void shuffleLootItems(List<ItemStack> stacks, int slotAmount, Random rand) {
        ArrayList list = Lists.newArrayList();
        Iterator<ItemStack> iterator = stacks.iterator();
        while (iterator.hasNext()) {
            ItemStack itemstack = iterator.next();
            if (itemstack.func_190916_E() <= 0) {
                iterator.remove();
                continue;
            }
            if (itemstack.func_190916_E() <= 1) continue;
            list.add(itemstack);
            iterator.remove();
        }
        slotAmount -= stacks.size();
        while (slotAmount > 0 && list.size() > 0) {
            ItemStack itemstack2 = (ItemStack)list.remove(MathHelper.func_76136_a((Random)rand, (int)0, (int)(list.size() - 1)));
            int i = MathHelper.func_76136_a((Random)rand, (int)1, (int)(itemstack2.func_190916_E() / 2));
            itemstack2.func_190918_g(i);
            ItemStack itemstack1 = itemstack2.func_77946_l();
            itemstack1.func_190920_e(i);
            if (itemstack2.func_190916_E() > 1 && rand.nextBoolean()) {
                list.add(itemstack2);
            } else {
                stacks.add(itemstack2);
            }
            if (itemstack1.func_190916_E() > 1 && rand.nextBoolean()) {
                list.add(itemstack1);
                continue;
            }
            stacks.add(itemstack1);
        }
        stacks.addAll(list);
        Collections.shuffle(stacks, rand);
    }

    public static int calcRedstoneFromInventory(IIEInventory inv) {
        if (inv == null) {
            return 0;
        }
        int max = inv.getComparatedSize();
        int i = 0;
        float f = 0.0f;
        for (int j = 0; j < max; ++j) {
            ItemStack itemstack = (ItemStack)inv.getInventory().get(j);
            if (itemstack.func_190926_b()) continue;
            f += (float)itemstack.func_190916_E() / (float)Math.min(inv.getSlotLimit(j), itemstack.func_77976_d());
            ++i;
        }
        return MathHelper.func_76141_d((float)((f /= (float)max) * 14.0f)) + (i > 0 ? 1 : 0);
    }

    public static List<ItemStack> getDrops(BlockState state, LootContext.Builder builder) {
        ResourceLocation resourcelocation = state.func_177230_c().func_220068_i();
        if (resourcelocation == LootTables.field_186419_a) {
            return Collections.emptyList();
        }
        LootContext lootcontext = builder.func_216015_a(LootParameters.field_216287_g, (Object)state).func_216022_a(LootParameterSets.field_216267_h);
        ServerWorld serverworld = lootcontext.func_202879_g();
        LootTable loottable = serverworld.func_73046_m().func_200249_aQ().func_186521_a(resourcelocation);
        return loottable.func_216113_a(lootcontext);
    }

    public static ItemStack getPickBlock(BlockState state, RayTraceResult rtr, PlayerEntity player) {
        IBlockReader w = Utils.getSingleBlockWorldAccess(state);
        return state.func_177230_c().getPickBlock(state, rtr, w, BlockPos.field_177992_a, player);
    }

    public static List<AxisAlignedBB> flipBoxes(boolean flipFront, boolean flipRight, List<AxisAlignedBB> boxes) {
        return Utils.flipBoxes(flipFront, flipRight, boxes.toArray(new AxisAlignedBB[0]));
    }

    public static List<AxisAlignedBB> flipBoxes(boolean flipFront, boolean flipRight, AxisAlignedBB ... boxes) {
        ArrayList<AxisAlignedBB> ret = new ArrayList<AxisAlignedBB>(boxes.length);
        for (AxisAlignedBB aabb : boxes) {
            ret.add(Utils.flipBox(flipFront, flipRight, aabb));
        }
        return ret;
    }

    public static AxisAlignedBB flipBox(boolean flipFront, boolean flipRight, AxisAlignedBB aabb) {
        AxisAlignedBB result = aabb;
        if (flipRight) {
            result = new AxisAlignedBB(1.0 - result.field_72336_d, result.field_72338_b, result.field_72339_c, 1.0 - result.field_72340_a, result.field_72337_e, result.field_72334_f);
        }
        if (flipFront) {
            result = new AxisAlignedBB(result.field_72340_a, result.field_72338_b, 1.0 - result.field_72334_f, result.field_72336_d, result.field_72337_e, 1.0 - result.field_72339_c);
        }
        return result;
    }

    public static IBlockReader getSingleBlockWorldAccess(BlockState state) {
        return new SingleBlockAcess(state);
    }

    private static class SingleBlockAcess
    implements IBlockReader {
        BlockState state;

        public SingleBlockAcess(BlockState state) {
            this.state = state;
        }

        @Nullable
        public TileEntity func_175625_s(@Nonnull BlockPos pos) {
            return null;
        }

        @Nonnull
        public BlockState func_180495_p(@Nonnull BlockPos pos) {
            return pos.equals((Object)BlockPos.field_177992_a) ? this.state : Blocks.field_150350_a.func_176223_P();
        }

        @Nonnull
        public FluidState func_204610_c(@Nonnull BlockPos blockPos) {
            return this.func_180495_p(blockPos).func_204520_s();
        }

        public int func_201572_C() {
            return 0;
        }
    }

    public static class InventoryCraftingFalse
    extends CraftingInventory {
        private static final Container nullContainer = new Container(ContainerType.field_221518_l, 0){

            public void func_75130_a(IInventory paramIInventory) {
            }

            public boolean func_75145_c(@Nonnull PlayerEntity playerIn) {
                return false;
            }
        };

        public InventoryCraftingFalse(int w, int h) {
            super(nullContainer, w, h);
        }

        public static CraftingInventory createFilledCraftingInventory(int w, int h, NonNullList<ItemStack> stacks) {
            InventoryCraftingFalse invC = new InventoryCraftingFalse(w, h);
            for (int j = 0; j < w * h; ++j) {
                if (((ItemStack)stacks.get(j)).func_190926_b()) continue;
                invC.func_70299_a(j, ((ItemStack)stacks.get(j)).func_77946_l());
            }
            return invC;
        }
    }
}

